/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IntVR;

public class TransformDialog
extends guiDialog {
    private static final long serialVersionUID = 1063878245649086790L;
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private final UnitPoint3D d_objCenter;
    private final JButton d_useCenterForBase;
    private final guiRadioButton d_copyButton;
    private final guiRadioButton d_moveButton;
    private final ValueField<Integer> d_numCopiesField;
    private final guiPanel d_modePanel;
    private final JButton d_previewButton;
    private final Observer d_changedObserver;
    private final boolean d_previewEnabled;
    private boolean d_transformDirty = true;
    private boolean d_transformed = false;
    private final int d_maxNumCopies;

    protected void setBase(UnitPoint3D base) {
    }

    protected boolean isIdentityTransform() {
        return false;
    }

    protected TransformTask taskTransform(Collection<? extends IPyroObject> objs) {
        return null;
    }

    public TransformDialog(String title, PyroMod mediator, Collection<? extends IPyroObject> objs, boolean includeNumCopiesField, boolean supportPreview) {
        super((Window)Application.getApp().getActiveFrame(), title, 9);
        this.d_mediator = mediator;
        this.d_previewEnabled = supportPreview;
        this.d_objs = objs;
        this.d_maxNumCopies = includeNumCopiesField ? Integer.MAX_VALUE : 1;
        this.d_objCenter = GeomUtil.getCenter(Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class));
        this.d_useCenterForBase = new JButton(Intl.intl("Use Center"));
        this.d_useCenterForBase.setToolTipText("Use the center of the selected objects as the base.");
        this.d_useCenterForBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransformDialog.this.setBase(TransformDialog.this.d_objCenter);
            }
        });
        this.d_copyButton = new guiRadioButton(Intl.intl("Copy"));
        this.d_moveButton = new guiRadioButton(this.getTransformTypeName());
        ButtonGroup modeGroup = new ButtonGroup();
        modeGroup.add(this.d_copyButton);
        modeGroup.add(this.d_moveButton);
        this.d_numCopiesField = ValueFields.intFld(1, IntVR.above(1, true));
        guiLabel numCopiesLab = new guiLabel(Intl.intl("Number of Copies") + ":");
        LinkStatus.link((AbstractButton)this.d_copyButton, this.d_numCopiesField, numCopiesLab);
        MigLayout layout = new MigLayout("insets 0, gap 6, fill");
        this.d_modePanel = new guiPanel(layout);
        TitleSeparator modeSep = new TitleSeparator(Intl.intl("Mode"));
        this.d_modePanel.add((Component)modeSep, "growx, span, wrap");
        MigLayout copyLayout = new MigLayout("insets 0, gap 6");
        guiPanel copyPanel = new guiPanel(copyLayout);
        copyPanel.add((Component)this.d_moveButton, "gapleft 12, wrap");
        copyPanel.add((Component)this.d_copyButton, "gapleft 12");
        if (this.d_maxNumCopies > 1) {
            copyPanel.add((Component)numCopiesLab, "width 100::");
            copyPanel.add(this.d_numCopiesField);
        }
        this.d_modePanel.add(copyPanel);
        this.d_moveButton.setSelected(true);
        if (supportPreview) {
            this.d_previewButton = new JButton(new AbstractAction(Intl.intl("Preview")){
                private static final long serialVersionUID = -8495383746911170601L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TransformDialog.this.validateData(true, true)) {
                        TransformDialog.this.transform();
                    }
                }
            });
            this.addButton(this.d_previewButton);
            this.d_changedObserver = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    TransformDialog.this.transformChanged();
                }
            };
            this.getDialogPane().addObserver(this.d_changedObserver);
        } else {
            this.d_changedObserver = null;
            this.d_previewButton = null;
        }
    }

    protected void init() {
        this.setBase(this.d_objCenter);
        if (this.d_previewEnabled) {
            this.updatePreviewableStatus(true);
        }
    }

    protected IDOF getDOF() {
        return GeomUtil.getDOF(Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class));
    }

    protected String getTaskDesc() {
        return Intl.intl(this.getTransformTypeName() + " Objects");
    }

    protected String getTransformTypeName() {
        return Intl.intl("Transform");
    }

    public int getNumCopies() {
        if (this.d_copyButton.isSelected()) {
            if (this.d_maxNumCopies == 1) {
                return 1;
            }
            return (Integer)this.d_numCopiesField.getValue();
        }
        return 0;
    }

    protected guiPanel getModePanel() {
        return this.d_modePanel;
    }

    protected PyroMod getMediator() {
        return this.d_mediator;
    }

    protected JButton getCenterForBaseButton() {
        return this.d_useCenterForBase;
    }

    private void updatePreviewableStatus(boolean canPreview) {
        if (!this.d_previewEnabled) {
            return;
        }
        boolean enabled = canPreview;
        this.d_previewButton.setEnabled(enabled);
    }

    private void transformChanged() {
        if (!this.d_previewEnabled) {
            return;
        }
        this.d_transformDirty = true;
        this.updatePreviewableStatus(true);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        this.getDialogPane().removeObserver(this.d_changedObserver);
        boolean result = super.validateData(showWarn, allowModify);
        this.getDialogPane().addObserver(this.d_changedObserver);
        if (!result) {
            return false;
        }
        TransformTask task = this.taskTransform(this.d_objs);
        int numIterations = Math.max(1, this.getNumCopies());
        for (int m = 0; m < numIterations; ++m) {
            ITransform xform = task.getXFormForIteration(m + 1);
            IDOF dof = this.getDOF();
            if (xform.getInfo().isAccepted(dof)) continue;
            if (showWarn) {
                LinkedHashSet<String> rules = new LinkedHashSet<String>();
                dof.describeRules(rules);
                Object msg = Intl.intl("The transformation must obey the following rules:");
                for (String rule : rules) {
                    msg = (String)msg + "\n    " + rule;
                }
                TransformDialog.showInvalidEntryMessage(this, (String)msg);
            }
            return false;
        }
        return true;
    }

    private void transform() {
        if (!this.d_transformDirty) {
            return;
        }
        this.cancelTransform();
        TransformTask tsk = this.taskTransform(this.d_objs);
        if (tsk == null) {
            return;
        }
        this.getMediator().getTaskManager().exec(tsk, this.getTaskDesc());
        this.d_transformDirty = false;
        this.d_transformed = true;
        this.updatePreviewableStatus(false);
    }

    private void cancelTransform() {
        if (!this.d_transformed) {
            return;
        }
        this.getMediator().getTaskManager().undo();
        this.d_transformed = false;
        this.d_transformDirty = true;
    }

    protected JButton getPreviewButton() {
        return this.d_previewButton;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            this.transform();
        } else {
            this.cancelTransform();
        }
        return result;
    }
}

