/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class NodeLossDialog
extends guiDialog {
    private static final long serialVersionUID = -9104088842241941997L;
    private final guiTable d_lossTable;
    protected final guiTableEditor d_editor;
    private String[] d_colHeader;

    public NodeLossDialog(Window owner, String[] columnHeader, Class[] columnClasses) {
        super(owner, Intl.intl("Node Loss Editor"), 9);
        int i;
        this.d_colHeader = columnHeader;
        this.d_lossTable = NodeLossDialog.createTable(columnHeader, columnClasses, columnHeader.length - 1);
        this.d_lossTable.setColumnEditable(0, false);
        guiTable.UnitDoubleEditor cellEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getUnitlessUnit());
        this.d_lossTable.setDefaultEditor(UnitDouble.class, cellEditor);
        if (columnHeader.length > 1) {
            for (i = 0; i < columnHeader.length - 1; ++i) {
                this.d_lossTable.setValueAt(columnHeader[i + 1], i, 0);
            }
        }
        for (i = 0; i < columnHeader.length; ++i) {
            this.d_lossTable.setValueAt(new UnitDouble(0.0, Unit.ONE), i, i + 1);
        }
        this.d_editor = new guiTableEditor(this.d_lossTable, 0);
        GridBagHelper gb = new GridBagHelper(this.getDialogPane(), true);
        gb.addRow(this.d_editor);
        gb.addRow(new guiLabel(Intl.intl("Losses are read from column to row.")));
    }

    private static guiTable createTable(String[] columnHeaders, Class[] columnClasses, int rows) {
        if (columnHeaders.length != columnClasses.length) {
            throw new IllegalArgumentException("Must have same number of column headers as column classes.");
        }
        guiDefaultTableModel model = new guiDefaultTableModel(rows, columnHeaders.length, false, rows, false, columnHeaders.length){
            private static final long serialVersionUID = 1036391040630374576L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return row + 1 != column;
            }
        };
        final NoDiagEditsRenderer rend = new NoDiagEditsRenderer();
        guiTable table = new guiTable((TableModel)model, 0){
            private static final long serialVersionUID = 2639925487622037469L;

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                TableCellRenderer defaultRenderer = super.getCellRenderer(row, column);
                rend.setDefaultRenderer(defaultRenderer);
                return rend;
            }
        };
        TableColumnModel tcm = table.getColumnModel();
        for (int i = 0; i < columnHeaders.length; ++i) {
            tcm.getColumn(i).setHeaderValue(columnHeaders[i]);
            model.setColumnClass(i, columnClasses[i]);
        }
        return table;
    }

    public void loadLosses(ModelComposite ductRoot, List<HvacDuctLoss> losses) {
        guiDefaultTableModel mod = (guiDefaultTableModel)this.d_lossTable.getModel();
        if (losses.isEmpty()) {
            return;
        }
        HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble> lossMap = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>();
        for (HvacDuctLoss hdl : losses) {
            lossMap.put(new Pair<HvacDuct, HvacDuct>(hdl.duct1, hdl.duct2), hdl.fwdLoss);
            lossMap.put(new Pair<HvacDuct, HvacDuct>(hdl.duct2, hdl.duct1), hdl.revLoss);
        }
        for (int i = 1; i < this.d_colHeader.length; ++i) {
            HvacDuct toDuct = NodeLossDialog.findDuctByName(ductRoot, this.d_colHeader[i]);
            for (int j = 1; j < this.d_colHeader.length; ++j) {
                HvacDuct fromDuct = NodeLossDialog.findDuctByName(ductRoot, this.d_colHeader[j]);
                Pair<HvacDuct, HvacDuct> key = new Pair<HvacDuct, HvacDuct>(fromDuct, toDuct);
                UnitDouble loss = (UnitDouble)lossMap.get(key);
                if (loss == null) {
                    loss = new UnitDouble(0.0, Unit.ONE);
                }
                mod.setValueAt(loss, i - 1, j);
            }
        }
    }

    public List<HvacDuctLoss> getLosses(ModelComposite ductRoot, HvacNode node) {
        ArrayList<HvacDuctLoss> losses = new ArrayList<HvacDuctLoss>();
        guiDefaultTableModel mod = (guiDefaultTableModel)this.d_lossTable.getModel();
        for (int i = 1; i < this.d_colHeader.length; ++i) {
            HvacDuct toDuct = NodeLossDialog.findDuctByName(ductRoot, this.d_colHeader[i]);
            for (int j = i + 1; j < this.d_colHeader.length; ++j) {
                HvacDuct fromDuct = NodeLossDialog.findDuctByName(ductRoot, this.d_colHeader[j]);
                UnitDouble fwdValue = (UnitDouble)mod.getValueAt(i - 1, j);
                UnitDouble revValue = (UnitDouble)mod.getValueAt(j - 1, i);
                if (!NodeLossDialog.isLoss(fwdValue) && !NodeLossDialog.isLoss(revValue)) continue;
                losses.add(new HvacDuctLoss(node, fromDuct, toDuct, NodeLossDialog.finalizeLoss(fwdValue), NodeLossDialog.finalizeLoss(revValue)));
            }
        }
        return losses;
    }

    private static HvacDuct findDuctByName(ModelComposite hvacs, String ductName) {
        return hvacs.find(ductName, HvacDuct.class, true);
    }

    private static boolean isLoss(UnitDouble val) {
        return val != null && val.getValueNoUnit() != 0.0;
    }

    private static UnitDouble finalizeLoss(UnitDouble val) {
        return val == null ? new UnitDouble(0.0, Unit.ONE) : val;
    }

    private static class NoDiagEditsRenderer
    implements TableCellRenderer {
        private TableCellRenderer d_defaultRenderer;
        Color[] d_colors;

        public void setDefaultRenderer(TableCellRenderer rend) {
            this.d_defaultRenderer = rend;
        }

        public NoDiagEditsRenderer() {
            guiTextField fld = new guiTextField();
            this.d_colors = new Color[4];
            this.d_colors[0] = fld.getForeground();
            this.d_colors[1] = fld.getBackground();
            fld.setEditable(false);
            this.d_colors[2] = fld.getForeground();
            this.d_colors[3] = fld.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rend = null;
            if (row + 1 != column) {
                rend = this.d_defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                rend.setForeground(this.d_colors[0]);
                rend.setBackground(this.d_colors[1]);
            } else {
                rend = this.d_defaultRenderer.getTableCellRendererComponent(table, null, isSelected, false, row, column);
                rend.setForeground(this.d_colors[2]);
                rend.setBackground(this.d_colors[3]);
            }
            return rend;
        }
    }
}

