/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.vecmath.Point3d;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class AABoxGeomEditor
extends guiPanel
implements IGeomEditor<AABoxGeom> {
    private static final long serialVersionUID = 7480869622284435689L;
    public static final String[] FACE_NAMES = new String[6];
    private final ValueField<UnitDouble> d_minX;
    private final ValueField<UnitDouble> d_minY;
    private final ValueField<UnitDouble> d_minZ;
    private final ValueField<UnitDouble> d_maxX;
    private final ValueField<UnitDouble> d_maxY;
    private final ValueField<UnitDouble> d_maxZ;
    private final boolean d_equalAllowed;

    public AABoxGeomEditor(boolean emptyAllowed, boolean equalAllowed) {
        this(emptyAllowed, equalAllowed, false);
    }

    public AABoxGeomEditor(boolean emptyAllowed, boolean equalAllowed, boolean useMigLayout) {
        this.d_equalAllowed = equalAllowed;
        this.d_minX = AABoxGeomEditor.newValueField(emptyAllowed, 0.0, SI.METER);
        this.d_minY = AABoxGeomEditor.newValueField(emptyAllowed, 0.0, SI.METER);
        this.d_minZ = AABoxGeomEditor.newValueField(emptyAllowed, 0.0, SI.METER);
        this.d_maxX = AABoxGeomEditor.newValueField(emptyAllowed, 1.0, SI.METER);
        this.d_maxY = AABoxGeomEditor.newValueField(emptyAllowed, 1.0, SI.METER);
        this.d_maxZ = AABoxGeomEditor.newValueField(emptyAllowed, 1.0, SI.METER);
        if (useMigLayout) {
            AABoxGeomEditor.layoutMig(this);
        } else {
            AABoxGeomEditor.layoutGridBagUtil(this);
        }
        this.setFocusTraversalPolicy(new BoxTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
    }

    private static void layoutGridBagUtil(AABoxGeomEditor pnl) {
        pnl.setLayout(new GridBagLayout());
        guiLabel x1Lab = new guiLabel(Intl.intl("Min X:"));
        guiLabel y1Lab = new guiLabel(Intl.intl("Min Y:"));
        guiLabel z1Lab = new guiLabel(Intl.intl("Min Z:"));
        guiLabel x2Lab = new guiLabel(Intl.intl("Max X:"));
        guiLabel y2Lab = new guiLabel(Intl.intl("Max Y:"));
        guiLabel z2Lab = new guiLabel(Intl.intl("Max Z:"));
        GridBagUtil.add(pnl, x1Lab, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, pnl.d_minX, 1, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, y1Lab, 2, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, pnl.d_minY, 3, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, z1Lab, 4, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, pnl.d_minZ, 5, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, x2Lab, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, pnl.d_maxX, 1, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, y2Lab, 2, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, pnl.d_maxY, 3, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, z2Lab, 4, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(pnl, pnl.d_maxZ, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(pnl);
    }

    private static void layoutMig(AABoxGeomEditor pnl) {
        pnl.setLayout(new MigLayout("insets 0"));
        guiLabel x1Lab = new guiLabel(Intl.intl("Min X:"));
        guiLabel y1Lab = new guiLabel(Intl.intl("Min Y:"));
        guiLabel z1Lab = new guiLabel(Intl.intl("Min Z:"));
        guiLabel x2Lab = new guiLabel(Intl.intl("Max X:"));
        guiLabel y2Lab = new guiLabel(Intl.intl("Max Y:"));
        guiLabel z2Lab = new guiLabel(Intl.intl("Max Z:"));
        pnl.add((Component)x1Lab, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
        pnl.add(pnl.d_minX, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
        pnl.add((Component)y1Lab, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
        pnl.add(pnl.d_minY, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
        pnl.add((Component)z1Lab, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
        pnl.add(pnl.d_minZ, "gaptop 0, gapleft 0, gapbottom 3, gapright 0, wrap");
        pnl.add((Component)x2Lab, "gaptop 0, gapleft 0, gapbottom 0, gapright 6");
        pnl.add(pnl.d_maxX, "gaptop 0, gapleft 0, gapbottom 0, gapright 6");
        pnl.add((Component)y2Lab, "gaptop 0, gapleft 0, gapbottom 0, gapright 6");
        pnl.add(pnl.d_maxY, "gaptop 0, gapleft 0, gapbottom 0, gapright 6");
        pnl.add((Component)z2Lab, "gaptop 0, gapleft 0, gapbottom 0, gapright 6");
        pnl.add(pnl.d_maxZ, "gaptop 0, gapleft 0, gapbottom 0, gapright 0, wrap");
    }

    @Override
    public String[] getFaceNames() {
        return FACE_NAMES;
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geomNode) {
        IGeom geom = geomNode.getLocalGeom();
        if (!(geom instanceof AABoxGeom)) {
            return null;
        }
        AABoxGeom box = (AABoxGeom)geom;
        return box.isNaturallyOrdered() ? null : box.getNameToIndexFaceOrder();
    }

    public ValueField[] getMinFields() {
        return new ValueField[]{this.d_minX, this.d_minY, this.d_minZ};
    }

    public ValueField[] getMaxFields() {
        return new ValueField[]{this.d_maxX, this.d_maxY, this.d_maxZ};
    }

    private static ValueField newValueField(boolean emptyAllowed, double initVal, Unit srcUnit) {
        ValueField<UnitDouble> vf = ValueFields.udFld(initVal, srcUnit, UnitSystem.getSource(0));
        vf.setColumns(8);
        vf.setNullAllowed(emptyAllowed);
        return vf;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Box");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    public void addPropertyChangeListeners(PropertyChangeListener listener) {
        this.d_minX.addValueChangeListener(listener);
        this.d_minY.addValueChangeListener(listener);
        this.d_minZ.addValueChangeListener(listener);
        this.d_maxX.addValueChangeListener(listener);
        this.d_maxY.addValueChangeListener(listener);
        this.d_maxZ.addValueChangeListener(listener);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] props = GeomGuiUtil.getDataVals(geoms, new AABoxProp(), 6, Geometry.LU);
        this.d_minX.setValue(props[0]);
        this.d_minY.setValue(props[1]);
        this.d_minZ.setValue(props[2]);
        this.d_maxX.setValue(props[3]);
        this.d_maxY.setValue(props[4]);
        this.d_maxZ.setValue(props[5]);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] vals = new UnitDouble[]{(UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue(), (UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue()};
        GeomGuiUtil.setDataVals(geoms, new AABoxProp(), Geometry.LU, vals);
    }

    public void load(AABoxGeom aab) {
        if (aab == null) {
            this.d_minX.setValue(null);
            this.d_minY.setValue(null);
            this.d_minZ.setValue(null);
            this.d_maxX.setValue(null);
            this.d_maxY.setValue(null);
            this.d_maxZ.setValue(null);
            return;
        }
        Unit lu = Geometry.LU;
        this.d_minX.setValue(new UnitDouble(aab.min.x, lu));
        this.d_minY.setValue(new UnitDouble(aab.min.y, lu));
        this.d_minZ.setValue(new UnitDouble(aab.min.z, lu));
        this.d_maxX.setValue(new UnitDouble(aab.max.x, lu));
        this.d_maxY.setValue(new UnitDouble(aab.max.y, lu));
        this.d_maxZ.setValue(new UnitDouble(aab.max.z, lu));
    }

    public AABoxGeom save() {
        if (this.d_minX.isEmpty() || this.d_minY.isEmpty() || this.d_minZ.isEmpty() || this.d_maxX.isEmpty() || this.d_maxY.isEmpty() || this.d_maxZ.isEmpty()) {
            return null;
        }
        UnitPoint3D p1 = new UnitPoint3D((UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue());
        UnitPoint3D p2 = new UnitPoint3D((UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue());
        return new AABoxGeom(p1.getPoint3dValue(Geometry.LU), p2.getPoint3dValue(Geometry.LU));
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        if (!this.validate(geoms, this.d_minX, this.d_maxX, 0, 3, Intl.intl("X"), showWarn, allowModify)) {
            return false;
        }
        if (!this.validate(geoms, this.d_minY, this.d_maxY, 1, 4, Intl.intl("Y"), showWarn, allowModify)) {
            return false;
        }
        return this.validate(geoms, this.d_minZ, this.d_maxZ, 2, 5, Intl.intl("Z"), showWarn, allowModify);
    }

    private boolean validate(Collection<? extends IPyroGeomSrc> geoms, ValueField min, ValueField max, int minix, int maxix, String dim, boolean showWarn, boolean allowModify) {
        String minLbl = String.format(Intl.intl("Min %s"), dim);
        String maxLbl = String.format(Intl.intl("Max %s"), dim);
        return GeomGuiUtil.validateMinMax(this.getParent(), min, max, minLbl, maxLbl, this.d_equalAllowed, new AABoxProp(), minix, maxix, geoms, showWarn, allowModify);
    }

    static {
        AABoxGeomEditor.FACE_NAMES[0] = Intl.intl("Min X");
        AABoxGeomEditor.FACE_NAMES[1] = Intl.intl("Max X");
        AABoxGeomEditor.FACE_NAMES[2] = Intl.intl("Min Y");
        AABoxGeomEditor.FACE_NAMES[3] = Intl.intl("Max Y");
        AABoxGeomEditor.FACE_NAMES[4] = Intl.intl("Min Z");
        AABoxGeomEditor.FACE_NAMES[5] = Intl.intl("Max Z");
    }

    private class BoxTraversalPolicy
    extends FocusTraversalPolicy {
        private BoxTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent.equals(AABoxGeomEditor.this.d_minX)) {
                return AABoxGeomEditor.this.d_maxX;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_maxX)) {
                if (AABoxGeomEditor.this.d_minY.isEnabled()) {
                    return AABoxGeomEditor.this.d_minY;
                }
                return AABoxGeomEditor.this.d_minZ;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_minY)) {
                return AABoxGeomEditor.this.d_maxY;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_maxY)) {
                if (AABoxGeomEditor.this.d_minZ.isEnabled()) {
                    return AABoxGeomEditor.this.d_minZ;
                }
                return null;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_minZ)) {
                return AABoxGeomEditor.this.d_maxZ;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_maxZ)) {
                return null;
            }
            return AABoxGeomEditor.this.d_minX.isEnabled() ? AABoxGeomEditor.this.d_minX : AABoxGeomEditor.this.d_minY;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent.equals(AABoxGeomEditor.this.d_minX)) {
                return null;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_maxX)) {
                return AABoxGeomEditor.this.d_minX;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_minY)) {
                if (AABoxGeomEditor.this.d_maxX.isEnabled()) {
                    return AABoxGeomEditor.this.d_maxX;
                }
                return null;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_maxY)) {
                return AABoxGeomEditor.this.d_minY;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_minZ)) {
                if (AABoxGeomEditor.this.d_maxY.isEnabled()) {
                    return AABoxGeomEditor.this.d_maxY;
                }
                return AABoxGeomEditor.this.d_maxX;
            }
            if (aComponent.equals(AABoxGeomEditor.this.d_maxZ)) {
                return AABoxGeomEditor.this.d_minZ;
            }
            return AABoxGeomEditor.this.d_minX.isEnabled() ? AABoxGeomEditor.this.d_minX : AABoxGeomEditor.this.d_minY;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return this.getFirstComponent(aContainer);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            if (AABoxGeomEditor.this.d_minX.isEnabled()) {
                return AABoxGeomEditor.this.d_minX;
            }
            return AABoxGeomEditor.this.d_minY;
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            if (AABoxGeomEditor.this.d_maxZ.isEnabled()) {
                return AABoxGeomEditor.this.d_maxZ;
            }
            return AABoxGeomEditor.this.d_maxY;
        }
    }

    private static class AABoxProp
    extends GeomGuiUtil.AGeomProp<AABoxGeom> {
        @Override
        protected AABoxGeom constructGeom(AABoxGeom arg0, double[] data) {
            return new AABoxGeom(new Point3d(data[0], data[1], data[2]), new Point3d(data[3], data[4], data[5]), arg0.swizzle, arg0.cw);
        }

        @Override
        protected double[] saveData(AABoxGeom geom) {
            return new double[]{geom.min.x, geom.min.y, geom.min.z, geom.max.x, geom.max.y, geom.max.z};
        }
    }
}

