/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.image.PDFConverter;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Pair;

public class ImageLoader
implements BGImageDlg.IImageLoader {
    private Window d_dlgParent;

    @Override
    public File choose(Component parent, File currFile) {
        this.d_dlgParent = (Window)parent;
        guiJFXFileChooser chooser = new guiJFXFileChooser(currFile != null ? currFile.getName() : null, currFile != null ? currFile.getAbsolutePath() : PyroPrefs.get(PyroPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, FileFilters.EXT_FILTER_BMP, FileFilters.EXT_FILTER_GIF, FileFilters.EXT_FILTER_JPEG_ALL, FileFilters.EXT_FILTER_PNG, FileFilters.EXT_FILTER_PDF, FileFilters.EXT_FILTER_TIFF, FileFilters.EXT_FILTER_TARGA);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return null;
        }
        PyroPrefs.set(PyroPrefs.OPEN_DIR_PREF, f.getParent());
        return f;
    }

    @Override
    public Pair<Image, BGImageXform> load(File file) throws IOException {
        try {
            IImage image = PDFConverter.convertPDFtoImage(file, this.d_dlgParent);
            if (image == null) {
                String filename = file.getAbsolutePath();
                image = ImageManager.getImage(filename);
            }
            if (!(image instanceof Image)) {
                throw new IOException(Intl.intl("Could not load image."));
            }
            return new Pair<Image, Object>((Image)image, null);
        }
        catch (OutOfMemoryError e) {
            throw new IOException(Intl.intl("Unable to load image file, the file is too large."));
        }
        catch (CancelledException e) {
            return null;
        }
    }
}

