/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.domain.Floor;
import pyrosim.domain.ModelImage;
import pyrosim.gui.floorview.EditBGImageAction;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class FloorBGImageEditor
extends guiPanel {
    private static final long serialVersionUID = 1L;
    private Floor d_floor = null;
    private final EditBGImageAction d_editAction;
    private final guiTextField d_fileName = new guiTextField();
    private final JButton d_editButton = new JButton("...");
    private final JButton d_deleteButton = new JButton(Intl.intl("Remove"));
    private final LinkedList<ActionListener> d_floorEditedListeners = new LinkedList();
    private final LinkedList<ActionListener> d_floorDeletedListeners = new LinkedList();

    public FloorBGImageEditor(Floor f, EditBGImageAction editAction) {
        this.setLayout(new GridBagLayout());
        this.d_editAction = editAction;
        Insets fnInsets = this.d_fileName.getBorder().getBorderInsets(this.d_fileName);
        this.d_fileName.setBorder(BorderFactory.createEmptyBorder(0, fnInsets.left, 0, fnInsets.right));
        this.d_fileName.setEditable(false);
        this.d_editButton.addActionListener(evt -> this.editBGImage());
        this.d_deleteButton.addActionListener(evt -> this.deleteBGImage());
        Insets buttonInset = this.d_editButton.getMargin();
        buttonInset.right = 2;
        buttonInset.left = 2;
        this.d_editButton.setMargin(buttonInset);
        this.d_deleteButton.setMargin(buttonInset);
        GridBagUtil.add(this, this.d_fileName, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_editButton, 1, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
        GridBagUtil.add(this, this.d_deleteButton, 2, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
        this.setEditingFloor(f);
    }

    public void setEditingFloor(Floor f) {
        this.d_floor = f;
        this.updateComponents();
    }

    public Floor getEditingFloor() {
        return this.d_floor;
    }

    public void addFloorEditedListener(ActionListener listener) {
        this.d_floorEditedListeners.add(listener);
    }

    public void addFloorDeletedListener(ActionListener listener) {
        this.d_floorDeletedListeners.add(listener);
    }

    protected void deleteBGImage() {
        if (this.d_floor == null) {
            return;
        }
        this.d_floor.setBgImage(null);
        this.updateComponents();
        for (ActionListener d_floorDeletedListener : this.d_floorDeletedListeners) {
            d_floorDeletedListener.actionPerformed(null);
        }
    }

    protected void editBGImage() {
        if (this.d_floor == null) {
            return;
        }
        boolean changed = this.d_editAction.editFloor(this.d_floor);
        if (changed) {
            this.updateComponents();
            for (ActionListener d_floorEditedListener : this.d_floorEditedListeners) {
                d_floorEditedListener.actionPerformed(null);
            }
        }
    }

    public JButton getEditButton() {
        return this.d_editButton;
    }

    public JButton getDeleteButton() {
        return this.d_deleteButton;
    }

    protected void updateComponents() {
        ModelImage image = this.d_floor != null ? this.d_floor.getBgImage() : null;
        this.d_deleteButton.setEnabled(image != null);
        String id = image != null ? image.getImage().getFilename() : null;
        this.d_fileName.setText(id);
        this.d_fileName.setToolTipText(id);
        this.d_fileName.setCaretPosition(0);
        if (this.d_floor != null) {
            this.d_editButton.setToolTipText("Edit the background image for the \"" + this.d_floor.getName() + "\" floor.");
            this.d_deleteButton.setToolTipText("Remove the background image from the \"" + this.d_floor.getName() + "\" floor.");
        } else {
            this.d_editButton.setToolTipText(null);
            this.d_deleteButton.setToolTipText(null);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        for (Component comp : this.getComponents()) {
            comp.setBackground(c);
        }
    }
}

