/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.event.ActionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.floorview.EditModelImageAction;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ConfigureBGImageAction
extends guiAction
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private final PyroMod d_mod;
    private final RenderComponent d_renderComp;

    public ConfigureBGImageAction(PyroMod mod, RenderComponent renderComp) {
        super(Intl.intl("Configure Background Image") + "...", PyroGuiUtil.loadPyroSimIcon("ConfigureBackgroundImage16.gif"));
        this.putValue("ShortDescription", Intl.intl("Configure Background Image for the Current Floor"));
        this.d_renderComp = renderComp;
        this.d_mod = mod;
        this.d_mod.getEvents().addObserver(this);
        this.setEnabledUpdator(() -> this.d_mod.getFloorManager().getActive() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Floor activeFloor = this.d_mod.getFloorManager().getActive();
        if (activeFloor != null) {
            EditModelImageAction action = new EditModelImageAction(this.d_mod, this.d_renderComp);
            action.editFloor(activeFloor);
            action.release();
        }
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(FloorManager.class, new Class[0]).containsChange(FloorManager.EVT_ACTIVE_FLOOR_CHANGED) || events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) {
            this.updateEnabled();
        }
    }
}

