/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.gui.PyroGuiUtil;
import thunderheadeng.gui.guiComboBox;

public class StatisticsComboBox
extends guiComboBox<QuantityStat> {
    private static final long serialVersionUID = 1L;
    private Quantity selectedQuant;
    private QuantityStat selectedSpatial;
    private String d_nullName = null;

    public StatisticsComboBox(Collection<QuantityStat> options) {
        this(null, options);
    }

    public StatisticsComboBox(String nullName, Collection<QuantityStat> options) {
        super(options);
        this.d_nullName = nullName;
        this.setRenderer(new StatisticsCellRenderer());
    }

    public void updateSelectedObjs(Quantity q, QuantityStat spatial) {
        this.selectedQuant = q;
        this.selectedSpatial = spatial;
        this.repaint();
    }

    public void setNullName(String name) {
        this.d_nullName = name;
    }

    private class StatisticsCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final ImageIcon s_warningIcon = PyroGuiUtil.loadPyroSimIcon("bad.png");

        private StatisticsCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.decorateCells(value);
            return this;
        }

        private void decorateCells(Object value) {
            if (value == null) {
                if (StatisticsComboBox.this.d_nullName == null) {
                    this.setText(Intl.intl("[None]"));
                } else {
                    this.setText(StatisticsComboBox.this.d_nullName);
                }
            } else if (value instanceof QuantityStat) {
                boolean isStatsCompatible;
                QuantityStat quantityStat = (QuantityStat)((Object)value);
                this.setText(quantityStat.displayName);
                boolean isQuantCompatible = StatisticsComboBox.this.selectedQuant == null || StatisticsComboBox.this.selectedQuant.isCompatible(quantityStat);
                boolean bl = isStatsCompatible = quantityStat.isSpatial() ? true : QuantityStat.isCompatible(StatisticsComboBox.this.selectedSpatial, quantityStat);
                if (isQuantCompatible && isStatsCompatible) {
                    this.setIcon(null);
                } else {
                    this.setIcon(s_warningIcon);
                }
            } else {
                assert (false);
                this.setText(value.toString());
            }
        }
    }
}

