/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SprinklerLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;

public class SprinklerLinkEditor
extends ADevcEditor<SprinklerLink> {
    private final SprinklerLinkDataPanel d_dataPanel;

    public SprinklerLinkEditor(PyroMod pyMod) {
        this.d_dataPanel = new SprinklerLinkDataPanel(pyMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Sprinkler Link");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SLINK");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public Collection<SprinklerLink> create() {
        return Arrays.asList(new SprinklerLink("", this.d_dataPanel.getSprinklerLinkModel().orElse(null), new FreePointLoc()));
    }

    @Override
    public void load(Collection<SprinklerLink> sl) {
        this.d_dataPanel.setSprinklerLinkModel(sl.stream().map(s -> s.getModel()).toList());
    }

    @Override
    public void save(Collection<SprinklerLink> link) {
        Optional<SprinklerLinkModel> mod = this.d_dataPanel.getSprinklerLinkModel();
        if (mod.isPresent()) {
            for (SprinklerLink s : link) {
                s.setModel(mod.get());
            }
        }
    }

    public static class SprinklerLinkDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 7485619082615631763L;
        private final guiComboBox<SprinklerLinkModel> d_typeCombo;

        public SprinklerLinkDataPanel(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_typeCombo = new SprinklerLinkModelComboBox(pyMod.getSprinklerLinkModels());
            this.d_typeCombo.setMinimumSize(this.d_typeCombo.getPreferredSize());
            JButton d_editSprinkLink = new JButton(Intl.intl("Edit") + "...");
            d_editSprinkLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editSprinklerLinkModels(d_typeCombo.getSelectedItem());
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Type:"), this.d_typeCombo, d_editSprinkLink, 0);
            gb.finalizeRows();
        }

        public Optional<SprinklerLinkModel> getSprinklerLinkModel() {
            return DeviceEditorUtil.getSelectedItemOrEmpty(this.d_typeCombo);
        }

        public void setSprinklerLinkModel(Collection<SprinklerLinkModel> spl) {
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_typeCombo, spl);
        }
    }
}

