/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.devices.NewSprayModelDlg;
import pyrosim.gui.devices.SprayModelPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class SprayModelManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = 1403854967012767479L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private SprayModelMgr d_sprayMgr;
    private JFrame d_owner;

    public SprayModelManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Spray Models"), true);
        this.d_owner = owner;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, SprayModel.class), new RenameAction(this, Intl.intl("spray model")), new ManagerDlg.DeleteAction(this)};
        this.d_editor = new SprayModelPanel(this);
        this.setPreviewTypes("PROP", "RAMP");
    }

    private void updateActions() {
        int selIx = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_sprayMgr != null);
        this.d_actions[2].setEnabled(this.d_sprayMgr != null && selIx > -1);
        this.d_actions[3].setEnabled(this.d_sprayMgr != null && selIx > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(SprayModelMgr sprayMgr, SprayModel init) {
        this.d_sprayMgr = sprayMgr;
        ((RenameAction)this.d_actions[2]).init(sprayMgr);
        super.init(this.d_sprayMgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 4182152059864970394L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SprayModelManagerDlg.this.preSave()) {
                return;
            }
            NewSprayModelDlg dlg = new NewSprayModelDlg(SprayModelManagerDlg.this.d_sprayMgr);
            PyroMod domain = (PyroMod)SprayModelManagerDlg.this.d_sprayMgr.getDomain();
            if (dlg.doModal() == 1) {
                SelectTask wrapper;
                AddTask t;
                String name = dlg.getSprayModelName();
                Particle part = null;
                Collection<Particle> parts = domain.getPartList().flatten(SprayModel.getParticleFilter());
                if (parts.isEmpty()) {
                    part = new Particle(Intl.intl("Water_PART"), Particle.Type.LIQUID, new Output(10), null);
                    ExSpec waterSpec = domain.getExSpecList().get("WATER VAPOR");
                    part.setSpecies(waterSpec);
                    t = new AddTask((IPyroObject)domain.getPartList(), new IPyroObject[]{part});
                    wrapper = new SelectTask(domain, part);
                    wrapper.addTask(t);
                    domain.getTaskManager().exec(wrapper, Intl.intl("New Particle"));
                } else {
                    part = parts.iterator().next();
                }
                SprayModel newSprayModel = new SprayModel(name, part);
                t = new AddTask((IPyroObject)SprayModelManagerDlg.this.d_sprayMgr, new IPyroObject[]{newSprayModel});
                wrapper = new SelectTask(domain, newSprayModel);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Spray Model"));
                SprayModelManagerDlg.this.getList().updateModelView(SprayModelManagerDlg.this.d_sprayMgr);
                SprayModelManagerDlg.this.getList().select(newSprayModel);
                SprayModelManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                SprayModelManagerDlg.this.updateActions();
            }
        }
    }
}

