/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SmokeLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;

public class SmokeDetectorEditor
extends ADevcEditor<SmokeDetector> {
    private final SmokeDetectorDataPanel d_dataPanel;

    public SmokeDetectorEditor(PyroMod pyMod) {
        this.d_dataPanel = new SmokeDetectorDataPanel(pyMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Smoke Detector");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SD");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public Collection<SmokeDetector> create() {
        SmokeLinkModel mod = this.d_dataPanel.getSmokeLinkModel().orElse(PyroSim.getApp().getMediator().getSmokeLinkModels().getDefaultModel());
        return Arrays.asList(new SmokeDetector("", mod));
    }

    @Override
    public void load(Collection<SmokeDetector> sd) {
        this.d_dataPanel.setSmokeLinkModel(sd.stream().map(e -> e.getModel()).toList());
    }

    @Override
    public void save(Collection<SmokeDetector> sd) {
        Optional<SmokeLinkModel> opt = this.d_dataPanel.getSmokeLinkModel();
        if (opt.isPresent()) {
            for (SmokeDetector s : sd) {
                s.setModel(opt.get());
            }
        }
    }

    public static class SmokeDetectorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1165057042647528613L;
        private final guiComboBox<SmokeLinkModel> d_modelCombo;

        public SmokeDetectorDataPanel(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_modelCombo = new SmokeLinkModelComboBox(pyMod.getSmokeLinkModels());
            this.d_modelCombo.setMinimumSize(this.d_modelCombo.getPreferredSize());
            this.setSmokeLinkModel(Arrays.asList(pyMod.getSmokeLinkModels().getDefaultModel()));
            JButton d_editSmokeLink = new JButton(Intl.intl("Edit") + "...");
            d_editSmokeLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Optional<SmokeLinkModel> model = DeviceEditorUtil.getSelectedItemOrEmpty(d_modelCombo);
                    Actions.editSmokeLinkModels(model.orElse(null));
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Model:"), this.d_modelCombo, d_editSmokeLink, 0);
            gb.finalizeRows();
        }

        public Optional<SmokeLinkModel> getSmokeLinkModel() {
            return DeviceEditorUtil.getSelectedItemOrEmpty(this.d_modelCombo);
        }

        public void setSmokeLinkModel(Collection<SmokeLinkModel> slm) {
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_modelCombo, slm);
        }
    }
}

