/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SprayModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;

public class NozzleEditor
extends ADevcEditor<Nozzle> {
    private final NozzleDataPanel d_dataPanel;

    public NozzleEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this.d_dataPanel = new NozzleDataPanel(pyMod, mode);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Nozzle");
    }

    @Override
    public String getDefName() {
        return Intl.intl("NOZZLE");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public Collection<Nozzle> create() {
        return Arrays.asList(new Nozzle("", this.d_dataPanel.getSprayModel()));
    }

    @Override
    public void load(Collection<Nozzle> nozzle) {
        List<SprayModel> sm = nozzle.stream().map(n -> n.getSprayModel()).toList();
        if (DeviceEditorUtil.testIfAllElementsAreEqual(sm)) {
            this.d_dataPanel.setSprayModel(sm.stream().findFirst().orElse(null));
        } else {
            this.d_dataPanel.setSprayModel(null);
        }
    }

    @Override
    public void save(Collection<Nozzle> nozzle) {
        if (this.d_dataPanel.getSprayModel() == null || nozzle.stream().allMatch(e -> this.d_dataPanel.getSprayModel().equals(e.getSprayModel()))) {
            return;
        }
        for (Nozzle n : nozzle) {
            n.setSprayModel(this.d_dataPanel.getSprayModel());
        }
    }

    public class NozzleDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -4506442033051845947L;
        private final SprayModelComboBox d_sprayCombo;

        public NozzleDataPanel(PyroMod pyMod, IDevcEditor.Mode mode) {
            this.setLayout(new GridBagLayout());
            String nullName = "";
            if (mode == IDevcEditor.Mode.CREATE) {
                nullName = null;
            }
            this.d_sprayCombo = new SprayModelComboBox(pyMod.getSprayModels(), nullName);
            this.d_sprayCombo.setMinimumSize(this.d_sprayCombo.getPreferredSize());
            JButton d_editSpray = new JButton(Intl.intl("Edit") + "...");
            d_editSpray.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editSprayModel((SprayModel)NozzleDataPanel.this.d_sprayCombo.getSelectedItem());
                    if (NozzleDataPanel.this.d_sprayCombo.getSelectedItem() == null && NozzleDataPanel.this.d_sprayCombo.getItemCount() > 0) {
                        NozzleDataPanel.this.d_sprayCombo.selectFirstOfType(Particle.Type.LIQUID);
                    }
                }
            });
            this.d_sprayCombo.selectFirstOfType(Particle.Type.LIQUID);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Spray Type:"), this.d_sprayCombo, d_editSpray);
            gb.finalizeRows();
        }

        public SprayModel getSprayModel() {
            SprayModel mod = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_sprayCombo).orElse(null);
            if (mod == null) {
                mod = (SprayModel)this.d_sprayCombo.getItemAt(0);
            }
            return mod;
        }

        public void setSprayModel(SprayModel mod) {
            this.d_sprayCombo.setSelectedItem(mod);
        }

        public void setSprayModeltoDefault() {
            this.d_sprayCombo.setSelectedItem(0);
        }
    }
}

