/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridLayout;
import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewSprinklerLinkModelDlg
extends guiDialog {
    private static final long serialVersionUID = 8312266082510389057L;
    private final guiTextField d_name;
    private final PyroMod d_pyMod;

    public NewSprinklerLinkModelDlg(PyroMod pyMod) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Sprinkler Link Model"), 9);
        this.d_pyMod = pyMod;
        this.d_name = new guiTextField(pyMod.getNames(SprinklerLinkModel.class).generateName());
        guiLabel nameLab = new guiLabel(Intl.intl("Sprinkler Link Model Name") + ":   ");
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(nameLab);
        panel.add(this.d_name);
    }

    public String getSprinklerLinkName() {
        return this.d_name.getValue();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            NewSprinklerLinkModelDlg.showInvalidEntryMessage(this, Intl.intl("Please enter a name."));
            this.d_name.requestFocus();
            return false;
        }
        if (this.d_pyMod.getNames(SprinklerLinkModel.class).isRegistered(this.d_name.getText())) {
            NewSprinklerLinkModelDlg.showInvalidEntryMessage(this, String.format(Intl.intl("There is already a sprinkler link model named %s.\nPlease choose another name."), this.d_name.getText()));
            this.d_name.requestFocus();
            return false;
        }
        return true;
    }
}

