/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridLayout;
import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewSprayModelDlg
extends guiDialog {
    private static final long serialVersionUID = 3552622551662834449L;
    private final guiTextField d_name;
    private final SprayModelMgr d_sprayModels;

    public NewSprayModelDlg(SprayModelMgr sprayMgr) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Spray Model"), 9);
        this.d_sprayModels = sprayMgr;
        this.d_name = new guiTextField(((PyroMod)sprayMgr.getDomain()).getNames(SprayModel.class).generateName());
        guiLabel nameLab = new guiLabel(Intl.intl("Spray Model Name") + ":   ");
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(nameLab);
        panel.add(this.d_name);
    }

    public String getSprayModelName() {
        return this.d_name.getValue();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            NewSprayModelDlg.showInvalidEntryMessage(this, Intl.intl("Please enter a name."));
            this.d_name.requestFocus();
            return false;
        }
        if (((PyroMod)this.d_sprayModels.getDomain()).getNames(SprayModel.class).isRegistered(this.d_name.getText())) {
            NewSprayModelDlg.showInvalidEntryMessage(this, String.format(Intl.intl("There is already a spray model named %s.\nPlease choose another name."), this.d_name.getText()));
            this.d_name.requestFocus();
            return false;
        }
        return true;
    }
}

