/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridLayout;
import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewHeatLinkModelDlg
extends guiDialog {
    private static final long serialVersionUID = -8627856721241472726L;
    private final guiTextField d_name;
    private final PyroMod d_pyMod;

    public NewHeatLinkModelDlg(PyroMod pyMod) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Heat Detector Model"), 9);
        this.d_pyMod = pyMod;
        this.d_name = new guiTextField(pyMod.getNames(HeatLinkModel.class).generateName());
        guiLabel nameLab = new guiLabel(Intl.intl("Heat Detector Model Name") + ":   ");
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(nameLab);
        panel.add(this.d_name);
    }

    public String getHeatLinkName() {
        return this.d_name.getValue();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            NewHeatLinkModelDlg.showInvalidEntryMessage(this, Intl.intl("Please enter a name."));
            this.d_name.requestFocus();
            return false;
        }
        if (this.d_pyMod.getNames(HeatLinkModel.class).isRegistered(this.d_name.getText())) {
            NewHeatLinkModelDlg.showInvalidEntryMessage(this, String.format(Intl.intl("There is already a heat link model named %s.\nPlease choose another name."), this.d_name.getText()));
            this.d_name.requestFocus();
            return false;
        }
        return true;
    }
}

