/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.util.Collection;
import java.util.Optional;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.quantity.IQuantity;

public class MsrDeviceEditorUtil {
    public static <T extends IMeasurer> boolean validateData(Component parent, Collection<T> loadedObj, IQuantity newMsr, boolean showWarn, boolean allowModify) {
        int newUnitType;
        int oldUnitType;
        if (loadedObj == null || newMsr == null || loadedObj.stream().anyMatch(obj -> obj == null) || loadedObj.stream().allMatch(obj -> newMsr.equals(obj))) {
            return true;
        }
        Optional<T> opt = loadedObj.stream().findFirst();
        if (opt.isPresent() && ((IMeasurer)opt.get()).getQuantity(0) != null && (oldUnitType = ((IMeasurer)opt.get()).getQuantity((int)0).get().unitType) != (newUnitType = newMsr == null ? 28 : newMsr.get().unitType)) {
            DepSnapshot ds = PyroSim.getApp().getMediator().getDependencies(loadedObj);
            for (IMeasurer obj2 : loadedObj) {
                int option;
                if (ds.getDependents(obj2).isEmpty() || !showWarn || (option = JOptionPane.showConfirmDialog(parent, Intl.intl("Changing the quantity type will cause the objects using this device to\nreinterpret their units.  Would you like to continue?"), Intl.intl("Change Quantity Type?"), 0)) == 0) continue;
                return false;
            }
        }
        return true;
    }
}

