/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.LineSegEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;

public class LayerMsrEditor
extends ADevcEditor<LayerMeasurer> {
    private final LayerInfoDataPanel d_dataPanel = new LayerInfoDataPanel();

    public LayerMsrEditor() {
        this.load((Collection<LayerMeasurer>)Arrays.asList(new LayerMeasurer(Intl.intl("LAYER"))));
    }

    @Override
    public String getDesc() {
        return Intl.intl("Layer Zoning Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("LAYER");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new LineSegEditor();
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        return null;
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public Collection<LayerMeasurer> create() {
        return Arrays.asList(new LayerMeasurer(""));
    }

    @Override
    public void load(Collection<LayerMeasurer> lm) {
        this.d_dataPanel.d_heightInfo.load(lm.stream().map(m -> m.getHeightInfo()).toList());
        this.d_dataPanel.d_lowerTempInfo.load(lm.stream().map(m -> m.getLowerTempInfo()).toList());
        this.d_dataPanel.d_upperTempInfo.load(lm.stream().map(m -> m.getUpperTempInfo()).toList());
    }

    @Override
    public void save(Collection<LayerMeasurer> msr) {
        this.d_dataPanel.save(msr);
    }

    public class LayerInfoDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -7337015475435543635L;
        private final OutputInfo d_heightInfo;
        private final OutputInfo d_lowerTempInfo;
        private final OutputInfo d_upperTempInfo;

        public LayerInfoDataPanel() {
            this.setLayout(new GridBagLayout());
            this.d_heightInfo = new OutputInfo(Intl.intl("Measure Layer Height"), Quantity.LAYER_HEIGHT.create());
            this.d_upperTempInfo = new OutputInfo(Intl.intl("Measure Upper Temperature"), Quantity.UPPER_TEMPERATURE.create());
            this.d_lowerTempInfo = new OutputInfo(Intl.intl("Measure Lower Temperature"), Quantity.LOWER_TEMPERATURE.create());
            GridBagUtil.add(this, this.d_heightInfo, 0, 1, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_upperTempInfo, 0, 2, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_lowerTempInfo, 0, 3, 2, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        private void save(Collection<LayerMeasurer> msr) {
            boolean upSel;
            int heightState = this.d_heightInfo.d_checkbox.getState();
            int lowState = this.d_lowerTempInfo.d_checkbox.getState();
            int upState = this.d_upperTempInfo.d_checkbox.getState();
            Optional<AlarmInfo> ht_alarm = this.d_heightInfo.d_alarmPanel.save();
            Optional<AlarmInfo> lt_alarm = this.d_lowerTempInfo.d_alarmPanel.save();
            Optional<AlarmInfo> ut_alarm = this.d_upperTempInfo.d_alarmPanel.save();
            boolean heightSel = heightState == 1;
            boolean lowSel = lowState == 1;
            boolean bl = upSel = upState == 1;
            if (heightState != 2) {
                AlarmInfo heightAI = null;
                if (ht_alarm.isPresent()) {
                    heightAI = ht_alarm.get();
                }
                for (LayerMeasurer lm : msr) {
                    lm.getHeightInfo().setAlarmInfo(heightAI);
                    lm.setHeight(heightSel);
                }
            }
            if (lowState != 2) {
                AlarmInfo lowAI = null;
                if (lt_alarm.isPresent()) {
                    lowAI = lt_alarm.get();
                }
                for (LayerMeasurer lm : msr) {
                    lm.getLowerTempInfo().setAlarmInfo(lowAI);
                    lm.setLowerTemp(lowSel);
                }
            }
            if (upState != 2) {
                AlarmInfo upAI = null;
                if (ut_alarm.isPresent()) {
                    upAI = ut_alarm.get();
                }
                for (LayerMeasurer lm : msr) {
                    lm.getUpperTempInfo().setAlarmInfo(upAI);
                    lm.setUpperTemp(upSel);
                }
            }
        }

        private class OutputInfo
        extends guiPanel {
            private static final long serialVersionUID = 3381193455926002286L;
            private final guiMultiStateCheckBox d_checkbox;
            private final AlarmInfoPanel d_alarmPanel;
            private final IQuantity d_msr;

            public OutputInfo(String name, IQuantity msr) {
                super(new GridBagLayout());
                this.d_msr = msr;
                this.d_checkbox = new guiMultiStateCheckBox(name, 1);
                this.d_alarmPanel = new AlarmInfoPanel(msr, 1);
                this.d_alarmPanel.setVisible(false);
                this.d_checkbox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        OutputInfo.this.d_alarmPanel.setVisible(OutputInfo.this.d_checkbox.isSelected());
                        PyroGuiUtil.pack(OutputInfo.this);
                    }
                });
                LinkStatus.link((AbstractButton)this.d_checkbox, this.d_alarmPanel);
                GridBagUtil.add(this, this.d_checkbox, 0, 1, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(this, this.d_alarmPanel, 0, 2, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.addGlue(this);
            }

            private void load(Collection<MeasureOutInfo> lm) {
                int state = 0;
                MeasureOutInfo first = lm.iterator().next();
                state = lm.size() == 1 ? (first.isEnabled() ? 1 : 0) : (DeviceEditorUtil.testIfAllElementsAreEqual(lm.stream().map(e -> e.isEnabled()), Boolean.valueOf(first.isEnabled())) ? (first.isEnabled() ? 1 : 0) : 2);
                if (state == 1) {
                    if (DeviceEditorUtil.testIfAllElementsAreEqual(lm.stream().map(e -> e.getAlarmInfo()).toList(), first.getAlarmInfo())) {
                        this.d_alarmPanel.load(this.d_msr, first.getAlarmInfo());
                    } else {
                        state = 2;
                    }
                }
                this.d_checkbox.setState(state);
                this.d_alarmPanel.setVisible(this.d_checkbox.isSelected());
            }
        }
    }
}

