/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.IGridBagAdder;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.devices.StatisticsComboBox;
import pyrosim.gui.devices.StatisticsDevcEditor;
import pyrosim.gui.devices.TripFlagsPanel;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IdentityHashSet;

public class HvacDevcEditor
extends ADevcEditor<HvacDevice> {
    public static final int DUCT = 0;
    public static final int NODE = 1;
    private final String d_desc;
    private final String d_defName;
    private final HvacDevcDataPanel d_dataPanel;
    private int d_type;

    public HvacDevcEditor(PyroMod pymod, IDevcEditor.Mode mode, int type) {
        this(pymod, Intl.intl("HVAC Device"), Intl.intl("HVAC"), mode, type);
    }

    public HvacDevcEditor(PyroMod pyMod, String desc, String defName, IDevcEditor.Mode mode, int type) {
        this.d_desc = desc;
        this.d_defName = defName;
        this.d_type = type;
        this.d_dataPanel = new HvacDevcDataPanel(pyMod, this, mode);
    }

    @Override
    public Collection<HvacDevice> create() {
        IQuantity meas = (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem();
        if (this.d_type == 0) {
            return Arrays.asList(new DuctDevice("", meas));
        }
        if (this.d_type == 1) {
            return Arrays.asList(new NodeDevice("", meas));
        }
        return null;
    }

    @Override
    public void save(Collection<HvacDevice> obj) {
        if (obj.isEmpty()) {
            this.create();
        } else {
            this.d_dataPanel.save(obj);
        }
    }

    @Override
    public void load(Collection<HvacDevice> obj) {
        this.d_dataPanel.load(obj);
    }

    @Override
    public boolean enableAlarmPanel() {
        return this.d_dataPanel.canEditQuantity();
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public IGeomEditor<?> createGeomEditor() {
        return null;
    }

    @Override
    public boolean validateData(Component parent, Collection<HvacDevice> loadedObjs, boolean showWarn, boolean allowModify) {
        if (loadedObjs == null) {
            return true;
        }
        return loadedObjs.stream().allMatch(loadedObj -> MsrDeviceEditorUtil.validateData(parent, loadedObjs, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), showWarn, allowModify));
    }

    public int getType() {
        return this.d_type;
    }

    public void setType(int type) {
        this.d_type = type;
    }

    public static QuantityType getTypeAsQuantityType(int type) {
        if (type == 0) {
            return QuantityType.HVAC_DUCT;
        }
        if (type == 1) {
            return QuantityType.HVAC_NODE;
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    public static Predicate<Quantity> getQuantityFilter(QuantityType ductOrNode) {
        assert (ductOrNode == QuantityType.HVAC_DUCT || ductOrNode == QuantityType.HVAC_NODE);
        QuantityUtil.TypeFilter hvacTypeFilter = new QuantityUtil.TypeFilter(0L, ductOrNode);
        Predicate<Quantity> hvacObjOnlyFilter = obj -> {
            Class<? extends IPyroObject>[] types;
            for (Class<? extends IPyroObject> clazz : types = obj.requiredTypes) {
                if (!AHvacGeomComponent.class.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        };
        return hvacTypeFilter.and(hvacObjOnlyFilter);
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        StatisticsDevcEditor.StatisticSensitiveAlarmPanelModel alarmPanelModel = new StatisticsDevcEditor.StatisticSensitiveAlarmPanelModel(this.d_dataPanel.getSelectedUnits(), () -> null, () -> this.d_dataPanel.getTemporalStatistic());
        AlarmInfoPanel alarmInfoPanel = new AlarmInfoPanel(0, alarmPanelModel);
        this.d_dataPanel.addComboListener(e -> alarmInfoPanel.setCurrentUnitType(this.d_dataPanel.getSelectedUnits()));
        return alarmInfoPanel;
    }

    @Override
    public TripFlagsPanel createTripPanel() {
        return new TripFlagsPanel();
    }

    private static class HvacDevcDataPanel
    extends guiPanel
    implements IGridBagAdder {
        private static final long serialVersionUID = 5620527752378853409L;
        private QuantityComboBox d_measCombo;
        private StatisticsComboBox d_timeStats;
        private HvacDevcEditor d_parent;
        private boolean d_allowNullQuantity;
        private String nullName = Intl.intl("[None]");

        public HvacDevcDataPanel(PyroMod pyMod, HvacDevcEditor parent, IDevcEditor.Mode mode) {
            this.d_parent = parent;
            this.d_allowNullQuantity = false;
            this.setLayout(new GridBagLayout());
            this.d_measCombo = new QuantityComboBox("");
            String nullstr = "";
            if (mode == IDevcEditor.Mode.CREATE) {
                nullstr = this.nullName;
            }
            List<QuantityStat> temporalStatOptions = QuantityStat.getSupportedTemporalList();
            temporalStatOptions.add(0, null);
            this.d_timeStats = new StatisticsComboBox(nullstr, (Collection<QuantityStat>)temporalStatOptions);
            this.updateDlg();
            GridBagHelper gbh = new GridBagHelper(this);
            this.add(gbh);
        }

        private void updateDlg() {
            QuantityType qt = HvacDevcEditor.getTypeAsQuantityType(this.d_parent.getType());
            Predicate<Quantity> filter = HvacDevcEditor.getQuantityFilter(qt);
            this.d_measCombo.setFilter(filter);
        }

        public void load(Collection<HvacDevice> objs) {
            this.d_allowNullQuantity = objs.stream().allMatch(e -> e.getQuantity() != null);
            HvacDevice first = objs.iterator().next();
            if (DeviceEditorUtil.testIfAllElementsAreSameClass(objs)) {
                if (first instanceof DuctDevice && this.d_parent.getType() != 0) {
                    this.d_parent.setType(0);
                    this.updateDlg();
                }
                if (first instanceof NodeDevice && this.d_parent.getType() != 1) {
                    this.d_parent.setType(1);
                    this.updateDlg();
                }
            }
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_measCombo, objs.stream().map(e -> e.getQuantity()).toList());
            if (objs.size() > 1) {
                this.d_measCombo.setEnabled(this.d_measCombo.getSelectedItem() != null);
            }
            this.setSelectedTimeStat(objs.stream().map(e -> e.getTemporalStat()).toList());
        }

        private void setSelectedTimeStat(Collection<QuantityStat> stat) {
            if (stat.size() == 1) {
                this.d_timeStats.setNullName(this.nullName);
                this.d_timeStats.setSelectedItem(stat.stream().filter(Objects::nonNull).findFirst().orElse(null));
            } else if (DeviceEditorUtil.testIfAllElementsAreEqual(stat)) {
                Optional<QuantityStat> opt = stat.stream().filter(Objects::nonNull).findFirst();
                if (opt.isPresent()) {
                    this.d_timeStats.setSelectedItem((Object)opt.get());
                } else {
                    this.d_timeStats.setNullName(this.nullName);
                    this.d_timeStats.setSelectedItem(null);
                }
            } else {
                this.d_timeStats.setNullName("");
                this.d_timeStats.setSelectedItem(null);
            }
        }

        public void save(Collection<HvacDevice> obj) {
            Optional<IQuantity> msr = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_measCombo);
            Optional<QuantityStat> stat = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_timeStats);
            if (msr.isPresent()) {
                for (HvacDevice d : obj) {
                    d.setQuantity(msr.get());
                }
            }
            if (obj.size() == 1) {
                HvacDevice devc = obj.stream().findFirst().orElse(null);
                if (devc != null) {
                    devc.setTemporalStat(stat.orElse(null));
                }
            } else if (stat.isPresent()) {
                for (HvacDevice d : obj) {
                    d.setTemporalStat(stat.get());
                }
            }
        }

        private boolean canEditQuantity() {
            return this.d_measCombo.isEnabled();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            IQuantity selectedQuantity = (IQuantity)this.d_measCombo.getSelectedItem();
            if (!this.d_allowNullQuantity && selectedQuantity == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this.d_measCombo.getParent(), Intl.intl("A quantity must be selected."), Intl.intl("No Quantity Selected"), 0);
                }
                return false;
            }
            return selectedQuantity == null || HvacDevcDataPanel.validateRestrictedQuantObjs(selectedQuantity, showWarn, this.d_measCombo.getParent());
        }

        private static boolean validateRestrictedQuantObjs(IQuantity quant, boolean showWarn, Component parent) {
            if (quant.get().equals((Object)Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) && quant instanceof ObjectQuantity) {
                boolean isValid;
                ObjectQuantity objQuant = (ObjectQuantity)quant;
                IdentityHashSet uniqueObjs = new IdentityHashSet(Arrays.asList(objQuant.objects));
                boolean bl = isValid = uniqueObjs.size() == objQuant.objects.length;
                if (!isValid && showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("The same HVAC Node cannot be selected twice."), Intl.intl("Invalid Quantity Selected"), 0);
                }
                return isValid;
            }
            return true;
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0, 1.0);
            gb.addRow(Intl.intl("Time Statistic:"), this.d_timeStats, 0, 1.0);
        }

        public int getSelectedUnits() {
            IQuantity baseQuant = (IQuantity)this.d_measCombo.getSelectedItem();
            if (baseQuant == null) {
                return 28;
            }
            QuantityStat temporalStat = (QuantityStat)((Object)this.d_timeStats.getSelectedItem());
            return StatisticsDevc.getUnitType(baseQuant.get(), null, temporalStat);
        }

        public QuantityStat getTemporalStatistic() {
            return (QuantityStat)((Object)this.d_timeStats.getSelectedItem());
        }

        public void addComboListener(ItemListener e) {
            this.d_measCombo.addItemListener(e);
            this.d_timeStats.addItemListener(e);
        }
    }
}

