/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiConstUnitDoubleField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CompositeTask;

public class HeatLinkModelPanel
extends guiPanel
implements IEditor<HeatLinkModel> {
    private static final long serialVersionUID = -4639877275088909555L;
    private final HeatLinkModelMgr d_heatLMMgr;
    private final guiDialog d_parent;
    private final UnitSystem d_currentUS;
    private final guiCheckBox d_initTempCB;
    private final ValueField<UnitDouble> d_initTemp;
    private final ValueField<UnitDouble> d_activTemp;
    private final guiConstUnitDoubleField d_respTimeInd;
    private final guiTextField d_name;
    private final guiTextField d_fyi;
    private final CustomFDSPanel d_customPnl = new CustomFDSPanel(6);

    public HeatLinkModelPanel(guiDialog parent) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_heatLMMgr = pyMod.getHeatLinkModels();
        this.d_currentUS = pySim.getUnitSystem();
        this.d_parent = parent;
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_fyi = new guiTextField();
        this.setLayout(new GridBagLayout());
        this.d_initTempCB = new guiCheckBox(Intl.intl("Initial Temperature") + ":");
        this.d_initTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_activTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_respTimeInd = new guiConstUnitDoubleField(UnitSystem.getSource(3).getUnit());
        guiLabel activTempLab = new guiLabel(Intl.intl("Activation Temperature") + ":");
        guiLabel respTimeIndLab = new guiLabel(Intl.intl("Response Time Index") + ":");
        guiLabel respTimeIndULab = new guiLabel(this.d_respTimeInd.getUnit().toString());
        guiPanel propPnl = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(propPnl, new guiLabel(Intl.intl("Heat Detector Model ID") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_name, 1, row++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(propPnl, new guiLabel(Intl.intl("Description") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_fyi, 1, row++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_initTempCB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_initTemp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, activTempLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_activTemp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, respTimeIndLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_respTimeInd, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, respTimeIndULab, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(propPnl);
        LinkStatus.link((AbstractButton)this.d_initTempCB, this.d_initTemp);
        propPnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(Intl.intl("Properties"), propPnl);
        tabs.addTab(Intl.intl("Advanced"), this.d_customPnl);
        this.setLayout(new BorderLayout());
        this.add((Component)tabs, "Center");
        this.init(new HeatLinkModel(""));
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public HeatLinkModel commit(HeatLinkModel hlm) {
        assert (hlm != null);
        PyroMod domain = PyroSim.getApp().getMediator();
        HeatLinkModel tmp = hlm.getRestoreObject();
        this.save(tmp);
        CompositeTask<PyroMod> editTask = new CompositeTask<PyroMod>(domain);
        editTask.addTask(hlm.taskImprint(tmp));
        domain.getTaskManager().exec(editTask, Intl.intl("Edit Heat Detector Model"));
        this.setModified(false);
        return hlm;
    }

    private void save(HeatLinkModel hlm) {
        hlm.setFYI(this.d_fyi.getText());
        UnitDouble initTemp = null;
        if (this.d_initTempCB.isSelected()) {
            initTemp = (UnitDouble)this.d_initTemp.getValue();
        }
        hlm.setActivationTemp((UnitDouble)this.d_activTemp.getValue());
        hlm.setRti((UnitDouble)this.d_respTimeInd.getValue());
        hlm.setInitialTemp(initTemp);
        this.d_customPnl.save(hlm);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(HeatLinkModel hlm) {
        this.setEnabled(hlm != null);
        if (hlm != null) {
            this.d_name.setText(hlm.getName());
            this.d_fyi.setText(hlm.getFYI());
            if (hlm.getInitialTemp() != null) {
                this.d_initTempCB.setSelected(true);
                this.d_initTemp.setValue(hlm.getInitialTemp());
            } else {
                this.d_initTempCB.setSelected(false);
                this.d_initTemp.setValue(new UnitDouble(20.0, SI.CELSIUS));
            }
            this.d_activTemp.setValue(hlm.getActivationTemp());
            this.d_respTimeInd.setValue(hlm.getRti());
            this.d_customPnl.load(hlm);
        }
        this.setModified(false);
    }

    @Override
    public HeatLinkModel preview(HeatLinkModel previewObj) {
        this.save(previewObj);
        return previewObj;
    }
}

