/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.devices.ControlValueDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.AdiabaticSurfTempGasMeasurer;
import pyrosim.domain.devices.measurers.FEDMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxGasMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.gui.MappedListCellRenderer;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class GasPointDevcEditor
extends ADevcEditor<GasPointMeasurer> {
    private final String d_desc;
    private final String d_defName;
    private final GasPointDeviceDataPanel d_dataPanel;
    private final IQuantity d_fixedMsr;

    public GasPointDevcEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this(pyMod, Intl.intl("Gas-phase Device"), Intl.intl("GAS"), null, mode);
    }

    public GasPointDevcEditor(PyroMod pyMod, String desc, String defName, IQuantity type, IDevcEditor.Mode mode) {
        this.d_desc = desc;
        this.d_defName = defName;
        this.d_dataPanel = new GasPointDeviceDataPanel(pyMod, type, mode);
        this.d_fixedMsr = type;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        Optional<IQuantity> q = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_dataPanel.d_measCombo);
        AlarmInfoPanel alarmPanel = q.isPresent() ? new AlarmInfoPanel(q.get()) : new AlarmInfoPanel(28, 0);
        this.d_dataPanel.d_measCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                alarmPanel.setCurrentMsr((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
            }
        });
        if (this.d_fixedMsr != null) {
            alarmPanel.setCurrentMsr(this.d_fixedMsr);
        }
        return alarmPanel;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public void load(Collection<GasPointMeasurer> gpm) {
        this.d_dataPanel.load(gpm);
    }

    @Override
    public Collection<GasPointMeasurer> create() {
        return Arrays.asList(this.d_dataPanel.create(""));
    }

    @Override
    public void save(Collection<GasPointMeasurer> msr) {
        this.d_dataPanel.save(msr);
    }

    @Override
    public boolean enableAlarmPanel() {
        return this.d_dataPanel.enableAlarmPanel();
    }

    @Override
    public boolean validateData(Component parent, Collection<GasPointMeasurer> loadedObjs, boolean showWarn, boolean allowModify) {
        if (loadedObjs == null) {
            return true;
        }
        return loadedObjs.stream().allMatch(loadedObj -> MsrDeviceEditorUtil.validateData(parent, loadedObjs, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), showWarn, allowModify));
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class GasPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 3844599879929888196L;
        private final IDevcEditor.Mode d_mode;
        private final QuantityComboBox d_measCombo;
        private final Map<Quantity, AAdditionalPropsPanel<?>> d_additionalPropsPanels;

        public GasPointDeviceDataPanel(PyroMod pyMod, IQuantity defType, IDevcEditor.Mode mode) {
            pyMod.getDevices();
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            String nullName = "";
            if (mode == IDevcEditor.Mode.CREATE) {
                nullName = null;
            }
            this.d_measCombo = new QuantityComboBox(nullName, GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
            this.d_additionalPropsPanels = new LinkedHashMap();
            Arrays.stream(SpecialQuantityTypes.values()).forEach(this::registerSpecialQuantity);
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_measCombo.addItemListener(arg0 -> this.updateCardSelect());
            if (defType != null) {
                this.d_measCombo.setSelectedItem(defType);
            }
            if (mode == IDevcEditor.Mode.EDIT) {
                this.d_measCombo.setEnabled(false);
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            this.d_additionalPropsPanels.values().forEach(specialPanel -> gb.addRow(specialPanel, 0, 1.0));
            gb.finalizeRows();
            this.updateCardSelect();
        }

        private void registerSpecialQuantity(SpecialQuantityTypes specialType) {
            this.d_additionalPropsPanels.put(specialType.q, specialType.buildPanelFunc.get());
        }

        private void updateCardSelect() {
            IQuantity sel = (IQuantity)this.d_measCombo.getSelectedItem();
            if (sel == null) {
                this.d_additionalPropsPanels.values().forEach(panel -> panel.setVisible(false));
            } else {
                this.d_additionalPropsPanels.values().forEach(panel -> panel.setVisible(panel.isMatchingType(sel.get())));
            }
            PyroGuiUtil.pack(this);
        }

        public void load(Collection<GasPointMeasurer> gpm) {
            boolean isSingleDevcType;
            Predicate<Quantity> msrFilter = this.d_measCombo.getFilter();
            GasPointMeasurer firstDevc = gpm.iterator().next();
            BoolWrapper special = new BoolWrapper(false);
            boolean bl = isSingleDevcType = gpm.stream().map(g -> g.getClass()).distinct().count() <= 1L;
            if (isSingleDevcType) {
                this.d_additionalPropsPanels.values().stream().filter(panel -> panel.isMatchingType(firstDevc)).forEach(panel -> {
                    panel.load(gpm);
                    this.d_measCombo.setEnabled(this.d_mode == IDevcEditor.Mode.CREATE);
                    special.b = true;
                });
            }
            if (!special.isTrue() && this.d_mode == IDevcEditor.Mode.EDIT) {
                Predicate<Quantity> reject = Filters.reject(Quantity.THERMOCOUPLE, Quantity.GAUGE_HEAT_FLUX_GAS, Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS, Quantity.FED);
                msrFilter = msrFilter.and(reject);
                if (isSingleDevcType && DeviceEditorUtil.testIfAllElementsAreEqual(gpm.stream().map(AMeasuringDevc::getQuantity), firstDevc.getQuantity())) {
                    this.d_measCombo.setEnabled(true);
                } else {
                    this.d_measCombo.setEnabled(false);
                }
            }
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_measCombo, gpm.stream().map(g -> g.getQuantity()).toList());
            this.d_measCombo.setFilter(msrFilter);
            if (special.isTrue()) {
                this.updateCardSelect();
            }
        }

        public GasPointMeasurer create(String name) {
            Optional<IQuantity> optItem = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_measCombo);
            if (optItem.isPresent()) {
                IQuantity item = optItem.get();
                if (item.get().equals((Object)Quantity.THERMOCOUPLE)) {
                    return new Thermocouple(name, new FreePointLoc());
                }
                if (item.get().equals((Object)Quantity.GAUGE_HEAT_FLUX_GAS)) {
                    return new GaugeHeatFluxGasMeasurer(name, new FreePointLoc());
                }
                if (item.get().equals((Object)Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS)) {
                    return new AdiabaticSurfTempGasMeasurer(name, new FreePointLoc());
                }
                if (item.get().equals((Object)Quantity.FED)) {
                    return new FEDMeasurer(name, new FreePointLoc());
                }
                return new GasPointMeasurer(name, item, new FreePointLoc());
            }
            return new GasPointMeasurer(name, null, new FreePointLoc());
        }

        public void save(Collection<GasPointMeasurer> msr) {
            if (this.d_measCombo.getSelectedItem() != null) {
                Optional<IQuantity> newMsr;
                boolean multipleDevcTypes = msr.stream().map(g -> g.getClass()).distinct().toList().size() > 1;
                GasPointMeasurer first = msr.iterator().next();
                BoolWrapper needsSave = new BoolWrapper(true);
                if (!multipleDevcTypes) {
                    this.d_additionalPropsPanels.values().stream().filter(panel -> panel.isMatchingType(first)).forEach(panel -> {
                        panel.save(msr);
                        needsSave.b = false;
                    });
                }
                if (needsSave.isTrue() && (newMsr = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_measCombo)).isPresent()) {
                    for (GasPointMeasurer g2 : msr) {
                        g2.setQuantity(newMsr.get());
                    }
                }
            }
        }

        public boolean enableAlarmPanel() {
            return this.d_measCombo.isEnabled();
        }

        private static class BoolWrapper {
            public boolean b;

            public BoolWrapper(boolean b) {
                this.b = b;
            }

            public boolean isTrue() {
                return this.b;
            }
        }
    }

    private static class FEDMeasureProps
    extends AAdditionalPropsPanel<FEDMeasurer> {
        private static final long serialVersionUID = 904712039286455207L;
        private final guiComboBox<Integer> d_activityCombo = new guiComboBox<Integer>((T[])new Integer[]{1, 2, 3});

        public FEDMeasureProps() {
            super(FEDMeasurer.class);
            this.d_activityCombo.setRenderer(new MappedListCellRenderer<Integer>(activity -> {
                if (activity == null) {
                    return "";
                }
                switch (activity) {
                    case 1: {
                        return Intl.intl("Rest");
                    }
                    case 2: {
                        return Intl.intl("Light Activity");
                    }
                    case 3: {
                        return Intl.intl("Heavy Activity");
                    }
                }
                return Intl.intl("Light Activity");
            }));
            this.d_activityCombo.setMinimumSize(this.d_activityCombo.getPreferredSize());
            this.d_activityCombo.setSelectedItem(2);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Activity Level:"), this.d_activityCombo);
            gb.finalizeRows();
            this.load(List.of(new FEDMeasurer("", null)));
        }

        @Override
        public void load(Collection<GasPointMeasurer> fm) {
            DeviceEditorUtil.setComboBoxIndexForMultipleDevices(this.d_activityCombo, fm.stream().map(f -> ((FEDMeasurer)f).getActivityLevel() - 1).toList());
        }

        @Override
        public void save(Collection<GasPointMeasurer> fm) {
            if (this.d_activityCombo.getSelectedIndex() >= 0) {
                for (GasPointMeasurer g : fm) {
                    ((FEDMeasurer)g).setActivityLevel(this.d_activityCombo.getSelectedIndex() + 1);
                }
            }
        }

        @Override
        public boolean isMatchingType(Quantity q) {
            return Quantity.FED.equals((Object)q);
        }
    }

    private static class GaugeHeatFluxGasProps
    extends AAdditionalPropsPanel<GaugeHeatFluxGasMeasurer> {
        private static final long serialVersionUID = 904712893678455209L;
        private final ValueField<UnitDouble> d_gaugeTemperature;
        private final ValueField<UnitDouble> d_heatTransferCoeff;
        private final guiCheckBox d_enableHeatTransferCoeff = new guiCheckBox(Intl.intl("Enable Heat Transfer Coefficient:"));

        public GaugeHeatFluxGasProps() {
            super(GaugeHeatFluxGasMeasurer.class);
            this.d_heatTransferCoeff = ValueFields.udFld(UnitSystem.getSource(81));
            this.d_gaugeTemperature = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_gaugeTemperature.setNullAllowed(true);
            ValueFields.getFormat(this.d_gaugeTemperature).alias(null, "TMPA");
            this.d_gaugeTemperature.setValue(null);
            this.d_heatTransferCoeff.setEnabled(false);
            this.d_enableHeatTransferCoeff.addChangeListener(evt -> this.d_heatTransferCoeff.setEnabled(this.d_enableHeatTransferCoeff.isSelected()));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Gauge Temperature:"), this.d_gaugeTemperature, 0);
            gb.addRow(this.d_enableHeatTransferCoeff, this.d_heatTransferCoeff, 0);
            gb.finalizeRows();
            this.load(List.of(new GaugeHeatFluxGasMeasurer("", null)));
        }

        @Override
        public void load(Collection<GasPointMeasurer> ghfg) {
            GaugeHeatFluxGasMeasurer first = (GaugeHeatFluxGasMeasurer)ghfg.iterator().next();
            if (first != null) {
                if (DeviceEditorUtil.testIfAllElementsAreEqual(ghfg.stream().map(e -> ((GaugeHeatFluxGasMeasurer)e).getGaugeTemperature()), first.getGaugeTemperature())) {
                    this.d_gaugeTemperature.setValue(first.getGaugeTemperature());
                } else {
                    this.d_gaugeTemperature.setValue(null);
                }
                if (DeviceEditorUtil.testIfAllElementsAreEqual(ghfg.stream().map(e -> ((GaugeHeatFluxGasMeasurer)e).getHeatTransferCoefficient()), first.getHeatTransferCoefficient())) {
                    this.d_heatTransferCoeff.setValue(first.getHeatTransferCoefficient());
                } else {
                    this.d_heatTransferCoeff.setValue(null);
                }
                boolean isNull = this.d_heatTransferCoeff.getValue() == null;
                this.d_enableHeatTransferCoeff.setSelected(!isNull);
                if (isNull) {
                    this.d_heatTransferCoeff.setValue(new UnitDouble(0.0, SIUS.unit(81)));
                }
            }
        }

        @Override
        public void save(Collection<GasPointMeasurer> ghfg) {
            if (!this.d_gaugeTemperature.isEmpty()) {
                for (GasPointMeasurer g : ghfg) {
                    ((GaugeHeatFluxGasMeasurer)g).setGaugeTemperature((UnitDouble)this.d_gaugeTemperature.getValue());
                }
            }
            if (this.d_enableHeatTransferCoeff.isSelected() && !this.d_heatTransferCoeff.isEmpty()) {
                for (GasPointMeasurer g : ghfg) {
                    ((GaugeHeatFluxGasMeasurer)g).setHeatTransferCoefficient((UnitDouble)this.d_heatTransferCoeff.getValue());
                }
            }
        }

        @Override
        public boolean isMatchingType(Quantity q) {
            return Quantity.GAUGE_HEAT_FLUX_GAS.equals((Object)q);
        }
    }

    private static class ThermocoupleProps
    extends AAdditionalPropsPanel<Thermocouple> {
        private static final long serialVersionUID = 904712893678455207L;
        private final ValueField<UnitDouble> d_beadDiam = ValueFields.udFld(UnitSystem.getSource(9));
        private final ValueField<Double> d_emissivity = ValueFields.doubleFld();
        private final ValueField<UnitDouble> d_beadDensity = ValueFields.udFld(UnitSystem.getSource(4));
        private final ValueField<UnitDouble> d_beadSpecHeat = ValueFields.udFld(UnitSystem.getSource(11));

        public ThermocoupleProps() {
            super(Thermocouple.class);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Bead Diameter:"), this.d_beadDiam);
            gb.addRow(Intl.intl("Emissivity:"), this.d_emissivity);
            gb.addRow(Intl.intl("Bead Density:"), this.d_beadDensity);
            gb.addRow(Intl.intl("Bead Specific Heat:"), this.d_beadSpecHeat);
            gb.finalizeRows();
            this.load(Arrays.asList(new Thermocouple("", null)));
        }

        @Override
        public void load(Collection<GasPointMeasurer> tc) {
            Thermocouple first = (Thermocouple)tc.iterator().next();
            if (DeviceEditorUtil.testIfAllElementsAreEqual(tc.stream().map(e -> ((Thermocouple)e).getBeadDiameter()), first.getBeadDiameter())) {
                this.d_beadDiam.setValue(first.getBeadDiameter());
            } else {
                this.d_beadDiam.setValue(null);
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(tc.stream().map(e -> ((Thermocouple)e).getEmissivity()), Double.valueOf(first.getEmissivity()))) {
                this.d_emissivity.setValue(first.getEmissivity());
            } else {
                this.d_emissivity.setValue(null);
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(tc.stream().map(e -> ((Thermocouple)e).getBeadDensity()), first.getBeadDensity())) {
                this.d_beadDensity.setValue(first.getBeadDensity());
            } else {
                this.d_beadDensity.setValue(null);
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(tc.stream().map(e -> ((Thermocouple)e).getBeadSpecHeat()), first.getBeadSpecHeat())) {
                this.d_beadSpecHeat.setValue(first.getBeadSpecHeat());
            } else {
                this.d_beadSpecHeat.setValue(null);
            }
        }

        @Override
        public void save(Collection<GasPointMeasurer> tc) {
            if (!this.d_beadDiam.isEmpty()) {
                for (GasPointMeasurer t : tc) {
                    ((Thermocouple)t).setBeadDiameter((UnitDouble)this.d_beadDiam.getValue());
                }
            }
            if (!this.d_emissivity.isEmpty()) {
                for (GasPointMeasurer t : tc) {
                    ((Thermocouple)t).setEmissivity((Double)this.d_emissivity.getValue());
                }
            }
            if (!this.d_beadDensity.isEmpty()) {
                for (GasPointMeasurer t : tc) {
                    ((Thermocouple)t).setBeadDensity((UnitDouble)this.d_beadDensity.getValue());
                }
            }
            if (!this.d_beadSpecHeat.isEmpty()) {
                for (GasPointMeasurer t : tc) {
                    ((Thermocouple)t).setBeadSpecHeat((UnitDouble)this.d_beadSpecHeat.getValue());
                }
            }
        }

        @Override
        public boolean isMatchingType(Quantity q) {
            return Quantity.THERMOCOUPLE.equals((Object)q);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return true;
        }
    }

    public static class ControlValueDeviceProps
    extends guiPanel {
        static final long serialVersionUID = 1L;
        private final guiComboBox<ControlBridge> d_controlCombo;

        public ControlValueDeviceProps(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_controlCombo = new ControlBridgeComboBox(pyMod.getControls());
            this.d_controlCombo.setMinimumSize(this.d_controlCombo.getPreferredSize());
            JButton editControlsBtn = new JButton(Intl.intl("Edit..."));
            editControlsBtn.addActionListener(e -> {
                Actions.editControls(this.d_controlCombo.getSelectedItem());
                if (this.d_controlCombo.getSelectedItem() == null && this.d_controlCombo.getItemCount() > 0) {
                    this.d_controlCombo.setSelectedIndex(0);
                }
            });
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(Intl.intl("Control:"), this.d_controlCombo, editControlsBtn);
            gbh.finalizeRows();
        }

        public void load(ControlValueDevice devc) {
            this.d_controlCombo.setSelectedItem(devc.getLinkedControl());
        }

        public void save(ControlValueDevice devc) {
            devc.setLinkedControl(this.d_controlCombo.getSelectedItem());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_controlCombo.getSelectedItem() == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a Control."));
                }
                if (allowModify) {
                    this.d_controlCombo.requestFocus();
                }
                return false;
            }
            return true;
        }

        public static class ControlBridgeComboBox
        extends PyroComboBox<ControlBridge> {
            static final long serialVersionUID = 1L;

            public ControlBridgeComboBox(ControlMgr mgr) {
                super(mgr, ControlBridge.class);
                this.setFilter(cb -> ControlBridgeComboBox.isCustomControlBridge(cb) || ControlBridgeComboBox.isMathematicControlBridge(cb));
            }

            private static boolean isCustomControlBridge(ControlBridge cb) {
                if (cb.getInputPin().getConnections().size() > 0) {
                    ISignalSource src = cb.getInputPin().getConnectedSources().iterator().next();
                    return src instanceof CustomCtrl;
                }
                return false;
            }

            private static boolean isMathematicControlBridge(ControlBridge cb) {
                return cb.isMathControl();
            }
        }
    }

    public static class AdiabaticSurfTempGasProps
    extends AAdditionalPropsPanel<AdiabaticSurfTempGasMeasurer> {
        private static final long serialVersionUID = 6L;
        private ValueField<Double> d_emissivity = ValueFields.doubleFld();
        private ValueField<UnitDouble> d_heatTransferCoeff = ValueFields.udFld(UnitSystem.getSource(81));

        public AdiabaticSurfTempGasProps() {
            super(AdiabaticSurfTempGasMeasurer.class);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Emissivity:"), this.d_emissivity);
            gb.addRow(Intl.intl("Heat Transfer Coefficient"), this.d_heatTransferCoeff);
            gb.finalizeRows();
            this.load(Arrays.asList(new AdiabaticSurfTempGasMeasurer("", null)));
        }

        @Override
        public void load(Collection<GasPointMeasurer> astgm) {
            AdiabaticSurfTempGasMeasurer first = (AdiabaticSurfTempGasMeasurer)astgm.iterator().next();
            if (DeviceEditorUtil.testIfAllElementsAreEqual(astgm.stream().map(e -> ((AdiabaticSurfTempGasMeasurer)e).getEmissivity()), Double.valueOf(first.getEmissivity()))) {
                this.d_emissivity.setValue(first.getEmissivity());
            } else {
                this.d_emissivity.setValue(null);
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(astgm.stream().map(e -> ((AdiabaticSurfTempGasMeasurer)e).getHeatTransferCoeff()), first.getHeatTransferCoeff())) {
                this.d_heatTransferCoeff.setValue(first.getHeatTransferCoeff());
            } else {
                this.d_heatTransferCoeff.setValue(null);
            }
        }

        @Override
        public void save(Collection<GasPointMeasurer> astgm) {
            if (!this.d_emissivity.isEmpty()) {
                for (GasPointMeasurer t : astgm) {
                    ((AdiabaticSurfTempGasMeasurer)t).setEmissivity((Double)this.d_emissivity.getValue());
                }
            }
            if (!this.d_heatTransferCoeff.isEmpty()) {
                for (GasPointMeasurer t : astgm) {
                    ((AdiabaticSurfTempGasMeasurer)t).setHeatTransferCoeff((UnitDouble)this.d_heatTransferCoeff.getValue());
                }
            }
        }

        @Override
        public boolean isMatchingType(Quantity q) {
            return Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS.equals((Object)q);
        }
    }

    private static enum SpecialQuantityTypes {
        ADIABATIC_SURF_TEMP(Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS, AdiabaticSurfTempGasProps::new),
        GAUGE_HEAT_FLUX(Quantity.GAUGE_HEAT_FLUX_GAS, GaugeHeatFluxGasProps::new),
        FED(Quantity.FED, FEDMeasureProps::new),
        THERMOCOUPLE(Quantity.THERMOCOUPLE, ThermocoupleProps::new);

        public final Quantity q;
        public final Supplier<AAdditionalPropsPanel<?>> buildPanelFunc;

        private SpecialQuantityTypes(Quantity q, Supplier<AAdditionalPropsPanel<?>> buildPanelFunc) {
            this.q = q;
            this.buildPanelFunc = buildPanelFunc;
        }
    }

    private static abstract class AAdditionalPropsPanel<T extends GasPointMeasurer>
    extends guiPanel
    implements IAdditionalPropsPanel<T> {
        private static final long serialVersionUID = 1L;
        private final Class<T> clazz;

        protected AAdditionalPropsPanel(Class<T> type) {
            this.clazz = type;
        }

        @Override
        public boolean isMatchingType(GasPointMeasurer measurer) {
            return this.clazz.isAssignableFrom(measurer.getClass());
        }
    }

    private static interface IAdditionalPropsPanel<T> {
        public void load(Collection<GasPointMeasurer> var1);

        public void save(Collection<GasPointMeasurer> var1);

        public boolean isMatchingType(Quantity var1);

        public boolean isMatchingType(GasPointMeasurer var1);
    }
}

