/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.gui.MappedListCellRenderer;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class FlowMeasurerEditor
extends ADevcEditor<FlowMeasurer> {
    private final FlowMeasurerDataPanel d_dataPanel;
    private final AARectangleEditor d_geomEditor = new AARectangleEditor(true);

    public FlowMeasurerEditor(PyroMod pyMod) {
        this.d_dataPanel = new FlowMeasurerDataPanel(pyMod, () -> this.d_geomEditor.getPlaneCB().getSelectedIndex());
    }

    @Override
    public String getDesc() {
        return Intl.intl("Flow Measuring Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("FLOW");
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        AlarmInfoPanel alarmPanel = new AlarmInfoPanel(this.d_dataPanel.getQuantity());
        ItemListener quantChangeHandler = e -> alarmPanel.setCurrentMsr(this.d_dataPanel.getQuantity());
        this.d_dataPanel.d_measureCombo.addItemListener(quantChangeHandler);
        this.d_dataPanel.d_massSolidSubtypeCombo.addItemListener(quantChangeHandler);
        this.d_dataPanel.d_massGasSubtypeCombo.addItemListener(quantChangeHandler);
        this.d_geomEditor.getPlaneCB().addItemListener(quantChangeHandler);
        return alarmPanel;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return this.d_geomEditor;
    }

    @Override
    public Collection<FlowMeasurer> create() {
        Integer flowDirNullable = this.d_dataPanel.getFlowDir();
        int flowDir = flowDirNullable != null ? flowDirNullable : 2;
        List<FlowMeasurer> result = Arrays.asList(new FlowMeasurer("", this.d_dataPanel.getQuantity(), new AARectangle(), flowDir));
        this.save((Collection<FlowMeasurer>)result);
        return result;
    }

    @Override
    public void load(Collection<FlowMeasurer> fm) {
        this.d_dataPanel.load(fm);
        this.d_geomEditor.setEnabled(this.d_dataPanel.d_measureCombo.isEnabled());
    }

    @Override
    public void save(Collection<FlowMeasurer> msr) {
        this.d_dataPanel.save(msr);
    }

    @Override
    public boolean enableAlarmPanel() {
        return this.d_dataPanel.d_measureCombo.isEnabled();
    }

    @Override
    public boolean validateData(Component parent, Collection<FlowMeasurer> loadedObjs, boolean showWarn, boolean allowModify) {
        if (loadedObjs == null) {
            return true;
        }
        return loadedObjs.stream().allMatch(loadedObj -> MsrDeviceEditorUtil.validateData(parent, loadedObjs, this.d_dataPanel.getQuantity(), showWarn, allowModify));
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class FlowMeasurerDataPanel
    extends guiPanel {
        static final long serialVersionUID = 1L;
        private final guiComboBox<MeasureType> d_measureCombo;
        private final guiComboBox<MassGasType> d_massGasSubtypeCombo;
        private final guiComboBox<MassSolidType> d_massSolidSubtypeCombo;
        private final guiComboBox<Integer> d_directionCombo;
        private final guiComboBox<ExSpec> d_specCombo;
        private final guiLabel d_directionLbl;
        private final guiLabel d_massGasLbl;
        private final guiLabel d_massSolidLbl;
        private final guiLabel d_specLbl;
        private final Supplier<Integer> d_planeLogicInterpreter;

        public FlowMeasurerDataPanel(PyroMod pyMod, Supplier<Integer> planeInfoSupplier) {
            this.setLayout(new GridBagLayout());
            this.d_planeLogicInterpreter = planeInfoSupplier;
            this.d_directionLbl = new guiLabel(Intl.intl("Flow Direction:"));
            this.d_massGasLbl = new guiLabel(Intl.intl("Component:"));
            this.d_massSolidLbl = new guiLabel(Intl.intl("Component:"));
            this.d_specLbl = new guiLabel(Intl.intl("Species:"));
            this.d_specCombo = new ExSpecComboBox(pyMod.getExSpecList(), null, Intl.intl("All"));
            this.d_measureCombo = new guiComboBox<MeasureType>(MeasureType.ENTHALPY, MeasureType.ENTHALPY_BOUNDARY, MeasureType.MASS, MeasureType.MASS_BOUNDARY, MeasureType.VOLUME, MeasureType.VOLUME_BOUNDARY);
            this.d_measureCombo.setRenderer(new DefaultListCellRenderer(){
                static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    String displayStr = value != null ? ((MeasureType)((Object)value)).displayString : "";
                    this.setText(displayStr);
                    return this;
                }
            });
            this.d_massGasSubtypeCombo = new guiComboBox<MassGasType>(MassGasType.DEFAULT, MassGasType.TOTAL, MassGasType.ADVECTIVE, MassGasType.DIFFUSIVE);
            this.d_massGasSubtypeCombo.setRenderer(new DefaultListCellRenderer(){
                static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.setText(((MassGasType)((Object)value)).displayString);
                    return this;
                }
            });
            this.d_massSolidSubtypeCombo = new guiComboBox<MassSolidType>(MassSolidType.DEFAULT, MassSolidType.WALL, MassSolidType.TOTAL_WALL);
            this.d_massSolidSubtypeCombo.setRenderer(new DefaultListCellRenderer(){
                static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.setText(((MassSolidType)((Object)value)).displayString);
                    return this;
                }
            });
            this.d_directionCombo = new guiComboBox<Integer>((T[])new Integer[]{0, 1, 2});
            this.d_directionCombo.setRenderer(new MappedListCellRenderer<Integer>(flowDir -> {
                if (flowDir == null) {
                    return "";
                }
                switch (flowDir) {
                    case 0: {
                        return Intl.intl("Positive");
                    }
                    case 1: {
                        return Intl.intl("Negative");
                    }
                }
                MeasureType item = this.d_measureCombo.getSelectedItem();
                QuantityType itemType = item != null ? item.type : null;
                return QuantityType.GAS.equals((Object)itemType) ? Intl.intl("Both") : Intl.intl("Auto");
            }));
            this.d_directionCombo.setMinimumSize(this.d_directionCombo.getPreferredSize());
            this.d_directionCombo.setSelectedItem(2);
            this.d_measureCombo.addItemListener(evt -> {
                this.updateDirectionLbl(evt);
                this.updateMassGasElements();
                this.updateMassSolidElements();
                this.updateSpecEditor();
                PyroGuiUtil.pack(this);
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Measurement Type:"), this.d_measureCombo, 0);
            gb.addRow(this.d_specLbl, this.d_specCombo, 0);
            gb.addRow(this.d_massGasLbl, this.d_massGasSubtypeCombo, 0);
            gb.addRow(this.d_massSolidLbl, this.d_massSolidSubtypeCombo, 0);
            gb.addRow(this.d_directionLbl, this.d_directionCombo, 0);
            gb.finalizeRows();
            this.updateMassSolidElements();
            this.updateMassGasElements();
            this.updateSpecEditor();
        }

        private void updateDirectionLbl(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                QuantityType qt = this.d_measureCombo.getSelectedItem().type;
                if (qt == QuantityType.GAS) {
                    this.d_directionLbl.setText(Intl.intl("Flow Direction:"));
                } else {
                    this.d_directionLbl.setText(Intl.intl("Wall Normal:"));
                }
                this.d_directionCombo.invalidate();
            }
        }

        private void updateSpecEditor() {
            MeasureType item = this.d_measureCombo.getSelectedItem();
            boolean show = MeasureType.MASS.equals((Object)item) || MeasureType.MASS_BOUNDARY.equals((Object)item);
            this.d_specLbl.setVisible(show);
            this.d_specCombo.setVisible(show);
        }

        private void updateMassGasElements() {
            MeasureType item = this.d_measureCombo.getSelectedItem();
            boolean show = MeasureType.MASS.equals((Object)item);
            this.d_massGasLbl.setVisible(show);
            this.d_massGasSubtypeCombo.setVisible(show);
        }

        private void updateMassSolidElements() {
            MeasureType item = this.d_measureCombo.getSelectedItem();
            boolean show = MeasureType.MASS_BOUNDARY.equals((Object)item);
            this.d_massSolidLbl.setVisible(show);
            this.d_massSolidSubtypeCombo.setVisible(show);
        }

        public Integer getFlowDir() {
            return this.d_directionCombo.getSelectedItem();
        }

        public IQuantity getQuantity() {
            if (this.d_measureCombo.getSelectedItem() == null) {
                return null;
            }
            StaticQuantity quant = null;
            int plane = this.d_planeLogicInterpreter.get();
            ExSpec spec = this.d_specCombo.getSelectedItem();
            if (this.d_measureCombo.getSelectedItem().equals((Object)MeasureType.VOLUME)) {
                if (plane == 0) {
                    quant = Quantity.VOLUME_FLOW_X.create();
                } else if (plane == 1) {
                    quant = Quantity.VOLUME_FLOW_Y.create();
                } else if (plane == 2) {
                    quant = Quantity.VOLUME_FLOW_Z.create();
                }
            } else if (this.d_measureCombo.getSelectedItem().equals((Object)MeasureType.VOLUME_BOUNDARY)) {
                quant = Quantity.VOLUME_FLOW_BOUNDARY.create();
            } else if (this.d_measureCombo.getSelectedItem().equals((Object)MeasureType.MASS)) {
                if (this.d_massGasSubtypeCombo.getSelectedItem().equals((Object)MassGasType.DEFAULT)) {
                    if (plane == 0) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_X.create() : Quantity.SPEC_MASS_FLOW_X.create(spec);
                    } else if (plane == 1) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Y.create() : Quantity.SPEC_MASS_FLOW_Y.create(spec);
                    } else if (plane == 2) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Z.create() : Quantity.SPEC_MASS_FLOW_Z.create(spec);
                    }
                } else if (this.d_massGasSubtypeCombo.getSelectedItem().equals((Object)MassGasType.TOTAL)) {
                    if (plane == 0) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_X_TOTAL.create() : Quantity.SPEC_MASS_FLOW_X_TOTAL.create(spec);
                    } else if (plane == 1) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Y_TOTAL.create() : Quantity.SPEC_MASS_FLOW_Y_TOTAL.create(spec);
                    } else if (plane == 2) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Z_TOTAL.create() : Quantity.SPEC_MASS_FLOW_Z_TOTAL.create(spec);
                    }
                } else if (this.d_massGasSubtypeCombo.getSelectedItem().equals((Object)MassGasType.ADVECTIVE)) {
                    if (plane == 0) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_X_ADVECTIVE.create() : Quantity.SPEC_MASS_FLOW_X_ADVECTIVE.create(spec);
                    } else if (plane == 1) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Y_ADVECTIVE.create() : Quantity.SPEC_MASS_FLOW_Y_ADVECTIVE.create(spec);
                    } else if (plane == 2) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Z_ADVECTIVE.create() : Quantity.SPEC_MASS_FLOW_Z_ADVECTIVE.create(spec);
                    }
                } else if (this.d_massGasSubtypeCombo.getSelectedItem().equals((Object)MassGasType.DIFFUSIVE)) {
                    if (plane == 0) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_X_DIFFUSIVE.create() : Quantity.SPEC_MASS_FLOW_X_DIFFUSIVE.create(spec);
                    } else if (plane == 1) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Y_DIFFUSIVE.create() : Quantity.SPEC_MASS_FLOW_Y_DIFFUSIVE.create(spec);
                    } else if (plane == 2) {
                        quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_Z_DIFFUSIVE.create() : Quantity.SPEC_MASS_FLOW_Z_DIFFUSIVE.create(spec);
                    }
                }
            } else if (this.d_measureCombo.getSelectedItem().equals((Object)MeasureType.MASS_BOUNDARY)) {
                if (this.d_massSolidSubtypeCombo.getSelectedItem().equals((Object)MassSolidType.DEFAULT)) {
                    quant = spec == null ? Quantity.NOSPEC_MASS_FLOW.create() : Quantity.SPEC_MASS_FLOW.create(spec);
                } else if (this.d_massSolidSubtypeCombo.getSelectedItem().equals((Object)MassSolidType.WALL)) {
                    quant = spec == null ? Quantity.NOSPEC_MASS_FLOW_WALL.create() : Quantity.SPEC_MASS_FLOW_WALL.create(spec);
                } else if (this.d_massSolidSubtypeCombo.getSelectedItem().equals((Object)MassSolidType.TOTAL_WALL)) {
                    quant = spec == null ? Quantity.NOSPEC_TOTAL_MASS_FLOW_WALL.create() : Quantity.SPEC_TOTAL_MASS_FLOW_WALL.create(spec);
                }
            } else if (this.d_measureCombo.getSelectedItem().equals((Object)MeasureType.ENTHALPY)) {
                if (plane == 0) {
                    quant = Quantity.ENTHALPY_FLOW_X.create();
                } else if (plane == 1) {
                    quant = Quantity.ENTHALPY_FLOW_Y.create();
                } else if (plane == 2) {
                    quant = Quantity.ENTHALPY_FLOW_Z.create();
                }
            } else if (this.d_measureCombo.getSelectedItem().equals((Object)MeasureType.ENTHALPY_BOUNDARY)) {
                quant = Quantity.ENTHALPY_FLOW_WALL.create();
            }
            return quant;
        }

        public void loadQuantity(IQuantity quantContainer, boolean enableQuantCombo) {
            Quantity quant = quantContainer != null ? quantContainer.get() : null;
            this.d_specCombo.setSelectedItem(null);
            if (quantContainer instanceof ObjectQuantity) {
                ExSpec selSpec = (ExSpec)((ObjectQuantity)quantContainer).objects[0];
                this.d_specCombo.setSelectedItem(selSpec);
            }
            this.d_measureCombo.setSelectedItem(null);
            if (Quantity.VOLUME_FLOW_X.equals((Object)quant) || Quantity.VOLUME_FLOW_Y.equals((Object)quant) || Quantity.VOLUME_FLOW_Z.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.VOLUME);
            }
            if (Quantity.VOLUME_FLOW_BOUNDARY.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.VOLUME_BOUNDARY);
            }
            if (Quantity.NOSPEC_MASS_FLOW_X.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Y.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Z.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_X.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Y.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Z.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS);
                this.d_massGasSubtypeCombo.setSelectedItem((Object)MassGasType.DEFAULT);
                this.d_massGasSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.NOSPEC_MASS_FLOW_X_TOTAL.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Y_TOTAL.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Z_TOTAL.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_X_TOTAL.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Y_TOTAL.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Z_TOTAL.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS);
                this.d_massGasSubtypeCombo.setSelectedItem((Object)MassGasType.TOTAL);
                this.d_massGasSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.NOSPEC_MASS_FLOW_X_ADVECTIVE.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Y_ADVECTIVE.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Z_ADVECTIVE.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_X_ADVECTIVE.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Y_ADVECTIVE.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Z_ADVECTIVE.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS);
                this.d_massGasSubtypeCombo.setSelectedItem((Object)MassGasType.ADVECTIVE);
                this.d_massGasSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.NOSPEC_MASS_FLOW_X_DIFFUSIVE.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Y_DIFFUSIVE.equals((Object)quant) || Quantity.NOSPEC_MASS_FLOW_Z_DIFFUSIVE.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_X_DIFFUSIVE.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Y_DIFFUSIVE.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_Z_DIFFUSIVE.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS);
                this.d_massGasSubtypeCombo.setSelectedItem((Object)MassGasType.DIFFUSIVE);
                this.d_massGasSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.NOSPEC_MASS_FLOW.equals((Object)quant) || Quantity.SPEC_MASS_FLOW.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS_BOUNDARY);
                this.d_massSolidSubtypeCombo.setSelectedItem((Object)MassSolidType.DEFAULT);
                this.d_massSolidSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.NOSPEC_MASS_FLOW_WALL.equals((Object)quant) || Quantity.SPEC_MASS_FLOW_WALL.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS_BOUNDARY);
                this.d_massSolidSubtypeCombo.setSelectedItem((Object)MassSolidType.WALL);
                this.d_massSolidSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.NOSPEC_TOTAL_MASS_FLOW_WALL.equals((Object)quant) || Quantity.SPEC_TOTAL_MASS_FLOW_WALL.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.MASS_BOUNDARY);
                this.d_massSolidSubtypeCombo.setSelectedItem((Object)MassSolidType.TOTAL_WALL);
                this.d_massSolidSubtypeCombo.setEnabled(enableQuantCombo);
            }
            if (Quantity.ENTHALPY_FLOW_X.equals((Object)quant) || Quantity.ENTHALPY_FLOW_Y.equals((Object)quant) || Quantity.ENTHALPY_FLOW_Z.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.ENTHALPY);
            }
            if (Quantity.ENTHALPY_FLOW_WALL.equals((Object)quant)) {
                this.d_measureCombo.setSelectedItem((Object)MeasureType.ENTHALPY_BOUNDARY);
            }
            this.d_measureCombo.setEnabled(enableQuantCombo);
        }

        public void load(Collection<FlowMeasurer> fm) {
            boolean enableMeasCombo;
            List<IQuantity> distinctQuants = fm.stream().map(obj -> obj.getQuantity()).distinct().toList();
            boolean bl = enableMeasCombo = distinctQuants.size() <= 1;
            if (distinctQuants.size() == 1) {
                this.loadQuantity(distinctQuants.getFirst(), enableMeasCombo);
            } else {
                this.loadQuantity(null, enableMeasCombo);
            }
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_directionCombo, fm.stream().map(f -> f.getFlowDir()).toList());
            this.d_directionCombo.setEnabled(enableMeasCombo);
        }

        public void save(Collection<FlowMeasurer> fm) {
            Optional<Integer> dir;
            IQuantity newMsr = this.getQuantity();
            if (newMsr != null) {
                for (FlowMeasurer f : fm) {
                    f.setQuantity(newMsr);
                }
            }
            if ((dir = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_directionCombo)).isPresent()) {
                for (FlowMeasurer f : fm) {
                    f.setFlowDir(this.d_directionCombo.getSelectedItem());
                }
            }
        }

        private static enum MeasureType {
            VOLUME(Intl.intl("Volume Flow in the Gas Phase"), QuantityType.GAS),
            VOLUME_BOUNDARY(Intl.intl("Volume Flow at a Boundary"), QuantityType.SOLID),
            MASS(Intl.intl("Mass Flow in the Gas Phase"), QuantityType.GAS),
            MASS_BOUNDARY(Intl.intl("Mass Flow at a Boundary"), QuantityType.SOLID),
            ENTHALPY(Intl.intl("Enthalpy Flow in the Gas Phase"), QuantityType.GAS),
            ENTHALPY_BOUNDARY(Intl.intl("Enthalpy Flow at a Boundary"), QuantityType.SOLID);

            public final String displayString;
            public final QuantityType type;

            private MeasureType(String displayString, QuantityType type) {
                this.displayString = displayString;
                this.type = type;
            }
        }

        private static enum MassGasType {
            DEFAULT(Intl.intl("Default")),
            TOTAL(Intl.intl("Total Mass Flux")),
            ADVECTIVE(Intl.intl("Advective Mass Flux")),
            DIFFUSIVE(Intl.intl("Diffusive Mass Flux"));

            public final String displayString;

            private MassGasType(String displayString) {
                this.displayString = displayString;
            }
        }

        private static enum MassSolidType {
            DEFAULT(Intl.intl("Default")),
            WALL(Intl.intl("Mass Flux Wall")),
            TOTAL_WALL(Intl.intl("Total Mass Flux Wall"));

            public final String displayString;

            private MassSolidType(String displayString) {
                this.displayString = displayString;
            }
        }
    }
}

