/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Arrays;
import java.util.Collection;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;

public class DryPipeEditor
extends ADevcEditor<DryPipe> {
    private final ValueField<UnitDouble> d_delayFld = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.SECOND, UnitSystem.getSource(2));

    public DryPipeEditor() {
        this.d_delayFld.setNullAllowed(true);
        DryPipe defaultPipe = new DryPipe("");
        this.d_delayFld.setValue(defaultPipe.getDelay());
    }

    @Override
    public String getDesc() {
        return Intl.intl("Dry Pipe");
    }

    @Override
    public String getDefName() {
        return Intl.intl("DRYPIPE");
    }

    @Override
    public boolean getCustomEnabled() {
        return false;
    }

    @Override
    public boolean getPreviewEnabled() {
        return false;
    }

    @Override
    public Collection<DryPipe> create() {
        return Arrays.asList(new DryPipe(""));
    }

    @Override
    public void load(Collection<DryPipe> pipe) {
        DryPipe first = pipe.iterator().next();
        if (DeviceEditorUtil.testIfAllElementsAreEqual(pipe.stream().map(e -> e.getDelay()), first.getDelay())) {
            this.d_delayFld.setValue(first.getDelay());
        } else {
            this.d_delayFld.setValue(null);
        }
    }

    @Override
    public void save(Collection<DryPipe> pipe) {
        if (!this.d_delayFld.isEmpty()) {
            for (DryPipe p : pipe) {
                p.setDelay((UnitDouble)this.d_delayFld.getValue());
            }
        }
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return null;
    }

    @Override
    public guiPanel getDataPanel() {
        guiPanel pnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addRow(Intl.intl("Depressurize delay:"), this.d_delayFld, 0);
        gb.finalizeRows();
        return pnl;
    }
}

