/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JSeparator;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tags.ITaggable;
import pyrosim.gui.IGridBagAdder;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TagsPnl;
import pyrosim.gui.devices.TripFlagsPanel;
import pyrosim.gui.geom.AttachedPointGeomEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.guiListBuilder;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class DevicePnl<T extends IDevice>
extends guiPanel {
    private static final long serialVersionUID = 1967996334902404556L;
    public static final int OPT_NAME = 1;
    public static final int OPT_GEOM = 2;
    public static final int OPT_TAGS = 4;
    public static final int OPT_ALL = 7;
    private final Class<T> d_type;
    private final IDevcEditor<T> d_editor;
    private final NamePnl d_namePnl;
    private final TagsPnl d_tagPnl;
    private final IGeomEditor<? extends IGeom> d_geomEditor;
    private final AlarmInfoPanel d_alarmPanel;
    private final TripFlagsPanel d_tripFlagsPanel;
    private final ControlSelPnl d_eventPanel;
    private Collection<T> d_loadedObj;
    private List<Validateable> d_toValidate = new ArrayList<Validateable>();

    public DevicePnl(PyroMod pyMod, Class<T> type, IDevcEditor<T> editor, int options) {
        this.d_editor = editor;
        this.d_type = type;
        this.d_geomEditor = DevicePnl.test(options, 2) ? this.d_editor.createGeomEditor() : null;
        this.d_namePnl = DevicePnl.test(options, 1) ? new NamePnl(pyMod, editor.getDefName()) : null;
        this.d_tagPnl = DevicePnl.test(options, 4) ? new TagsPnl() : null;
        this.d_alarmPanel = IMeasurer.class.isAssignableFrom(type) ? editor.createAlarmPanel() : null;
        this.d_tripFlagsPanel = IDetector.class.isAssignableFrom(type) ? editor.createTripPanel() : null;
        this.d_eventPanel = ISignalSink.class.isAssignableFrom(type) ? editor.createCtrlInputPanel(pyMod, this.d_namePnl) : null;
        guiListBuilder<Object> panels = new guiListBuilder<Object>();
        panels.add(this.d_namePnl);
        panels.add(this.d_tagPnl);
        panels.add(this.d_eventPanel);
        panels.add(editor.getDataPanel());
        panels.addSeparator();
        panels.add(this.d_alarmPanel);
        panels.addSeparator();
        panels.add(this.d_tripFlagsPanel);
        panels.addSeparator();
        panels.add(this.d_geomEditor);
        GridBagHelper gb = new GridBagHelper(this);
        for (Object panel : panels.finalizeList()) {
            if (panel instanceof IGridBagAdder) {
                ((IGridBagAdder)panel).add(gb);
                if (!(panel instanceof Validateable)) continue;
                this.d_toValidate.add((Validateable)panel);
                continue;
            }
            if (panel instanceof Component) {
                gb.addFilledRow(panel);
                continue;
            }
            if (panel != null) continue;
            gb.addFilledRow(new JSeparator());
        }
        gb.finalizeRows();
        if (this.d_eventPanel != null) {
            this.setMinimumSize(new Dimension(400, 0));
        }
    }

    public IDevcEditor<T> getDevcEditor() {
        return this.d_editor;
    }

    public Class<T> getDevcType() {
        return this.d_type;
    }

    private static final boolean test(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public void load(Collection<T> devices) {
        IDevice d;
        boolean loaded = false;
        boolean isSingleDevc = devices.size() == 1;
        IDevice first = (IDevice)devices.iterator().next();
        if (this.d_namePnl != null) {
            String multiStr = String.format(Intl.intl("<%s Devices Selected>"), devices.size());
            this.d_namePnl.load(isSingleDevc ? first.getName() : multiStr);
            this.d_namePnl.getNameField().setEditable(isSingleDevc);
            loaded = true;
        }
        Collection tagView = devices.stream().filter(obj -> obj instanceof ITaggable).map(obj -> obj).collect(Collectors.toList());
        if (this.d_tagPnl != null && tagView.containsAll(devices)) {
            this.d_tagPnl.load(tagView);
            loaded = true;
        }
        this.d_editor.load(devices);
        if (this.d_eventPanel != null) {
            if (this.d_namePnl != null) {
                this.d_eventPanel.setNameSrc(this.d_namePnl.getNameField(), devices);
            }
            IInPin firstInPin = ((ISignalSink)((Object)first)).getInputPin();
            if (DeviceEditorUtil.testIfAllElementsAreEqual(devices.stream().map(t -> ((ISignalSink)((Object)t)).getInputPin()), firstInPin)) {
                this.d_eventPanel.load(Arrays.asList((OneLogicInPin)firstInPin));
            } else {
                this.d_eventPanel.load(Collections.emptyList());
            }
            loaded = true;
        }
        if (this.d_alarmPanel != null && (d = (IDevice)devices.iterator().next()) instanceof IMeasurer) {
            IMeasurer msr = (IMeasurer)d;
            if (DeviceEditorUtil.testIfAllElementsAreEqual(devices.stream().map(e -> ((IMeasurer)e).getMsrInfo(0).getAlarmInfo()), msr.getMsrInfo(0).getAlarmInfo())) {
                if (devices.stream().allMatch(e -> ((IMeasurer)e).getMsrInfo(0).getAlarmInfo() == null)) {
                    this.d_alarmPanel.load(msr.getQuantity(0), null);
                } else {
                    this.d_alarmPanel.load(msr.getQuantity(0), msr.getMsrInfo(0).getAlarmInfo());
                }
                loaded = true;
            } else if (devices.stream().allMatch(e -> ((IMeasurer)e).getMsrInfo(0).isEnabled()) || devices.stream().anyMatch(e -> ((IMeasurer)e).getMsrInfo(0).getAlarmInfo() != null)) {
                assert (msr.getNumMeasurements() == 1);
                this.d_alarmPanel.load(msr.getQuantity(0), null, true);
                loaded = true;
            } else {
                this.d_alarmPanel.load(msr.getQuantity(0), null);
            }
            this.d_alarmPanel.setEnabled(this.d_editor.enableAlarmPanel());
        }
        if (this.d_tripFlagsPanel != null && first instanceof IDetector) {
            int[] flags = devices.stream().map(e -> ((IDetector)e).getTripFlags()).mapToInt(i -> i).toArray();
            this.d_tripFlagsPanel.load(flags);
            loaded = true;
        }
        if (this.d_geomEditor != null) {
            if (this.d_geomEditor instanceof FreePointGeomEditor) {
                ((FreePointGeomEditor)this.d_geomEditor).allowNullValues(true);
            }
            if (this.d_geomEditor instanceof AttachedPointGeomEditor) {
                ((AttachedPointGeomEditor)this.d_geomEditor).allowNullValues(true);
            }
            this.d_geomEditor.load(devices);
            loaded = true;
        }
        assert (loaded);
        this.d_loadedObj = devices;
    }

    public Collection<T> save(Collection<T> devices) {
        if (devices == null || devices.stream().allMatch(Objects::isNull)) {
            devices = this.d_editor.create();
        }
        if (this.d_namePnl != null && this.d_namePnl.save().isPresent()) {
            String name = this.d_namePnl.save().get();
            for (IDevice d : devices) {
                d.setName(name);
            }
        }
        this.d_editor.save(devices);
        if (this.d_eventPanel != null && devices.stream().allMatch(e -> e instanceof ISignalSink)) {
            for (IDevice device : devices) {
                this.d_eventPanel.save(Arrays.asList((OneLogicInPin)((ISignalSink)((Object)device)).getInputPin()));
                device.changedEvt(new Object[0]);
            }
        }
        if (this.d_alarmPanel != null && devices.stream().allMatch(e -> e instanceof IMeasurer)) {
            IDevice devc = (IDevice)devices.iterator().next();
            int CBstate = this.d_alarmPanel.getEnableAlarmCBState();
            Optional<AlarmInfo> info = this.d_alarmPanel.save();
            if (info.isPresent()) {
                for (IDevice m : devices) {
                    if (m instanceof StatisticsDevc) {
                        StatisticsDevc stat = (StatisticsDevc)m;
                        stat.setAlarmInfo(info.get());
                        continue;
                    }
                    IMeasurer msr = (IMeasurer)m;
                    msr.getMsrInfo(0).setAlarmInfo(info.get());
                    assert (IntStream.range(0, msr.getNumMeasurements()).mapToObj(i -> msr.getMsrInfo(i).getAlarmInfo()).allMatch(alarm -> Objects.equals(alarm, msr.getMsrInfo(0).getAlarmInfo())));
                }
            } else if (CBstate == 0) {
                for (IDevice m : devices) {
                    ((IMeasurer)m).getMsrInfo(0).setAlarmInfo(null);
                }
            }
        }
        if (this.d_tripFlagsPanel != null) {
            List<IDetector> detectors = devices.stream().filter(obj -> obj instanceof IDetector).map(obj -> (IDetector)obj).toList();
            this.d_tripFlagsPanel.save(detectors);
        }
        if (this.d_geomEditor != null) {
            this.d_geomEditor.save(devices);
            for (IDevice devc : devices) {
                devc.setGeom(devc.getGeom().bakeIfRecommended());
            }
        }
        return devices;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_loadedObj == null) {
            return true;
        }
        for (Validateable v : this.d_toValidate) {
            if (v.validateData(showWarn, allowModify)) continue;
            return false;
        }
        if (!this.d_editor.validateData(this, this.d_loadedObj, showWarn, allowModify)) {
            return false;
        }
        if (this.d_geomEditor != null && !this.d_geomEditor.validateData(this.d_loadedObj, showWarn, allowModify)) {
            return false;
        }
        return this.d_eventPanel == null || this.d_eventPanel.validateData(this, this.d_loadedObj, showWarn, allowModify);
    }

    public Task getBundledUpdates(PyroMod domain, Collection<T> devc) {
        if (this.d_tagPnl != null) {
            List<ITaggable> taggables = devc.stream().filter(obj -> obj instanceof ITaggable).map(obj -> obj).toList();
            assert (taggables.containsAll(devc));
            return this.d_tagPnl.getSaveAction(domain, taggables);
        }
        return EmptyTask.INSTANCE;
    }
}

