/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TripFlagsPanel;

public abstract class ADevcEditor<T extends IDevice>
implements IDevcEditor<T> {
    @Override
    public AlarmInfoPanel createAlarmPanel() {
        Collection tempObj = this.create();
        IDevice first = (IDevice)tempObj.iterator().next();
        if (first instanceof IMeasurer) {
            ArrayList<IMeasurer> measurements = new ArrayList<IMeasurer>();
            for (IDevice t : tempObj) {
                measurements.add((IMeasurer)t);
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(measurements.stream(), (IMeasurer)measurements.get(0)) && ((IMeasurer)measurements.get(0)).getNumMeasurements() == 1) {
                return new AlarmInfoPanel(((IMeasurer)measurements.get(0)).getQuantity(0), 0);
            }
        }
        return null;
    }

    @Override
    public TripFlagsPanel createTripPanel() {
        return new TripFlagsPanel();
    }

    @Override
    public ControlSelPnl createCtrlInputPanel(PyroMod domain, NamePnl namePnl) {
        Collection tempDevices = this.create();
        IDevice first = (IDevice)tempDevices.iterator().next();
        if (first instanceof ISignalSink && ((ISignalSink)((Object)first)).getInputPin() instanceof OneLogicInPin) {
            String lbl = first instanceof IFreezable ? Intl.intl("Freeze Output:") : null;
            String tt = first instanceof IFreezable ? Intl.intl("Freezes the output of the device when a control activates.") : null;
            ControlSelPnl eventPanel = new ControlSelPnl(domain.getControls(), lbl, tt);
            if (namePnl != null && namePnl.save().isPresent()) {
                String name = namePnl.save().get();
                for (IDevice temp : tempDevices) {
                    temp.setName(name);
                }
                eventPanel.setNameSrc(namePnl.getNameField(), tempDevices);
            }
            return eventPanel;
        }
        return null;
    }

    @Override
    public boolean enableAlarmPanel() {
        return true;
    }

    @Override
    public boolean validateData(Component parent, Collection<T> loadedObj, boolean showWarn, boolean allowModify) {
        return true;
    }
}

