/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.Util;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.SignalsUtil;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnl;
import pyrosim.gui.controls.ControlPnlUtil;
import pyrosim.gui.controls.ControlStatementPnl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashSet;

public class LogicControlPnl
extends guiPanel
implements IEditor<ControlBridge> {
    private static final long serialVersionUID = 1L;
    private static final int INDENT = 18;
    private final ControlPnl d_parent;
    private final ActionPnl d_actionPnl;
    private final LatchPnl d_latchPnl;
    private final InputPnl d_inputTypePnl;
    private final ControlStatementPnl d_statementPnl;
    private List<ISignalSink> d_originalSinks = Collections.emptyList();
    private ControlPnlUtil.PopupWindow d_currentPopup = null;
    private Map<AControl, Util.ControlBridgeAsSinkHelper> d_controlSinks;

    public LogicControlPnl(ControlPnl parent) {
        super(new GridBagLayout());
        this.d_parent = parent;
        this.d_actionPnl = new ActionPnl();
        this.d_latchPnl = new LatchPnl();
        this.d_inputTypePnl = new InputPnl();
        this.d_statementPnl = new ControlStatementPnl(this, true);
        int row = 0;
        GridBagUtil.add(this, this.d_inputTypePnl, 0, ++row, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_actionPnl, 0, ++row, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_latchPnl, 0, ++row, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_statementPnl, 0, ++row, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        ActionListener updateList = e -> this.updatePanels();
        Runnable updateLatch = () -> this.updateLatch(this.d_inputTypePnl.getValue(), this.d_statementPnl.getDescription().d_srcDetectors.size());
        this.d_actionPnl.addListener(updateList);
        this.d_latchPnl.addListener(updateList);
        this.d_inputTypePnl.addListener(updateList);
        this.d_statementPnl.addOnSourceSelectUpdater(updateLatch);
        this.d_actionPnl.d_createBtn.setSelected(true);
        this.d_latchPnl.d_latchCb.setSelected(true);
        this.d_inputTypePnl.d_timeBtn.setSelected(true);
        this.updatePanels();
        this.setEnabled(false);
        this.setModified(false);
    }

    public ControlPnl getParentEditor() {
        return this.d_parent;
    }

    public void setCurrentPopup(ControlPnlUtil.PopupWindow window) {
        this.d_currentPopup = window;
    }

    private void updatePanels() {
        this.d_actionPnl.setInput(this.d_inputTypePnl.getValue());
        this.d_statementPnl.setData(this.d_actionPnl.getValue(), this.d_inputTypePnl.getValue(), this.d_latchPnl.isLatch());
        this.updateLatch(this.d_inputTypePnl.getValue(), this.d_statementPnl.getDescription().d_srcDetectors.size());
    }

    private void updateLatch(int input, int count) {
        if (input == 1) {
            IOutPin pin;
            this.d_latchPnl.setEnabled(count > 1);
            if (count == 1 && (pin = (IOutPin)this.d_statementPnl.getDescription().d_srcDetectors.iterator().next()).getAttachedSource() instanceof ILatchable) {
                this.d_latchPnl.setLatch(((ILatchable)pin.getAttachedSource()).latches(null));
            }
        }
        this.d_latchPnl.setInput(input);
    }

    @Override
    public ControlBridge preview(ControlBridge previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.savePin(previewObj);
        return previewObj;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.updateAvailOptions();
    }

    public void updateAvailOptions() {
        this.d_inputTypePnl.updateAvailableOptions(this.isEnabled(), this.isDetectorTypeValid(), this.isDeadbandTypeValid());
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(ControlBridge dataObj) {
        this.init(dataObj, null, null);
    }

    public void init(ControlBridge dataObj, Collection<String> sinkNames, ControlDesc.SinkType sinkType) {
        this.setEnabled(dataObj != null);
        if (dataObj != null) {
            this.load(dataObj, sinkNames, sinkType);
        }
        this.setModified(false);
    }

    private void load(ControlBridge dataObj, Collection<String> sinkNames, ControlDesc.SinkType sinkType) {
        if (sinkNames != null) {
            this.d_statementPnl.getDescription().setSinkNames(sinkNames);
        } else if (dataObj.getDomain() != null) {
            DepSnapshot deps = ((PyroMod)dataObj.getDomain()).getDependencies(dataObj);
            Set<Dependency> dependents = deps.getDependents(dataObj);
            this.d_originalSinks = new ArrayList<ISignalSink>(dependents.size());
            for (Dependency dependent : dependents) {
                if (!(dependent.source instanceof IInPin)) continue;
                ISignalSink sink = ((IInPin)dependent.source).getAttachedSink();
                if (this.getCBSinks().containsKey(sink)) {
                    sink = this.getCBSinks().get(sink);
                }
                this.d_originalSinks.add(sink);
            }
            sinkType = ControlDesc.getSinkType(this.d_originalSinks);
            this.d_statementPnl.getDescription().setSinks(this.d_originalSinks);
        }
        this.setSinkType(sinkType);
        this.d_statementPnl.load(dataObj.getInputPin(), dataObj.isForceWrite());
        this.d_actionPnl.setValue(this.d_statementPnl.getDescription().d_action);
        this.d_latchPnl.setLatch(this.d_statementPnl.getDescription().d_latches);
        this.d_inputTypePnl.setValue(this.d_statementPnl.getDescription().d_input);
        this.updatePanels();
    }

    public void setSinkType(ControlDesc.SinkType sinkType) {
        this.d_statementPnl.setSinkType(sinkType);
        this.d_actionPnl.setSinkType(sinkType);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.d_currentPopup != null;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (this.d_currentPopup != null && !this.d_currentPopup.validateData(showWarn, allowModify)) {
            return false;
        }
        int type = this.d_inputTypePnl.getValue();
        if (type == 1 || type == 2) {
            ISignalSource src2;
            Collection<? extends ISignalSink> sinks = Collections.unmodifiableCollection(this.d_statementPnl.getDescription().d_dstObjs);
            List<Object> sources = null;
            if (type == 1) {
                sources = this.d_statementPnl.getDescription().d_srcDetectors.stream().map(IOutPin::getAttachedSource).filter(src -> src instanceof ISignalSink).map(src -> (ISignalSink)((Object)src)).collect(Collectors.toList());
            } else if (type == 2 && this.d_statementPnl.getDescription().d_srcMeasurer != null && (src2 = this.d_statementPnl.getDescription().d_srcMeasurer.getAttachedSource()) instanceof ISignalSink) {
                sources = Arrays.asList((ISignalSink)((Object)src2));
            }
            if (sources == null) {
                sources = Collections.emptyList();
            }
            for (ISignalSink iSignalSink : sinks) {
                for (ISignalSink source : sources) {
                    if (!SignalsUtil.containsCycle(iSignalSink, source)) continue;
                    if (showWarn) {
                        guiDialog.showInvalidEntryMessage(this, Intl.intl("Controls cannot create cyclic definitions."));
                    }
                    return false;
                }
            }
        }
        return super.validateData(showWarn, allowModify);
    }

    @Override
    public ControlBridge commit(ControlBridge dataObj) {
        boolean reinit = false;
        Set<ISignalSink> modifyObjs = Collections.emptySet();
        if (this.d_statementPnl.getDescription().d_dstObjNames == null) {
            modifyObjs = new LinkedIdentityHashSet<ISignalSink>(this.d_statementPnl.getDescription().d_dstObjs);
            ArrayList<ISignalSink> alreadyAssigned = new ArrayList<ISignalSink>();
            for (ISignalSink sink : modifyObjs) {
                ISignalSource src;
                if (sink.getInputPin().getConnections().isEmpty() || (src = sink.getInputPin().getConnectedSources().iterator().next()) == dataObj) continue;
                alreadyAssigned.add(sink);
            }
            if (!alreadyAssigned.isEmpty()) {
                String msg = String.format(Intl.intl("WARNING: Some of the selected activation objects already have\ndifferent controls assigned to them. Would to like to assign\n\"%s\" to them instead?"), dataObj.getName());
                int selOption = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Reassign Activation Logic"), 1);
                if (selOption != 0 && selOption != 1) {
                    return dataObj;
                }
                if (selOption == 1) {
                    modifyObjs.removeAll(alreadyAssigned);
                    reinit = true;
                }
            }
        }
        Set<ISignalSink> modObjs = modifyObjs;
        PyroMod domain = PyroSim.getApp().getMediator();
        CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(domain);
        ControlBridge tmp = dataObj.getRestoreObject();
        this.savePin(tmp);
        compTask.addTask(dataObj.taskImprint(tmp));
        HashMap<ISignalSink, ISignalSource> preOutState = new HashMap<ISignalSink, ISignalSource>();
        for (ISignalSink sink : this.d_originalSinks) {
            preOutState.put(sink, sink.getInputPin().getConnectedSources().iterator().next());
        }
        for (ISignalSink sink : modObjs) {
            if (!sink.getInputPin().getConnectedSources().isEmpty()) {
                preOutState.put(sink, sink.getInputPin().getConnectedSources().iterator().next());
                continue;
            }
            preOutState.put(sink, null);
        }
        HashMap<ISignalSink, ISignalSource> postOutState = new HashMap<ISignalSink, ISignalSource>();
        for (ISignalSink sink : preOutState.keySet()) {
            if (modObjs.contains(sink)) {
                postOutState.put(sink, dataObj);
                continue;
            }
            postOutState.put(sink, null);
        }
        compTask.addTask(new SignalsUtil.UpdateActivationPinsTask(preOutState, postOutState));
        domain.getTaskManager().exec(compTask, "Edit Activation Control");
        this.setModified(false);
        if (reinit) {
            this.init(dataObj);
        }
        return dataObj;
    }

    private void savePin(ControlBridge dataObj) {
        IOutPin srcPin = this.d_statementPnl.save();
        dataObj.getInputPin().disconnectAll();
        if (srcPin != null) {
            dataObj.getInputPin().connect(srcPin);
            if (srcPin.getAttachedSource() instanceof IControl && !(srcPin.getAttachedSource() instanceof ControlBridge)) {
                ((IControl)srcPin.getAttachedSource()).setName(dataObj.getName());
            }
        }
        dataObj.setForceWrite(this.d_statementPnl.isForceWrite());
        dataObj.changedEvt(new Object[0]);
    }

    public boolean isDetectorTypeValid() {
        return !this.d_parent.getLogicPins().isEmpty();
    }

    public boolean isDeadbandTypeValid() {
        return this.d_parent.getDblSrcPins().size() > 0;
    }

    public void invalidateControlsAsSinksList() {
        this.d_controlSinks = null;
    }

    public Map<AControl, Util.ControlBridgeAsSinkHelper> getCBSinks() {
        if (this.d_controlSinks != null) {
            return this.d_controlSinks;
        }
        this.d_controlSinks = Util.getValidControlsAsSinks(PyroSim.getApp().getMediator());
        return this.d_controlSinks;
    }

    private static class ActionPnl
    extends guiPanel {
        private static final long serialVersionUID = -3606489502740766100L;
        private final guiRadioButton d_createBtn = new guiRadioButton();
        private final guiRadioButton d_removeBtn = new guiRadioButton();

        public ActionPnl() {
            super(new GridBagLayout());
            TitleSeparator ts = new TitleSeparator(Intl.intl("Action to Perform"));
            new guiButtonGroup(this.d_createBtn, this.d_removeBtn);
            int row = 0;
            GridBagUtil.add(this, ts, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_createBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_removeBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void setInput(int input) {
            this.setVisible(input != 3 && input != 2 && input != 4);
            if (this.isVisible()) {
                this.d_createBtn.setVisible(input == 0 || input == 1);
                this.d_removeBtn.setVisible(this.d_createBtn.isVisible());
            }
        }

        public void addListener(ActionListener list) {
            this.d_createBtn.addActionListener(list);
            this.d_removeBtn.addActionListener(list);
        }

        private void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_createBtn.setText(sinkType.strings.activate);
            this.d_removeBtn.setText(sinkType.strings.deactivate);
        }

        public void setValue(int action) {
            switch (action) {
                case 0: {
                    this.d_createBtn.setSelected(true);
                    break;
                }
                case 1: {
                    this.d_removeBtn.setSelected(true);
                }
            }
        }

        public int getValue() {
            if (this.d_createBtn.isSelected()) {
                return 0;
            }
            if (this.d_removeBtn.isSelected()) {
                return 1;
            }
            return -1;
        }
    }

    private static class LatchPnl
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final guiCheckBox d_latchCb = new guiCheckBox(Intl.intl("Trigger only once"));

        public LatchPnl() {
            super(new GridBagLayout());
            TitleSeparator ts = new TitleSeparator(Intl.intl("Signal Rule"));
            int row = 0;
            GridBagUtil.add(this, ts, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_latchCb, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void setInput(int input) {
            this.setVisible(input == 1);
        }

        public void setLatch(boolean shouldLatch) {
            this.d_latchCb.setSelected(shouldLatch);
        }

        public boolean isLatch() {
            return this.d_latchCb.isSelected();
        }

        public void addListener(ActionListener list) {
            this.d_latchCb.addActionListener(list);
        }
    }

    private static class InputPnl
    extends guiPanel {
        private static final long serialVersionUID = -6224895310993658138L;
        private final guiRadioButton d_timeBtn = new guiRadioButton(Intl.intl("Time"));
        private final guiRadioButton d_detectorBtn = new guiRadioButton(Intl.intl("Detector"));
        private final guiRadioButton d_deadbandBtn = new guiRadioButton(Intl.intl("Deadband Control (e.g. Thermostat)"));
        private final guiRadioButton d_customBtn = new guiRadioButton(Intl.intl("Manual"));

        public InputPnl() {
            super(new GridBagLayout());
            TitleSeparator ts = new TitleSeparator(Intl.intl("Input Type"));
            new guiButtonGroup(this.d_timeBtn, this.d_detectorBtn, this.d_deadbandBtn, this.d_customBtn);
            this.d_timeBtn.setSelected(true);
            int row = 0;
            GridBagUtil.add(this, ts, 0, ++row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_timeBtn, 0, ++row, 2, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_detectorBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_deadbandBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_customBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void addListener(ActionListener list) {
            this.d_timeBtn.addActionListener(list);
            this.d_detectorBtn.addActionListener(list);
            this.d_deadbandBtn.addActionListener(list);
            this.d_customBtn.addActionListener(list);
        }

        public void setValue(int value) {
            this.setVisible(true);
            switch (value) {
                case 4: {
                    this.setVisible(false);
                    break;
                }
                case 0: {
                    this.d_timeBtn.setSelected(true);
                    break;
                }
                case 1: {
                    this.d_detectorBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.d_deadbandBtn.setSelected(true);
                    break;
                }
                default: {
                    this.d_customBtn.setSelected(true);
                }
            }
        }

        public int getValue() {
            if (!this.isVisible()) {
                return 4;
            }
            if (this.d_timeBtn.isSelected()) {
                return 0;
            }
            if (this.d_detectorBtn.isSelected()) {
                return 1;
            }
            if (this.d_deadbandBtn.isSelected()) {
                return 2;
            }
            return 3;
        }

        public void updateAvailableOptions(boolean inputEnabled, boolean enableDetector, boolean enableDB) {
            this.d_detectorBtn.setEnabled(enableDetector && inputEnabled);
            this.d_deadbandBtn.setEnabled(enableDB && inputEnabled);
            this.d_detectorBtn.setToolTipText(null);
            this.d_deadbandBtn.setToolTipText(null);
            if (inputEnabled && !enableDetector) {
                this.d_detectorBtn.setToolTipText(Intl.intl("No detectors or triggering devices are currently in the model."));
            }
            if (inputEnabled && !enableDB) {
                this.d_deadbandBtn.setToolTipText(Intl.intl("No device input for a deadband is currently in model."));
            }
        }
    }
}

