/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.Util;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnlUtil;
import pyrosim.gui.controls.LogicControlPnl;
import pyrosim.gui.controls.MathematicControlEditorPnl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiPanel;

public class ControlPnl
extends guiPanel
implements IEditor<ControlBridge> {
    private static final long serialVersionUID = -6642987861153912507L;
    private final PyroMod d_pyMod;
    private final LogicControlPnl d_logicControlEditor;
    private final MathematicControlEditorPnl d_mathControlEditor;
    private List<IDoubleOutPin> d_msrPins = null;
    private Set<ILogicOutPin> d_logicPins = null;

    public ControlPnl(PyroMod pyMod) {
        super(new GridBagLayout());
        this.d_pyMod = pyMod;
        this.d_logicControlEditor = new LogicControlPnl(this);
        this.d_mathControlEditor = new MathematicControlEditorPnl(pyMod, this);
        this.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_logicControlEditor, this.d_mathControlEditor));
        this.setMinimumSize(this.getPreferredSize());
        GridBagUtil.add(this, this.d_logicControlEditor, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        GridBagUtil.add(this, this.d_mathControlEditor, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
    }

    @Override
    public void init(ControlBridge dataObj) {
        ISignalSource source;
        Set<ISignalSource> sources;
        boolean displayLogic = true;
        if (dataObj != null && (sources = dataObj.getInputPin().getConnectedSources()).size() > 0 && (source = sources.iterator().next()) instanceof AMathOp) {
            displayLogic = false;
        }
        this.d_logicControlEditor.setVisible(displayLogic);
        this.d_mathControlEditor.setVisible(!displayLogic);
        if (displayLogic) {
            this.d_logicControlEditor.init(dataObj);
        } else {
            this.d_mathControlEditor.init(dataObj);
        }
        this.setModified(false);
    }

    public void initLogic(ControlBridge dataObj, Collection<String> sinkNames, ControlDesc.SinkType sinkType) {
        this.d_logicControlEditor.init(dataObj, sinkNames, sinkType);
    }

    @Override
    public ControlBridge preview(ControlBridge previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        if (this.d_mathControlEditor.isVisible()) {
            return this.d_mathControlEditor.preview(previewObj);
        }
        return this.d_logicControlEditor.preview(previewObj);
    }

    @Override
    public ControlBridge commit(ControlBridge dataObj) {
        if (this.d_mathControlEditor.isVisible()) {
            this.d_mathControlEditor.commit(dataObj);
        } else {
            this.d_logicControlEditor.commit(dataObj);
        }
        this.invalidateSourceCaches();
        this.d_logicControlEditor.updateAvailOptions();
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    public void setCurrentPopup(ControlPnlUtil.PopupWindow window) {
        this.d_logicControlEditor.setCurrentPopup(window);
    }

    public List<IDoubleOutPin> getDblSrcPins() {
        if (this.d_msrPins != null) {
            return this.d_msrPins;
        }
        this.beginWaitCursor();
        this.d_msrPins = Util.getDblSrcPins(this.d_pyMod);
        this.endWaitCursor();
        return this.d_msrPins;
    }

    public Set<ILogicOutPin> getLogicPins() {
        if (this.d_logicPins != null) {
            return this.d_logicPins;
        }
        this.beginWaitCursor();
        this.d_logicPins = Util.getLogicPins(this.d_pyMod);
        this.endWaitCursor();
        return this.d_logicPins;
    }

    public void invalidateSourceCaches() {
        this.d_logicPins = null;
        this.d_msrPins = null;
        this.d_logicControlEditor.invalidateControlsAsSinksList();
    }

    public boolean isSourceCacheValid() {
        return this.d_msrPins != null;
    }
}

