/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LogicOps.ADblCompareOp;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.ALogicOp;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntEqualOp;
import pyrosim.domain.controls.LogicOps.IntGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntLessThanOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.MathOps.CountOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.controls.Util;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IIntegerOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.gui.controls.ICtrlDescStringFormatter;
import thunderheadeng.gui.Utils;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class ControlDesc {
    public static final int ACTION_ACTIVATE = 0;
    public static final int ACTION_DEACTIVATE = 1;
    public static final int INPUT_TIME = 0;
    public static final int INPUT_DEVICE = 1;
    public static final int INPUT_DEADBAND = 2;
    public static final int INPUT_MANUAL = 3;
    public static final int INPUT_CUSTOM = 4;
    public static final int LOGIC_OR = 0;
    public static final int LOGIC_AND = 1;
    public static final int LOGIC_GE = 2;
    public static final int LOGIC_LE = 3;
    public static final int LOGIC_EQ = 4;
    public static final String TBEGIN = Intl.intl("TBEGIN");
    public static final String HREF_SINKS = "SINKS";
    public static final String HREF_LOGIC = "LOGIC";
    public static final String HREF_DETSOURCES = "DETSOURCES";
    public static final String HREF_ACTIVATE = "ACTIVATE";
    public static final String HREF_N = "N";
    public static final String HREF_T = "T";
    public static final String HREF_DBLOWERV = "DBLOWERV";
    public static final String HREF_DBUPPERV = "DBUPPERV";
    public static final String HREF_DBLOWERL = "DBLOWERL";
    public static final String HREF_DBUPPERL = "DBUPPERL";
    public static final String HREF_MSRSOURCE = "MSRSOURCES";
    public static final String HREF_DELAY = "DELAY";
    public static final String HREF_CUSTOMINPUT = "CUSTOMINPUT";
    private final boolean d_editable;
    private final boolean d_displaySinks;
    public int d_action;
    public int d_input;
    public boolean d_latches;
    public Collection<String> d_dstObjNames = null;
    public Collection<? extends ISignalSink> d_dstObjs = Collections.emptyList();
    public List<? extends ILogicOutPin> d_srcDetectors = Collections.emptyList();
    public int d_logicType = 0;
    public int d_n = 1;
    public boolean d_sourceActivates = true;
    public UnitDouble d_delay = new UnitDouble(0.0, SI.SECOND);
    public UnitDouble d_t = null;
    public IDoubleOutPin d_srcMeasurer = null;
    public boolean d_dbUpper = true;
    public UnitDouble[] d_dbRange = new UnitDouble[]{new UnitDouble(23.0, SI.CELSIUS), new UnitDouble(27.0, SI.CELSIUS)};
    public int d_dbRangeType = 1;
    public String d_customCtrlName = null;

    public ControlDesc(boolean editable, boolean displaySinks) {
        this.d_editable = editable;
        this.d_displaySinks = displaySinks;
    }

    private void changed() {
    }

    public static String getName(Object obj) {
        if (obj instanceof IOutPin) {
            return ControlDesc.getName((IOutPin)obj);
        }
        if (obj instanceof Util.ControlBridgeAsSinkHelper) {
            return ((Util.ControlBridgeAsSinkHelper)obj).end.getName();
        }
        if (obj instanceof INamed) {
            return ((INamed)obj).getName();
        }
        return obj.toString();
    }

    public static String getName(IOutPin pin) {
        if (pin.getAttachedSource() == null || !(pin.getAttachedSource() instanceof INamed)) {
            return pin.getName();
        }
        ISignalSource src = pin.getAttachedSource();
        String baseName = ((INamed)((Object)src)).getName();
        int alike = ControlDesc.countAlikePins(src, pin);
        if (alike <= 1) {
            return baseName;
        }
        return baseName + "->" + pin.getName();
    }

    private static int countAlikePins(ISignalSource src, IOutPin pin) {
        int alikePins = 0;
        Class testClazz = pin instanceof ILogicOutPin ? ILogicOutPin.class : (pin instanceof IIntegerOutPin ? IIntegerOutPin.class : IDoubleOutPin.class);
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!testClazz.isInstance(iOutPin)) continue;
            ++alikePins;
        }
        return alikePins;
    }

    public void setData(int action, int input, boolean latch) {
        this.d_action = action;
        this.d_input = input;
        this.d_latches = latch;
    }

    public void setCustomCtrlName(String name) {
        this.d_customCtrlName = name;
        this.changed();
    }

    public void setDelay(UnitDouble val) {
        this.d_delay = val;
        this.changed();
    }

    public void setDBBound(UnitDouble val, boolean lower) {
        if (lower) {
            this.d_dbRange[0] = val;
        } else {
            this.d_dbRange[1] = val;
        }
        this.changed();
    }

    public void setDBLogic(boolean activate, boolean lower) {
        this.d_dbUpper = lower ? !activate : activate;
        this.changed();
    }

    public void setLogicType(int val) {
        this.d_logicType = val;
        this.changed();
    }

    public void setN(int val) {
        this.d_n = val;
        this.changed();
    }

    public void setT(UnitDouble val) {
        this.d_t = val;
        this.changed();
    }

    public void setSourceMeasurer(IDoubleOutPin measurerPin) {
        this.d_srcMeasurer = measurerPin;
        if (measurerPin != null) {
            this.d_dbRangeType = measurerPin.getUnitType();
            Unit unit = PyroSim.getApp().getUnitSystem().getUnit(this.d_dbRangeType);
            this.d_dbRange[0] = this.d_dbRange[0].reinterpret(unit);
            this.d_dbRange[1] = this.d_dbRange[1].reinterpret(unit);
        }
        this.changed();
    }

    public void setSourceActivates(boolean activates) {
        this.d_sourceActivates = activates;
        this.changed();
    }

    public void setSources(List<? extends ILogicOutPin> sources) {
        this.d_srcDetectors = sources;
        this.changed();
    }

    public void setSinks(Collection<? extends ISignalSink> sinks) {
        this.d_dstObjNames = null;
        this.d_dstObjs = sinks;
        this.changed();
    }

    public void setSinkNames(Collection<String> names) {
        this.d_dstObjNames = names;
        this.d_dstObjs = Collections.emptyList();
        this.changed();
    }

    public boolean isLatch() {
        return this.d_latches;
    }

    private <T> String getListStr(Collection<? extends T> objs) {
        if (objs.isEmpty()) {
            return Intl.intl("&lt;nothing&gt;");
        }
        Object str = "&lt;";
        int maxNumObjs = 2;
        int m = 0;
        int maxM = Math.min(2, objs.size());
        for (T obj : objs) {
            if (m != 0) {
                str = (String)str + ", ";
            }
            str = (String)str + ControlDesc.getName(obj);
            if (++m < maxM) continue;
            break;
        }
        if (objs.size() > 2) {
            str = (String)str + ", ...";
        }
        str = (String)str + "&gt;";
        return str;
    }

    private String getCustomInputStr() {
        if (this.d_customCtrlName == null) {
            return Intl.intl("&lt;nothing&gt;");
        }
        return this.d_customCtrlName;
    }

    private String getSinksStr() {
        if (!this.d_displaySinks) {
            return null;
        }
        Collection<Object> objs = this.d_dstObjNames != null ? this.d_dstObjNames : this.d_dstObjs;
        return this.getListStr(objs);
    }

    private String getInputDetectorsStr() {
        return this.getListStr(this.d_srcDetectors);
    }

    private String getInputMeasurerStr() {
        if (this.d_srcMeasurer == null) {
            return Intl.intl("&lt;nothing&gt;");
        }
        return ControlDesc.getName(this.d_srcMeasurer);
    }

    private String format(String htmlMsg, Object ... args) {
        String ix;
        StringBuffer buf = new StringBuffer(htmlMsg.length());
        Pattern pattern = Pattern.compile("\\<\\%([0-9]+)\\>");
        Matcher matcher = pattern.matcher(htmlMsg);
        while (matcher.find()) {
            ix = matcher.group(1);
            int i = Integer.parseInt(ix);
            if (this.d_editable) {
                matcher.appendReplacement(buf, "<a href=\"%" + i + "\\$s\">%" + (i + 1) + "\\$s</a>");
                continue;
            }
            matcher.appendReplacement(buf, "%" + (i + 1) + "\\$s");
        }
        matcher.appendTail(buf);
        htmlMsg = buf.toString();
        buf.setLength(0);
        pattern = Pattern.compile("\\<\\%([0-9]+)([^\\>.]+)\\>");
        matcher = pattern.matcher(htmlMsg);
        while (matcher.find()) {
            ix = matcher.group(1);
            String str = matcher.group(2);
            int i = Integer.parseInt(ix);
            if (this.d_editable) {
                matcher.appendReplacement(buf, "<a href=\"%" + i + "\\$s\">" + str + "</a>");
                continue;
            }
            matcher.appendReplacement(buf, str);
        }
        matcher.appendTail(buf);
        htmlMsg = buf.toString();
        return String.format(htmlMsg, args);
    }

    public String formatMessage(SinkType sinkType) {
        ICtrlDescStringFormatter.Strings strings = sinkType.strings;
        Object str = "";
        if (this.d_input != 3) {
            if (this.d_input == 1) {
                String sinksStr = this.getSinksStr();
                String inputStr = this.getInputDetectorsStr();
                if (this.d_srcDetectors.size() <= 1) {
                    if (this.d_action == 0 && this.d_sourceActivates) {
                        str = strings.formatActivateWhenActivate(this.d_editable, sinksStr, inputStr);
                    } else if (this.d_action == 0 && !this.d_sourceActivates) {
                        str = strings.formatActivateWhenDeactivate(this.d_editable, sinksStr, inputStr);
                    } else if (this.d_action == 1 && this.d_sourceActivates) {
                        str = strings.formatDeactivateWhenActivate(this.d_editable, sinksStr, inputStr);
                    } else if (this.d_action == 1 && !this.d_sourceActivates) {
                        str = strings.formatDeactivateWhenDeactivate(this.d_editable, sinksStr, inputStr);
                    }
                } else if (this.d_action == 0 && this.d_logicType == 0 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenAnyActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 0 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenAnyDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 1 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenAllActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 1 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenAllDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 3 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenNoMoreThanActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 3 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenNoMoreThanDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 2 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenAtLeastActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 2 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenAtLeastDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 4 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenExactlyActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 4 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenExactlyDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 0 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAnyActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 0 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAnyDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 1 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAllActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 1 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAllDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 3 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenNoMoreThanActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 3 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenNoMoreThanDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 2 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAtLeastActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 2 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAtLeastDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 4 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenExactlyActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 4 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenExactlyDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                }
                if (this.d_editable || this.d_delay.getValueNoUnit() > 0.0) {
                    Object str2 = "<br>";
                    if (this.d_action == 1) {
                        str2 = (String)str2 + strings.formatDelayDeactivation(this.d_editable, this.d_delay);
                    } else if (this.d_action == 0) {
                        str2 = (String)str2 + strings.formatDelayActivation(this.d_editable, this.d_delay);
                    }
                    str = (String)str + (String)str2;
                }
            } else if (this.d_input == 0) {
                String sinksStr = this.getSinksStr();
                if (this.d_action == 0) {
                    str = strings.formatActivateAtTime(this.d_editable, sinksStr, this.d_t);
                } else if (this.d_action == 1) {
                    str = strings.formatDeactivateAtTime(this.d_editable, sinksStr, this.d_t);
                }
            } else if (this.d_input == 4) {
                String sinksStr = this.getSinksStr();
                str = this.d_editable ? strings.formatControlOnSequence(this.d_editable, sinksStr) : strings.formatControlOnTimedEvents(this.d_editable, sinksStr);
            } else if (this.d_input == 2) {
                String sinksStr = this.getSinksStr();
                String srcStr = this.getInputMeasurerStr();
                str = this.d_dbUpper ? strings.formatTurnOffWhenBelowOnWhenAbove(this.d_editable, sinksStr, srcStr, this.d_dbRange[0], this.d_dbRange[1]) : strings.formatTurnOnWhenBelowOffWhenAbove(this.d_editable, sinksStr, srcStr, this.d_dbRange[0], this.d_dbRange[1]);
            }
        } else if (this.d_editable) {
            String sinksStr = this.getSinksStr();
            String srcStr = this.getCustomInputStr();
            str = this.d_dstObjNames != null && this.d_dstObjNames.size() <= 1 || this.d_dstObjs.size() <= 1 ? strings.formatExistsWhenTrue(this.d_editable, sinksStr, srcStr) : strings.formatExistWhenTrue(this.d_editable, sinksStr, srcStr);
        } else {
            str = strings.formatCustomActivation();
        }
        return str;
    }

    private String formatT() {
        return this.d_t == null ? TBEGIN : Global.format(this.d_t);
    }

    public boolean validateData(Component parent, SinkType sinkType, boolean showWarn, boolean modify) {
        parent = Utils.findParentWindow(parent);
        if (this.d_input == 0) {
            if (this.d_action == 1 && this.d_t == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, String.format(Intl.intl("%1$s may only be entered if the action type is %2$s."), TBEGIN, sinkType.strings.activate), Intl.intl("Invalid Entry"), 0);
                }
                return false;
            }
        } else if (this.d_input == 1) {
            if (this.d_srcDetectors.isEmpty()) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("You must select at least one source detector."), Intl.intl("No Source Detectors Selected"), 0);
                }
                return false;
            }
            if (this.d_srcDetectors.size() >= 40) {
                JOptionPane.showMessageDialog(parent, Intl.intl("FDS allows a maximum of 40 inputs into a &CTRL record."), Intl.intl("Maximum Detector Count Surpassed"), 0);
            }
        } else if (this.d_input == 2) {
            if (this.d_srcMeasurer == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("You must select a source device."), Intl.intl("No Source Device Selected"), 0);
                }
                return false;
            }
            if (this.d_dbRange[0].compareTo(this.d_dbRange[1]) >= 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("The lower bound of the deadband must be less than the upper bound."), Intl.intl("Invalid Deadband Range"), 0);
                }
                return false;
            }
        }
        return true;
    }

    private boolean isTBeginCase() {
        return this.d_action == 0 && this.d_input == 0 && this.d_t == null;
    }

    private boolean isLogicOpCase() {
        return this.d_srcDetectors.size() > 1 && (this.d_logicType == 1 || this.d_logicType == 0);
    }

    private boolean isNumSignalCompareCase() {
        return this.d_srcDetectors.size() > 1 && (this.d_logicType == 4 || this.d_logicType == 2 || this.d_logicType == 3);
    }

    public IOutPin save() {
        if (this.isTBeginCase()) {
            return null;
        }
        SignalBuilder signalBuilder = new SignalBuilder();
        if (this.d_input == 0) {
            signalBuilder.startTimer(this.d_t, this.d_action);
        } else if (this.d_input == 1) {
            if (this.d_action == 0 || this.d_action == 1) {
                boolean invert = !this.d_sourceActivates;
                boolean latch = this.d_latches;
                if (this.isLogicOpCase()) {
                    signalBuilder.startLogicOp(this.d_logicType, invert, latch, this.d_srcDetectors);
                } else if (this.isNumSignalCompareCase()) {
                    signalBuilder.startCountCompareOp(this.d_logicType, this.d_n, invert, latch, this.d_srcDetectors);
                } else if (this.d_srcDetectors.size() == 1) {
                    signalBuilder.startSingleDetector(this.d_srcDetectors.get(0), invert);
                }
                if (signalBuilder.isStarted()) {
                    if (this.d_delay.getValueNoUnit() > 0.0) {
                        signalBuilder.addDelay(this.d_delay);
                    }
                    if (this.d_action == 1) {
                        signalBuilder.addDeactivate();
                    }
                }
            }
        } else if (this.d_input == 2 && this.d_srcMeasurer != null) {
            signalBuilder.startDeadband(this.d_dbUpper ? 1 : 0, this.d_dbRange, this.d_srcMeasurer);
        }
        return signalBuilder.getSrcPin();
    }

    private void cleanupBeforeLoad() {
        this.setSources(Collections.emptyList());
        this.setDelay(new UnitDouble(0.0, SI.SECOND));
        this.setT(null);
    }

    public void load(IInPin inPin) {
        this.cleanupBeforeLoad();
        if (inPin.getConnections().isEmpty()) {
            this.d_action = 0;
            this.d_input = 0;
            this.setT(null);
            return;
        }
        boolean manual = true;
        Util.DupAccumulation accum = Util.accumulateDuplicates(inPin.getConnections());
        if (accum.isOldBoring()) {
            if (accum.d_nextInputs.size() == 1) {
                ISignalSource src = accum.d_nextInputs.iterator().next().getAttachedSource();
                if (src instanceof ADblCompareOp) {
                    this.loadDblCompareOp((ADblCompareOp)src);
                    manual = false;
                } else if (src instanceof Timer) {
                    this.loadTimer((Timer)src);
                    manual = false;
                } else if (src instanceof CustomCtrl) {
                    this.d_input = 4;
                    manual = false;
                } else if (src instanceof DeadbandCtrl) {
                    DeadbandCtrl deadbandCtrl = (DeadbandCtrl)src;
                    if (deadbandCtrl.getInputPin().getConnections().size() == 1) {
                        this.loadDeadband(deadbandCtrl);
                        manual = false;
                    }
                } else if (src instanceof IDevice && src instanceof ISignalSource && !(src instanceof Timer) || src instanceof ControlBridge) {
                    IOutPin out = accum.d_nextInputs.iterator().next();
                    if (out instanceof ILogicOutPin) {
                        ILogicOutPin opin = (ILogicOutPin)out;
                        this.d_action = 0;
                        this.d_input = 1;
                        this.d_latches = opin.latches();
                        this.setSources(Collections.singletonList(opin));
                        manual = false;
                    }
                } else if (src instanceof ALogicOp || src instanceof AIntCompareOp) {
                    boolean bl = manual = !this.tryLoadMultiDeviceIn(new SignalModifierInterpreter(accum));
                    if (!manual) {
                        this.d_action = 0;
                        this.d_input = 1;
                    }
                }
            }
        } else {
            this.d_input = 1;
            SignalModifierInterpreter dupHandler = new SignalModifierInterpreter(accum);
            this.d_action = dupHandler.interpInverts();
            this.setDelay(dupHandler.interpDelay());
            if (dupHandler.isTrueInversion()) {
                if (dupHandler.isSingleNextInput() && dupHandler.isValidSingleDevice()) {
                    this.setSourceActivates(false);
                    this.setSources(Arrays.asList((ILogicOutPin)accum.d_nextInputs.iterator().next()));
                    manual = false;
                }
            } else if (dupHandler.isAtLeastOneNextInput()) {
                if (dupHandler.getNextSource() instanceof ControlBridge) {
                    this.setSourceActivates(true);
                    this.setSources(Arrays.asList((ILogicOutPin)dupHandler.getNextInputs().iterator().next()));
                    this.d_latches = ((ControlBridge)dupHandler.getNextSource()).latches(null);
                    manual = false;
                } else if (dupHandler.isValidSingleDevice()) {
                    ILogicOutPin detectorLogic = (ILogicOutPin)dupHandler.getNextInputs().iterator().next();
                    this.setSourceActivates(true);
                    this.setSources(Arrays.asList(detectorLogic));
                    this.d_latches = detectorLogic.latches();
                    manual = false;
                } else if (dupHandler.isMultiInputOp()) {
                    boolean bl = manual = !this.tryLoadMultiDeviceIn(dupHandler);
                }
            }
        }
        if (manual) {
            this.d_input = 3;
        }
    }

    public static SinkType getSinkType(Collection<?> objs) {
        return !objs.isEmpty() && objs.stream().allMatch(s -> s instanceof IFreezable) ? SinkType.FREEZE : SinkType.ACTIVATE;
    }

    private void loadDblCompareOp(ADblCompareOp dblCompOp) {
        ISignalSource cmpIn;
        if (dblCompOp.getInputPin().getConnectedSources().size() == 1 && (cmpIn = dblCompOp.getInputPin().getConnectedSources().iterator().next()) instanceof Clock) {
            int action;
            this.d_action = action = dblCompOp instanceof DblGreaterThanOp ? 0 : 1;
            this.d_input = 0;
            this.setT(dblCompOp.getN());
        }
    }

    private void loadTimer(Timer timer) {
        int action = TripFlags.initiallyOn(timer.getAlarmInfo().tripFlags) ? 1 : 0;
        UnitDouble t = timer.getAlarmInfo().setpoint;
        this.d_action = action;
        this.d_input = 0;
        this.setT(t);
    }

    private void loadDeadband(DeadbandCtrl deadbandCtrl) {
        IOutPin dbsrc = deadbandCtrl.getInputPin().getConnections().iterator().next();
        this.d_input = 2;
        this.setDBBound(deadbandCtrl.getLowerBound(), true);
        this.setDBBound(deadbandCtrl.getUpperBound(), false);
        if (deadbandCtrl.getTripDirection() == 0) {
            this.setDBLogic(true, true);
        } else if (deadbandCtrl.getTripDirection() == 1) {
            this.setDBLogic(true, false);
        }
        this.setSourceMeasurer((IDoubleOutPin)dbsrc);
    }

    private boolean tryLoadMultiDeviceIn(SignalModifierInterpreter interpreter) {
        Collection<? extends IOutPin> logicInputs = interpreter.getInputsForMulti();
        if (logicInputs.size() > 0) {
            boolean bl;
            ArrayList<ILogicOutPin> inputs = new ArrayList<ILogicOutPin>();
            int invalidCount = 0;
            int invertCount = 0;
            for (IOutPin iOutPin : logicInputs) {
                SignalModifierInterpreter deepDupHandler = new SignalModifierInterpreter(Util.accumulateDuplicates(Collections.singletonList(iOutPin)));
                invertCount += deepDupHandler.countValidInversion();
                invalidCount += deepDupHandler.countNonBoringNonInvert();
                if (deepDupHandler.isAtLeastOneNextInput() && deepDupHandler.nextInputIsDetector()) {
                    inputs.add((ILogicOutPin)deepDupHandler.getNextInputs().iterator().next());
                    continue;
                }
                ++invalidCount;
            }
            boolean validIncomingTypes = invalidCount == 0;
            boolean bl2 = bl = invertCount == 0 || invertCount == logicInputs.size();
            if (validIncomingTypes && bl) {
                this.setSourceActivates(invertCount == 0);
                this.setSources(inputs);
                int logicType = -1;
                int n = -1;
                ISignalSource src = interpreter.getNextSource();
                if (src instanceof ILatchable) {
                    this.d_latches = ((ILatchable)src).latches(null);
                }
                if (src instanceof AndOp) {
                    logicType = 1;
                } else if (src instanceof OrOp) {
                    logicType = 0;
                } else if (src instanceof IntGreaterThanOp) {
                    logicType = 2;
                    n = ((AIntCompareOp)src).getN() + 1;
                } else if (src instanceof IntLessThanOp) {
                    logicType = 3;
                    n = ((AIntCompareOp)src).getN() - 1;
                } else if (src instanceof IntEqualOp) {
                    logicType = 4;
                    n = ((AIntCompareOp)src).getN();
                }
                if (logicType != -1) {
                    this.setLogicType(logicType);
                    if (n != -1) {
                        this.setN(n);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static enum SinkType {
        ACTIVATE(new ICtrlDescStringFormatter.ActivateStrings()),
        FREEZE(new ICtrlDescStringFormatter.FreezeStrings());

        public final ICtrlDescStringFormatter.Strings strings;

        private SinkType(ICtrlDescStringFormatter.Strings strings) {
            this.strings = strings;
        }
    }

    public static class SignalBuilder {
        private IOutPin srcPin = null;

        public boolean isStarted() {
            return this.srcPin != null;
        }

        public IOutPin getSrcPin() {
            return this.srcPin;
        }

        public IOutPin startTimer(UnitDouble dt, int action) {
            Timer timer = new Timer(dt, action == 1);
            this.srcPin = timer.getOutputPins().get(0);
            return this.srcPin;
        }

        public IOutPin startLogicOp(int logicType, boolean invert, boolean latch, Collection<? extends ILogicOutPin> detectors) {
            ALogicOp logicOp = logicType == 1 ? new AndOp() : new OrOp();
            logicOp.setLatch(latch);
            for (IOutPin iOutPin : detectors) {
                if (invert) {
                    NotOp not = new NotOp();
                    not.getInputPin().connect(iOutPin);
                    logicOp.getInputPin().connect(not.getOutputPins().get(0));
                    continue;
                }
                logicOp.getInputPin().connect(iOutPin);
            }
            this.srcPin = logicOp.getOutputPins().get(0);
            return this.srcPin;
        }

        public IOutPin startCountCompareOp(int logicType, int count, boolean invert, boolean latch, Collection<? extends ILogicOutPin> detectors) {
            AIntCompareOp intCompOp = null;
            if (logicType == 2) {
                intCompOp = new IntGreaterThanOp(count - 1);
            } else if (logicType == 3) {
                intCompOp = new IntLessThanOp(count - 1);
            } else if (logicType == 4) {
                intCompOp = new IntEqualOp(count);
            }
            if (intCompOp == null) {
                assert (false);
                return null;
            }
            intCompOp.setLatch(latch);
            CountOp signalCountOp = new CountOp();
            for (IOutPin iOutPin : detectors) {
                if (invert) {
                    NotOp not = new NotOp();
                    not.getInputPin().connect(iOutPin);
                    signalCountOp.getInputPin().connect(not.getOutputPins().get(0));
                    continue;
                }
                signalCountOp.getInputPin().connect(iOutPin);
            }
            intCompOp.getInputPin().connect(signalCountOp.getOutputPins().get(0));
            this.srcPin = intCompOp.getOutputPins().get(0);
            return this.srcPin;
        }

        public IOutPin startSingleDetector(ILogicOutPin detectorPin, boolean invert) {
            this.srcPin = detectorPin;
            if (invert) {
                NotOp not = new NotOp();
                not.getInputPin().connect(this.srcPin);
                this.srcPin = not.getOutputPins().get(0);
            }
            return this.srcPin;
        }

        public IOutPin startDeadband(int tripDir, UnitDouble[] range, IDoubleOutPin measurer) {
            DeadbandCtrl ctrl = new DeadbandCtrl(tripDir, range[0], range[1]);
            ctrl.getInputPin().connect(measurer);
            this.srcPin = ctrl.getOutputPins().get(0);
            return this.srcPin;
        }

        public IOutPin addDelay(UnitDouble delayTime) {
            TimeDelayCtrl delayCtrl = new TimeDelayCtrl(delayTime);
            delayCtrl.getInputPin().connect(this.srcPin);
            this.srcPin = delayCtrl.getOutputPins().get(0);
            return this.srcPin;
        }

        public IOutPin addDeactivate() {
            NotOp not = new NotOp();
            not.getInputPin().connect(this.srcPin);
            this.srcPin = not.getOutputPins().get(0);
            return this.srcPin;
        }
    }

    private static class SignalModifierInterpreter {
        private Util.DupAccumulation accum;

        public SignalModifierInterpreter(Util.DupAccumulation accum) {
            this.accum = accum;
        }

        public int interpInverts() {
            int action = 0;
            if (this.accum.isOldInversion()) {
                if (this.accum.d_invertCount % 2 != 0) {
                    action = 1;
                }
                this.accum = Util.accumulateDuplicates(this.accum.d_nextInputs);
            }
            return action;
        }

        public UnitDouble interpDelay() {
            UnitDouble delay = new UnitDouble(0.0, SI.SECOND);
            if (this.accum.isOldTimeDelay()) {
                delay = this.accum.d_delay;
                this.accum = Util.accumulateDuplicates(this.accum.d_nextInputs);
            }
            return delay;
        }

        public void goDeeper() {
            this.accum = Util.accumulateDuplicates(this.accum.d_nextInputs);
        }

        public boolean isValidSingleDevice() {
            return this.getNextSource() instanceof IDevice && !(this.getNextSource() instanceof Timer);
        }

        public boolean nextInputIsDetector() {
            return this.isValidSingleDevice() || this.getNextSource() instanceof ControlBridge;
        }

        public boolean isMultiInputOp() {
            return this.getNextSource() instanceof ALogicOp || this.getNextSource() instanceof AIntCompareOp;
        }

        public boolean isTrueInversion() {
            return this.accum.isOldInversion() && this.accum.d_invertCount % 2 != 0;
        }

        public boolean isSingleNextInput() {
            return this.accum.d_nextInputs.size() == 1;
        }

        public boolean isAtLeastOneNextInput() {
            return this.accum.d_nextInputs.size() > 0;
        }

        public ISignalSource getNextSource() {
            return this.accum.d_nextInputs.iterator().next().getAttachedSource();
        }

        public Collection<? extends IOutPin> getNextInputs() {
            return this.accum.d_nextInputs;
        }

        public Collection<? extends IOutPin> getInputsForMulti() {
            Set<IOutPin> logicInputs = ((IControl)this.getNextSource()).getInputPin().getConnections();
            if (this.getNextSource() instanceof AIntCompareOp) {
                logicInputs = ((AIntCompareOp)this.getNextSource()).getInputPin().getConnections();
                logicInputs = logicInputs.size() == 1 && ((IOutPin)logicInputs.iterator().next()).getAttachedSource() instanceof CountOp ? ((CountOp)((IOutPin)logicInputs.iterator().next()).getAttachedSource()).getInputPin().getConnections() : Collections.emptySet();
            }
            return logicInputs;
        }

        public int countValidInversion() {
            if (this.isTrueInversion()) {
                return 1;
            }
            return 0;
        }

        public int countNonBoringNonInvert() {
            if (!this.accum.isOldBoring() && !this.accum.isInversion()) {
                return 1;
            }
            return 0;
        }
    }
}

