/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.ANameSorter;
import thunderheadeng.util.theUtil;

public class SurfaceComboBox
extends PyroComboBox<Surface> {
    private static final long serialVersionUID = 7715103452632457968L;

    public SurfaceComboBox(SurfaceManager surfMgr, Surface defaultSurf) {
        this(surfMgr, defaultSurf, false);
    }

    public SurfaceComboBox(SurfaceManager surfMgr, Surface defaultSurf, boolean withSimParamsDefault) {
        super((IPyroObject)surfMgr, defaultSurf, Surface.class);
        if (withSimParamsDefault) {
            this.setFilter(s -> !(s instanceof DefaultSurface));
        }
    }

    @Override
    protected Collection<?> getDefaultList() {
        ANameSorter<Surface> comparator = new ANameSorter<Surface>(){

            @Override
            protected String getName(Surface o) {
                return SurfaceComboBox.this.getObjName(SurfaceComboBox.this.getManager(), o);
            }
        };
        Collection<Surface> coll = Hierarchy.flatten(this.getManager().getMembers(), Surface.class, this.getFilter());
        Collection<Surface> sortedObjs = theUtil.sort(comparator, coll);
        if (!this.isHVAC(sortedObjs)) {
            sortedObjs.add(((SurfaceManager)this.getManager()).getDefaultSurfaceObj());
        }
        return sortedObjs;
    }

    private boolean isHVAC(Collection<Surface> coll) {
        return coll.stream().allMatch(surf -> surf.isPredefined(PredefSurf.HVAC));
    }

    @Override
    protected Collection<?> getObjList() {
        return this.getDefaultList();
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new MaterialCellRenderer();
    }

    private class MaterialCellRenderer
    extends PyroComboBox.UniqueObjCBRenderer {
        private static final long serialVersionUID = 816828011858960319L;
        private Font d_predefFont = new Font("Sans Serif", 0, 11);
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        private MaterialCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Surface surf = (Surface)value;
            if (surf == null) {
                return this;
            }
            if (surf.isPredefined()) {
                this.setFont(this.d_predefFont);
            } else {
                this.setFont(this.d_normalFont);
            }
            TVEntryPoint<Surface> ep = TVEntryPoints.ep(surf);
            if (ep != null && !(surf instanceof DefaultSurface)) {
                Icon[] icons = ep.getIcons(PyroSim.getApp().getMediator(), surf, finishedIcons -> {
                    list.repaint();
                    SurfaceComboBox.this.repaint();
                });
                this.setIcon(icons[0]);
                this.setDisabledIcon(icons[1]);
            }
            this.setEnabled(SurfaceComboBox.this.isEnabled());
            return this;
        }
    }
}

