/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.guiComboBox;

public class CompositeComboBox<T extends IPyroObject>
extends guiComboBox<Composite<T>> {
    private static final long serialVersionUID = 2459551803233136512L;
    private Composite<T> d_root;

    public CompositeComboBox(Composite<T> root) {
        this.setRenderer(new CompositeListRenderer());
        this.d_root = root;
        this.update();
    }

    public void setRoot(Composite<T> root) {
        this.d_root = root;
        this.update();
        this.repaint();
    }

    public void update() {
        Composite sel = (Composite)this.getSelectedItem();
        Collection<Composite> newItems = Hierarchy.flatten(Arrays.asList(this.d_root), Composite.class);
        DefaultComboBoxModel<Composite> newModel = new DefaultComboBoxModel<Composite>(newItems.toArray(new Composite[newItems.size()]));
        this.setModel(newModel);
        if (sel != null) {
            this.setSelectedItem(sel);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        if (prefSize.width < 150) {
            prefSize.width = 150;
        }
        return prefSize;
    }

    public void setSelectedComposite(Composite<T> comp) {
        this.setSelectedItem(comp);
    }

    public Composite<T> getSelectedComposite() {
        return (Composite)this.getSelectedItem();
    }

    private int getDepth(Composite group) {
        int depth = 0;
        for (IPyroObject parent = group; parent != this.d_root && parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    private class CompositeListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4709447998906858843L;
        private static final int OFFSET = 16;

        private CompositeListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Composite) {
                Composite composite = (Composite)value;
                label.setText(composite.getName());
                PyroMod domain = (PyroMod)composite.getDomain();
                Icon[] icons = TVEntryPoints.ep(composite).getIcons(domain, composite, finishedIcons -> {
                    list.repaint();
                    CompositeComboBox.this.repaint();
                });
                label.setIcon(icons[0]);
                label.setDisabledIcon(icons[1]);
                int indent = label.getInsets().left + CompositeComboBox.this.getDepth(composite) * 16;
                label.setBorder(BorderFactory.createEmptyBorder(0, indent, 0, 0));
            }
            return label;
        }
    }
}

