/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;

public class SurfacePanelEditCompDlg
extends guiDialog {
    private static final long serialVersionUID = 6170676201237742926L;
    private guiTableEditor d_editor;
    private guiTable d_table;
    private final Collection<SurfComposition.SurfLayer.SurfComponent> d_surfComp;
    private final MaterialManager d_matMgr;
    private final int d_rowLimit = 20;

    public SurfacePanelEditCompDlg(Collection<SurfComposition.SurfLayer.SurfComponent> surfComp, MaterialManager matMgr) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Composition"), 9);
        this.d_surfComp = surfComp;
        this.d_matMgr = matMgr;
        String[] headers = new String[]{Intl.intl("Mass Fraction"), Intl.intl("Material")};
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        this.d_table = guiTableUtil.fixedColumnTable(headers, new Class[]{Double.class, String.class});
        this.d_table.setRowLimit(20);
        List<Material> mats = Util.sort(this.d_matMgr);
        String[] matNames = new String[mats.size()];
        int i = 0;
        for (Material mat : mats) {
            matNames[i++] = mat.getName();
        }
        this.d_table.setColumnOptions(1, matNames);
        this.d_table.setNullValuesAllowed(false);
        this.d_editor = new guiTableEditor(this.d_table, 30);
        this.d_editor.setPreferredSize(new Dimension(410, 250));
        GridBagUtil.add(dlgPanel, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        this.d_editor.getTable().autoSizeColumns(200);
        this.loadData();
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastRampDlgSizeX.key.toString(), PyroPrefs.LastRampDlgSizeY.key.toString());
    }

    private boolean noDuplicates(TableModel model) {
        int numLines = model.getRowCount();
        for (int i = 0; i < numLines; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!model.getValueAt(i, 1).equals(model.getValueAt(j, 1))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean massFracOne(TableModel model) {
        int numLines = model.getRowCount();
        double sum = 0.0;
        for (int i = 0; i < numLines; ++i) {
            sum += ((Double)model.getValueAt(i, 0)).doubleValue();
        }
        return !(sum < 0.999999) && !(sum > 1.000001);
    }

    private void loadData() {
        if (this.d_surfComp == null) {
            return;
        }
        ResizableTableModel mod = (ResizableTableModel)this.d_table.getModel();
        int i = 0;
        for (SurfComposition.SurfLayer.SurfComponent sc : this.d_surfComp) {
            Object[] row = new Object[]{sc.d_massFraction, sc.d_material.getName()};
            mod.insertRow(i++, row);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        TableModel model = this.d_editor.getTable().getModel();
        if (!this.noDuplicates(model)) {
            String msg = Intl.intl("Error: Duplicate materials are not permitted.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (!this.massFracOne(model)) {
            String msg = Intl.intl("Error: Mass fraction must add up to 1");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    public Collection<SurfComposition.SurfLayer.SurfComponent> getSurfComponent() {
        int numLines = this.d_table.getRowCount();
        ArrayList<SurfComposition.SurfLayer.SurfComponent> col = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(numLines);
        for (int i = 0; i < numLines; ++i) {
            if (this.d_table.getValueAt(i, 0) == null || this.d_table.getValueAt(i, 1) == null) continue;
            double massFrac = (Double)this.d_table.getValueAt(i, 0);
            Material mat = (Material)this.d_matMgr.get((String)this.d_table.getValueAt(i, 1));
            col.add(new SurfComposition.SurfLayer.SurfComponent(massFrac, mat));
        }
        return col;
    }
}

