/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.gui.boundcond.MaterialPanel;
import pyrosim.gui.comboboxes.MaterialComboBox;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class NewMaterialDlg
extends guiDialog {
    private static final long serialVersionUID = 2991484737392308368L;
    private MaterialManager d_matMgr = null;
    private guiTextField d_name = null;
    private guiComboBox<Material> d_baseMat = null;
    private guiComboBox<Material> d_surfType = null;

    public NewMaterialDlg(Window parent, MaterialManager matMgr, Material init) {
        super(parent, Intl.intl("New Material"), 9);
        this.d_matMgr = matMgr;
        this.d_baseMat = new MaterialComboBox(matMgr);
        if (init != null) {
            this.d_baseMat.setSelectedItem(init);
        }
        this.d_surfType = new guiComboBox();
        this.d_baseMat.setEnabled(!this.d_matMgr.flatten().isEmpty());
        this.d_surfType.setRenderer(new typeCBRenderer());
        this.d_surfType.addItem((Material)new Material(MaterialPanel.SOLID, new SolidPyrolysis(), new ThermalProps()));
        this.d_surfType.addItem((Material)new Material(MaterialPanel.LIQUID, new LiquidPyrolysis(), new ThermalProps()));
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(dlgPanel, new guiLabel(Intl.intl("Material Name") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_name, 1, row++, 1, 1, 0, 0, 6, 0);
        if (!this.d_matMgr.flatten().isEmpty()) {
            guiRadioButton typeSurfRB = new guiRadioButton(Intl.intl("Material Type") + ":");
            GridBagUtil.add(dlgPanel, typeSurfRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_surfType, 1, row++, 1, 1, 0, 0, 6, 0);
            guiRadioButton tempSurfRB = new guiRadioButton(Intl.intl("Template Material") + ":");
            GridBagUtil.add(dlgPanel, tempSurfRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_baseMat, 1, row++, 1, 1, 0, 0, 6, 0);
            LinkStatus.link((AbstractButton)typeSurfRB, this.d_surfType);
            LinkStatus.link((AbstractButton)tempSurfRB, this.d_baseMat);
            ButtonGroup group = new ButtonGroup();
            group.add(typeSurfRB);
            group.add(tempSurfRB);
            typeSurfRB.setSelected(true);
        } else {
            guiLabel typeSurfLab = new guiLabel(Intl.intl("Material Type") + ":");
            GridBagUtil.add(dlgPanel, typeSurfLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_surfType, 1, row++, 1, 1, 0, 0, 6, 0);
            this.d_baseMat.setEnabled(false);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        String reqName = this.d_name.getText();
        if (this.nameInUse(reqName)) {
            String msg = Intl.intl("Material name already in use.") + "\n" + Intl.intl("Each material must have a unique name.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String msg = Intl.intl("You must name the material.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public Material getBaseMat() {
        if (this.d_baseMat.isEnabled()) {
            return this.d_baseMat.getSelectedItem();
        }
        if (this.d_surfType.isEnabled()) {
            return this.d_surfType.getSelectedItem();
        }
        return null;
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_matMgr.getDomain()).getNames(Material.class).generateName();
    }

    private boolean nameInUse(String name) {
        return ((PyroMod)this.d_matMgr.getDomain()).getNames(Material.class).isRegistered(name);
    }

    protected class typeCBRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8976321235312427298L;
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        protected typeCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Material surf = (Material)value;
            if (surf == null) {
                return this;
            }
            String name = ((Material)value).getName();
            this.setText(name);
            this.setFont(this.d_normalFont);
            return this;
        }
    }
}

