/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.boundcond.MaterialPanel;
import pyrosim.gui.boundcond.NewMaterialDlg;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class MaterialManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -6174319026326721262L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private MaterialManager d_matMgr;
    private JFrame d_owner;

    public MaterialManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Materials"), true);
        this.d_owner = owner;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, Material.class), new RenameAction(this, Intl.intl("material")), new ManagerDlg.DeleteAction(this)};
        this.d_editor = new MaterialPanel(this);
    }

    private void updateActions() {
        int selIx = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_matMgr != null);
        this.d_actions[2].setEnabled(this.d_matMgr != null && selIx > -1);
        this.d_actions[3].setEnabled(this.d_matMgr != null && selIx > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(MaterialManager matMgr, Material init) {
        this.d_matMgr = matMgr;
        ((RenameAction)this.d_actions[2]).init(matMgr);
        super.init(this.d_matMgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 61273074678084049L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!MaterialManagerDlg.this.preSave()) {
                return;
            }
            int selIx = MaterialManagerDlg.this.getList().getSelectedIx();
            Material surf = selIx >= 0 ? (Material)MaterialManagerDlg.this.getList().getItem(selIx) : null;
            NewMaterialDlg dlg = new NewMaterialDlg((Window)MaterialManagerDlg.this, MaterialManagerDlg.this.d_matMgr, surf);
            PyroMod domain = (PyroMod)MaterialManagerDlg.this.d_matMgr.getDomain();
            if (dlg.doModal() == 1) {
                Material base = dlg.getBaseMat();
                if (base == null) {
                    return;
                }
                Material newMaterial = new Material(dlg.getName(), base.getPyrolysis(), base.getThermalProps());
                newMaterial.setCustomFDSProps(base.getCustomFDSProps());
                AddTask t = new AddTask((IPyroObject)MaterialManagerDlg.this.d_matMgr, new IPyroObject[]{newMaterial});
                SelectTask wrapper = new SelectTask(domain, newMaterial);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Material"));
                MaterialManagerDlg.this.getList().updateModelView(MaterialManagerDlg.this.d_matMgr);
                MaterialManagerDlg.this.getList().select(newMaterial);
                MaterialManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                MaterialManagerDlg.this.updateActions();
            }
        }
    }
}

