/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import pyrosim.Intl;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.SurfaceCheckDesc;
import pyrosim.gui.auditing.ICheckRenderer;
import pyrosim.gui.auditing.ModelCheckEditor;
import pyrosim.gui.boundcond.SurfacePanel;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;

public class SurfaceCheckRenderer
implements ICheckRenderer {
    private final guiLabel d_surfTypeLabel;
    private final guiComboBox<String> d_surfType = new guiComboBox();
    private final guiCheckBox d_hrrCheck;
    private final guiCheckBox d_flowVol;
    private final guiCheckBox d_flowVel;

    SurfaceCheckRenderer() {
        this.d_surfType.addItem((String)SurfacePanel.BURNER);
        this.d_surfType.addItem((String)SurfacePanel.SUPPLY);
        this.d_surfType.addItem((String)SurfacePanel.EXHAUST);
        this.d_surfTypeLabel = new guiLabel(Intl.intl("Surface Type: "));
        this.d_hrrCheck = new guiCheckBox(Intl.intl("Calculate total maximum HRR per applicable surface."));
        this.d_flowVol = new guiCheckBox(Intl.intl("Calculate total maximum flow volume per applicable surface."));
        this.d_flowVel = new guiCheckBox(Intl.intl("Calculate maximum flow velocity per applicable surface."));
        this.d_surfType.addActionListener(e -> this.updateSurfaceType(this.d_surfType.getSelectedItem()));
        this.updateSurfaceType(this.d_surfType.getSelectedItem());
    }

    private void updateSurfaceType(String surfaceType) {
        this.d_hrrCheck.setVisible(surfaceType.equals(SurfacePanel.BURNER));
        this.d_flowVol.setVisible(!surfaceType.equals(SurfacePanel.BURNER));
        this.d_flowVel.setVisible(!surfaceType.equals(SurfacePanel.BURNER));
    }

    @Override
    public void render(ModelCheckEditor modelCheckEditor) {
        modelCheckEditor.add(this.d_surfTypeLabel);
        modelCheckEditor.add(this.d_surfType, "wrap, width 100");
        modelCheckEditor.add((Component)this.d_hrrCheck, "span 2, wrap");
        modelCheckEditor.add((Component)this.d_flowVol, "span 2, wrap");
        modelCheckEditor.add((Component)this.d_flowVel, "span 2, wrap");
    }

    @Override
    public void init(ModelCheck modelCheck) {
        ICheckDesc iCheckDesc = modelCheck.getCheckDesc();
        if (iCheckDesc instanceof SurfaceCheckDesc) {
            SurfaceCheckDesc checkDesc = (SurfaceCheckDesc)iCheckDesc;
            if (checkDesc.getType().equals((Object)SurfaceCheckDesc.Type.EXHAUST)) {
                this.d_surfType.setSelectedItem(SurfacePanel.EXHAUST);
            } else if (checkDesc.getType().equals((Object)SurfaceCheckDesc.Type.SUPPLY)) {
                this.d_surfType.setSelectedItem(SurfacePanel.SUPPLY);
            } else {
                this.d_surfType.setSelectedItem(SurfacePanel.BURNER);
            }
            this.d_hrrCheck.setSelected(checkDesc.d_maxHrr);
            this.d_flowVol.setSelected(checkDesc.d_maxVol);
            this.d_flowVel.setSelected(checkDesc.d_maxVel);
        }
    }

    @Override
    public void updateCheck(ModelCheck modelCheck) {
        ICheckDesc iCheckDesc = modelCheck.getCheckDesc();
        if (iCheckDesc instanceof SurfaceCheckDesc) {
            SurfaceCheckDesc checkDesc = (SurfaceCheckDesc)iCheckDesc;
            String type = this.d_surfType.getSelectedItem();
            if (type != null) {
                if (type.equals(SurfacePanel.BURNER)) {
                    checkDesc.setType(SurfaceCheckDesc.Type.HRR);
                }
                if (type.equals(SurfacePanel.EXHAUST)) {
                    checkDesc.setType(SurfaceCheckDesc.Type.EXHAUST);
                }
                if (type.equals(SurfacePanel.SUPPLY)) {
                    checkDesc.setType(SurfaceCheckDesc.Type.SUPPLY);
                }
            }
            checkDesc.setOptions(this.d_hrrCheck.isSelected(), this.d_flowVol.isSelected(), this.d_flowVel.isSelected());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_surfTypeLabel.setVisible(visible);
        this.d_surfType.setVisible(visible);
        this.d_hrrCheck.setVisible(visible);
        this.d_flowVol.setVisible(visible);
        this.d_flowVel.setVisible(visible);
    }
}

