/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckManager;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.gui.auditing.ModelCheckEditor;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewModelCheckDlg
extends guiDialog {
    private static final long serialVersionUID = 2841147844264291311L;
    private ModelCheckManager d_mcMgr = null;
    private guiTextField d_name = null;
    private guiComboBox<String> d_checkType;

    public NewModelCheckDlg(Window parent, ModelCheckManager modelCheckMgr) {
        super(parent, Intl.intl("New Model Check"), 9);
        this.setSize(new Dimension(250, 150));
        this.d_mcMgr = modelCheckMgr;
        this.d_name = new guiTextField(this.generateUniqueName());
        this.d_checkType = new guiComboBox();
        this.d_checkType.addItem((String)ModelCheckEditor.SURFACE_CHECK);
        this.d_checkType.addItem((String)ModelCheckEditor.RECORD_CHECK);
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(dlgPanel, new guiLabel(Intl.intl("Check Name") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_name, 1, row++, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
        GridBagUtil.add(dlgPanel, new guiLabel(Intl.intl("Check Type") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_checkType, 1, row++, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        String reqName = this.d_name.getText();
        if (this.nameInUse(reqName)) {
            String msg = Intl.intl("Rule name already in use.") + "\n" + Intl.intl("Each rule must have a unique name.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String msg = Intl.intl("You must name the rule.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    private boolean nameInUse(String name) {
        return ((PyroMod)this.d_mcMgr.getDomain()).getNames(Material.class).isRegistered(name);
    }

    public String getCheckType() {
        return this.d_checkType.getSelectedItem();
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_mcMgr.getDomain()).getNames(ModelCheck.class).generateName();
    }
}

