/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pyrosim.FDSVersion;
import pyrosim.PyroSim;
import pyrosim.domain.auditing.FilterFactory;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckFilter;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.v6.FDS6Const;
import thunderheadeng.Intl;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

class ModelFilterTable
extends guiTable {
    private final Map<String, FDSRecordSpec> d_recordSpecMap;

    public ModelFilterTable(guiDefaultTableModel model, String[] columnHeaders, Class[] columnClasses) {
        super((TableModel)model, 24);
        FDSVersion fdsVersion = PyroSim.getApp().getFDSCompability();
        this.d_recordSpecMap = fdsVersion.major == 7 ? FDS6Const.getRecordSpecs() : FDS6Const.getRecordSpecs();
        this.setNullValuesAllowed(true);
        if (columnHeaders.length != columnClasses.length) {
            throw new IllegalArgumentException("Must have same number of column headers as column classes.");
        }
        this.setModel(model);
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < columnHeaders.length; ++i) {
            tcm.getColumn(i).setHeaderValue(columnHeaders[i]);
            model.setColumnClass(i, columnClasses[i]);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row == 0 && col == 0) {
            return false;
        }
        if (row > 0 && this.getValueAt(row, 0) == ModelCheck.Op.AND) {
            return col != 1;
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row == 0 && column == 0) {
            value = null;
        }
        super.setValueAt(value, row, column);
        if (row > 0 && column == 0 && value == ModelCheck.Op.AND) {
            value = this.getValueAt(row - 1, 1);
            column = 1;
            this.setValueAt(value, row, column);
        }
        if (column == 1 && value != null) {
            for (int i = row + 1; i < this.getRowCount() && this.getValueAt(i, 0) == ModelCheck.Op.AND; ++i) {
                this.setValueAt(value, i, 1);
            }
            super.setValueAt("", row, 2);
            super.setValueAt("", row, 4);
        }
        if (column == 2 && value != null) {
            String record = this.getValueAt(row, 1).toString();
            FDSRecordSpec.Field f = this.d_recordSpecMap.get((Object)record).fields.get(value.toString());
            if (f.initialValue != null) {
                super.setValueAt(f.initialValue, row, 4);
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Object recordVal = this.getValueAt(row, 1);
        Object fieldVal = this.getValueAt(row, 2);
        if (column == 2 && recordVal != null) {
            guiComboBox fieldBox = new guiComboBox(this.d_recordSpecMap.get((Object)recordVal).fields.keySet().stream().sorted().collect(Collectors.toList()));
            return new DefaultCellEditor(fieldBox);
        }
        if (column == 4 && recordVal != null && fieldVal != null) {
            FDSRecordSpec.Field f = this.d_recordSpecMap.get((Object)recordVal).fields.get(fieldVal);
            if (f.clazz == UnitDouble.class) {
                FDSRecordSpec.UnitDoubleFld udf = (FDSRecordSpec.UnitDoubleFld)f;
                return new guiTable.UnitDoubleEditor(udf.unit);
            }
            if (f.clazz == Double.class) {
                return new guiTable.guiDoubleEditor();
            }
            if (f.clazz == Integer.class) {
                return new guiTable.guiIntegerEditor();
            }
            if (f.clazz == Boolean.class) {
                return new guiTable.guiBooleanEditor();
            }
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object recordVal = this.getValueAt(row, 1);
        Object fieldVal = this.getValueAt(row, 2);
        if (column == 4 && recordVal != null && fieldVal != null) {
            DefaultTableCellRenderer renderer;
            FDSRecordSpec.Field f = this.d_recordSpecMap.get((Object)recordVal).fields.get(fieldVal);
            if (f.clazz == UnitDouble.class) {
                FDSRecordSpec.UnitDoubleFld udf = (FDSRecordSpec.UnitDoubleFld)f;
                renderer = new guiTable.UnitDoubleRenderer(udf.unit);
            } else {
                renderer = f.clazz == Double.class ? new guiTable.guiDoubleRenderer() : (f.clazz == Integer.class ? new guiTable.guiIntegerRenderer() : (f.clazz == Boolean.class ? new guiTable.guiBooleanRenderer() : new DefaultTableCellRenderer()));
            }
            renderer.setHorizontalAlignment(2);
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }

    public ModelCheckFilter<?> createCheckFilter(int row) {
        ModelCheck.Op op = (ModelCheck.Op)((Object)this.getValueAt(row, 0));
        op = op == null ? ModelCheck.Op.AND : op;
        String record = (String)this.getValueAt(row, 1);
        String field = (String)this.getValueAt(row, 2);
        ModelCheck.Condition condition = (ModelCheck.Condition)((Object)this.getValueAt(row, 3));
        Object value = this.getValueAt(row, 4);
        FDSRecordSpec.Field f = this.d_recordSpecMap.get((Object)record).fields.get(field);
        if (f.clazz == UnitDouble.class) {
            UnitDouble ud = this.parseUnitDoubleVal(value, f);
            return FilterFactory.create(op, record, field, condition, ud);
        }
        if (f.clazz == Double.class) {
            Double d = Double.parseDouble(value.toString());
            return FilterFactory.create(op, record, field, condition, d);
        }
        if (f.clazz == Integer.class) {
            int i = Integer.parseInt(value.toString());
            return FilterFactory.create(op, record, field, condition, i);
        }
        if (f.clazz == Boolean.class) {
            boolean b = Boolean.parseBoolean(value.toString());
            return FilterFactory.create(op, record, field, condition, b);
        }
        return FilterFactory.create(op, record, field, condition, value.toString());
    }

    private UnitDouble parseUnitDoubleVal(Object value, FDSRecordSpec.Field<?> f) {
        try {
            FDSRecordSpec.UnitDoubleFld udf = (FDSRecordSpec.UnitDoubleFld)f;
            return Global.parseUnitDouble(value.toString(), udf.unit);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        boolean valid = super.validateData(showWarn, allowModify);
        if (!valid) {
            return false;
        }
        TableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (model.getValueAt(row, col) != null || row == 0 || col == 0) continue;
                String msg = String.format(Intl.intl("Error: Blank value in cell, [%s]."), this.formatCellName(row, col));
                this.flagInvalidCell(row, col, showWarn, allowModify, msg);
                return false;
            }
        }
        return true;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        c.setEnabled(this.isCellEditable(row, column));
        return c;
    }

    public Map<String, FDSRecordSpec> getRecordSpec() {
        return this.d_recordSpecMap;
    }
}

