/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JFrame;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckManager;
import pyrosim.domain.auditing.RecordCheckDesc;
import pyrosim.domain.auditing.ResultsEmptyCondition;
import pyrosim.domain.auditing.SurfaceCheckDesc;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.auditing.ModelCheckEditor;
import pyrosim.gui.auditing.ModelCheckLibraryDlg;
import pyrosim.gui.auditing.NewModelCheckDlg;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class ModelCheckManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -3129562941548645763L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private ModelCheckManager d_modelCheckMgr;
    private JFrame d_owner;

    public ModelCheckManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Rules"), false);
        this.d_owner = owner;
        this.d_actions = new Action[]{new NewAction(), new ModelCheckLibraryAction(ModelCheck.class), new RenameAction(this, Intl.intl("rule")), new ManagerDlg.DeleteAction(this)};
        this.d_editor = new ModelCheckEditor();
        this.setPreferredSize(new Dimension(800, 700));
    }

    private void updateActions() {
        int selIx = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_modelCheckMgr != null);
        this.d_actions[2].setEnabled(this.d_modelCheckMgr != null && selIx > -1);
        this.d_actions[3].setEnabled(this.d_modelCheckMgr != null && selIx > -1);
    }

    public void init(ModelCheckManager modelCheckMgr, ModelCheck modelCheck) {
        this.d_modelCheckMgr = modelCheckMgr;
        ((RenameAction)this.d_actions[2]).init(modelCheckMgr);
        super.init(this.d_modelCheckMgr, this.d_editor, this.d_actions, modelCheck);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -4464281587526765803L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!ModelCheckManagerDlg.this.preSave()) {
                return;
            }
            NewModelCheckDlg dlg = new NewModelCheckDlg((Window)ModelCheckManagerDlg.this, ModelCheckManagerDlg.this.d_modelCheckMgr);
            PyroMod domain = (PyroMod)ModelCheckManagerDlg.this.d_modelCheckMgr.getDomain();
            if (dlg.doModal() == 1) {
                String checkType = dlg.getCheckType();
                ModelCheck newCheck = null;
                if (checkType.equals(ModelCheckEditor.SURFACE_CHECK)) {
                    newCheck = new ModelCheck(dlg.getName(), "", new ResultsEmptyCondition(), new SurfaceCheckDesc());
                } else if (checkType.equals(ModelCheckEditor.RECORD_CHECK)) {
                    newCheck = new ModelCheck(dlg.getName(), "", new ResultsEmptyCondition(), new RecordCheckDesc(new ArrayList()));
                }
                if (newCheck == null) {
                    return;
                }
                AddTask t = new AddTask((IPyroObject)ModelCheckManagerDlg.this.d_modelCheckMgr, new IPyroObject[]{newCheck});
                SelectTask wrapper = new SelectTask(domain, newCheck);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Model Check"));
                ModelCheckManagerDlg.this.getList().updateModelView(ModelCheckManagerDlg.this.d_modelCheckMgr);
                ModelCheckManagerDlg.this.getList().select(newCheck);
                ModelCheckManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                ModelCheckManagerDlg.this.updateActions();
            }
        }
    }

    protected class ModelCheckLibraryAction
    extends ManagerDlg.LibraryAction {
        public ModelCheckLibraryAction(Class type) {
            super(ModelCheckManagerDlg.this, type);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ModelCheckManagerDlg.this.preSave()) {
                return;
            }
            int ix = ModelCheckManagerDlg.this.getList().getSelectedIx();
            PyroSim pyroSim = PyroSim.getApp();
            assert (pyroSim != null);
            ModelCheckLibraryDlg dlg = new ModelCheckLibraryDlg(ModelCheckManagerDlg.this.d_owner, pyroSim);
            dlg.doModal();
            ModelCheckManagerDlg.this.getList().updateModelView(ModelCheckManagerDlg.this.d_modelCheckMgr);
            int newIx = ix - 1 < 0 && !ModelCheckManagerDlg.this.d_modelCheckMgr.flatten().isEmpty() ? 0 : ix - 1;
            if (ix >= 0) {
                ModelCheckManagerDlg.this.getList().select(newIx);
                if (newIx == ix) {
                    ModelCheckManagerDlg.this.initItem(ModelCheckManagerDlg.this.getList().getItem(newIx));
                }
            }
        }
    }
}

