/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javafx.stage.FileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.PyroSimObjectOutputStream;
import pyrosim.util.Util;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Task;

public class ModelCheckLibraryDlg
extends ALibraryDlg<ModelCheck> {
    private List<ModelCheck> d_libModel;
    private final List<ModelCheck> d_curModel;
    private final PyroMod d_domain;
    private final String d_predefinedLibInstallPath;
    private final String d_predefinedLibAppDataPath;
    private static final String libExt = "pslib";

    public ModelCheckLibraryDlg(JFrame owner, PyroSim app) {
        super(owner, app, Intl.intl("Model Check Libraries"), libExt);
        this.d_domain = app.getMediator();
        this.d_curModel = new ArrayList<ModelCheck>();
        this.d_predefinedLibInstallPath = new File(this.d_app.getInstallDir()).getPath();
        this.d_predefinedLibAppDataPath = new File(this.d_app.getAppDataDir()).getPath();
        this.d_curModel.addAll(this.d_domain.getModelCheckMgr().flatten());
        this.d_libModel = new ArrayList<ModelCheck>();
        this.loadList(this.d_curModel, this.d_modelObjs, ModelCheck.class);
        this.init(PyroPrefs.PREF_LASTLIBRARY, PyroPrefs.LastFDSDatabaseDirProp, ModelCheck.class);
    }

    @Override
    protected void loadFromLibrary() {
        this.d_app.beginWaitCursor();
        List<ModelCheck> added = this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_curModel);
        AddTask<ModelCheck> t = new AddTask<ModelCheck>((IPyroObject)this.d_domain.getModelCheckMgr(), (Collection<ModelCheck>)added);
        SelectTask wrapper = new SelectTask(this.d_domain, added);
        wrapper.addTask(t);
        this.d_domain.getTaskManager().exec(wrapper, Intl.intl("Add Checks"));
        this.d_app.endWaitCursor();
    }

    @Override
    protected void saveToLibrary() {
        this.d_app.beginWaitCursor();
        if (!this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.getLibModel()).isEmpty()) {
            this.d_libUnsaved = true;
        }
        this.d_app.endWaitCursor();
    }

    @Override
    protected File serialize(List<ModelCheck> checks) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(String.format("%s.%s", FilenameManager.splitFilename(this.d_currentLib)[0], libExt), PyroPrefs.get(PyroPrefs.LastFDSDatabaseDirProp), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_PSLIB);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return null;
        }
        try (PyroSimObjectOutputStream oos = new PyroSimObjectOutputStream(new FileOutputStream(f));){
            oos.writeObject(checks);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getParent(), e.getLocalizedMessage(), Intl.intl("Error"), 2);
            e.printStackTrace();
        }
        return f;
    }

    @Override
    protected List<ModelCheck> deserialize(String filename, boolean showWarnings) {
        ArrayList<ModelCheck> newLibModel;
        try (FileInputStream fis = new FileInputStream(filename);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            if (filename.endsWith(".psm")) {
                PyroSimObjectInputStream ois = new PyroSimObjectInputStream(bis, false, Optional.of(new File(filename)));
                newLibModel = new ArrayList<ModelCheck>(((APyroObject)((Serialized)ois.readObject()).modelCheckManager).flatten(ModelCheck.class));
            } else {
                PyroSimObjectInputStream ois = new PyroSimObjectInputStream(bis, false);
                newLibModel = (ArrayList<ModelCheck>)ois.readObject();
            }
        }
        catch (IOException | ClassNotFoundException cnfe) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.getParent(), cnfe.getLocalizedMessage(), Intl.intl("Error"), 2);
            }
            cnfe.printStackTrace();
            return null;
        }
        this.d_libModel = newLibModel;
        return newLibModel;
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        IPyroObject obj = (IPyroObject)value;
        r.setText(Util.getName(obj));
    }

    @Override
    protected void deleteModObjs() {
        List<ModelCheck> deleted = this.deleteObjs(this.d_modelObjs, this.d_curModel);
        if (!deleted.isEmpty()) {
            Task t = Actions.getDeleteTask(this.d_domain, deleted);
            if (t == null) {
                return;
            }
            this.d_domain.getTaskManager().exec(t, Intl.intl("Delete Objects"));
        }
    }

    @Override
    protected void deleteLibObjs() {
        if (!this.deleteObjs(this.d_libObjs, this.d_libModel).isEmpty()) {
            this.d_libUnsaved = true;
        }
    }

    private String getNewName(ModelCheck namedObj, Collection<? extends ModelCheck> containerCopiedTo) {
        boolean alreadyExists;
        String baseName = namedObj.getName();
        Object newName = baseName;
        int i = 1;
        do {
            alreadyExists = false;
            for (INamed iNamed : containerCopiedTo) {
                if (!iNamed.getName().equals(newName)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) continue;
            newName = baseName + " (" + i++ + ")";
        } while (alreadyExists);
        return newName;
    }

    public List<ModelCheck> copyListSelection(JList<ModelCheck> jlistBeingCopied, JList<ModelCheck> jlistCopiedTo, List<ModelCheck> containerCopiedTo) {
        List<ModelCheck> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<ModelCheck, ModelCheck> replacements = new LinkedHashMap<ModelCheck, ModelCheck>();
        for (ModelCheck check : objsToCopy) {
            String newName = this.getNewName(check, containerCopiedTo);
            ModelCheck newCheck = check.clone();
            if (!newName.equals(check.getName())) {
                newCheck.setName(newName);
            }
            replacements.put(check, newCheck);
        }
        for (ModelCheck check : replacements.keySet()) {
            int replIndex = objsToCopy.indexOf(check);
            objsToCopy.remove(replIndex);
            objsToCopy.add(replIndex, (ModelCheck)replacements.get(check));
        }
        containerCopiedTo.addAll(objsToCopy);
        this.loadList(containerCopiedTo, jlistCopiedTo, ModelCheck.class);
        return objsToCopy;
    }

    protected List<ModelCheck> deleteObjs(JList<ModelCheck> jlist, List<ModelCheck> model) {
        List<ModelCheck> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return new ArrayList<ModelCheck>();
        }
        for (ModelCheck obj : objs) {
            model.remove(obj);
        }
        this.loadList(model, jlist, ModelCheck.class);
        return objs;
    }

    @Override
    protected List<ModelCheck> getLibModel() {
        return this.d_libModel;
    }

    @Override
    protected void resetLibModel() {
        this.d_libModel = new ArrayList<ModelCheck>();
    }

    @Override
    protected PyroMod getDomain() {
        return this.d_domain;
    }

    @Override
    protected FileChooser.ExtensionFilter[] getFileFilter() {
        return new FileChooser.ExtensionFilter[]{FileFilters.EXT_FILTER_PSLIB, FileFilters.EXT_FILTER_PYROSIM};
    }

    @Override
    protected String getPredefinedPath() {
        return this.d_predefinedLibInstallPath;
    }

    @Override
    protected String getAppDataPath() {
        return this.d_predefinedLibAppDataPath;
    }
}

