/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import pyrosim.Accelerators;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ChangeOrderTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.SetActiveViewTask;
import pyrosim.domain.tasks.ViewPropTask;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.domain.view.ViewMgr;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.actions.ComponentSensitiveAction;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ViewActions {
    private static Task taskNewView(PyroSim app, ViewList parent, SectionBox sbox, boolean select, boolean setActive) {
        PyroMod domain = app.getMediator();
        View view = new View(domain.getNames(View.class).generateName());
        PyroSim.getApp().getModelView().taskSaveViewState(domain, Arrays.asList(view)).run();
        if (sbox != null) {
            view.set(View.PROP_SECTION_BOX, (SectionBox)sbox.clone());
        }
        CompositeTask task = select ? new SelectTask(domain, view) : new CompositeTask<PyroMod>(domain);
        task.addTask(new AddTask((IPyroObject)parent, (IPyroObject[])new View[]{view}));
        if (setActive) {
            task.addTask(Actions.SET_ACTIVE_VIEW_ACTION.setActiveView(domain, view));
        }
        return task;
    }

    private static AABox getSectionBoxBounds(PyroSim app) {
        return ViewActions.finalizeSectionBounds(app.getModelView().getClipManager().getUnclippedBounds());
    }

    private static AABox getSelectionSectionBoxBounds(PyroSim app) {
        Collection<IPyroGeomSrc> objs = app.getMediator().getSelectionModel().flatten(IPyroGeomSrc.class);
        return ViewActions.getSectionBoxBounds(app, objs);
    }

    private static AABox getSectionBoxBounds(PyroSim app, Collection<? extends IPyroGeomSrc> objs) {
        ArrayList<Object3D> displays = new ArrayList<Object3D>(objs.size());
        displays.addAll(theUtil.filter(app.getModelView().getDisplayManager().getDisplayObjs(objs), Object3D.class));
        BoundsCalculator boundsCalc = new BoundsCalculator();
        boundsCalc.add(theUtil.toArray(displays, Object3D.class));
        return ViewActions.finalizeSectionBounds(boundsCalc.getBounds());
    }

    private static AABox finalizeSectionBounds(AABox bounds) {
        bounds = bounds.ensureValidSize(1.0, 1.0);
        bounds = bounds.scale(1.1);
        return bounds;
    }

    private static Task taskAddSectionBox(PyroSim app, PyroMod domain, List<View> selViews, boolean selNewBoxes) {
        AABox bounds = ViewActions.getSectionBoxBounds(app);
        AABoxGeom geom = new AABoxGeom(bounds);
        ArrayList<SectionBox> newBoxes = new ArrayList<SectionBox>(selViews.size());
        for (int m = 0; m < selViews.size(); ++m) {
            newBoxes.add(new SectionBox(geom));
        }
        return ViewActions.taskAddSectionBox(app, domain, selViews, newBoxes, selNewBoxes);
    }

    private static Task taskAddSectionBox(PyroSim app, PyroMod domain, List<View> selViews, List<SectionBox> newBoxes, boolean selNewBoxes) {
        BiFunction<View, Integer, SectionBox> boxProducer = (v, i) -> (SectionBox)newBoxes.get((int)i);
        ViewPropTask<SectionBox> task = ViewPropTask.set(selViews, View.PROP_SECTION_BOX, boxProducer);
        if (selNewBoxes) {
            SelectTask selTask = new SelectTask(domain, newBoxes);
            selTask.addTask(task);
            return selTask;
        }
        return task;
    }

    static class SetActiveViewAction
    extends guiAction {
        private static final long serialVersionUID = -2715114454323192460L;

        public SetActiveViewAction() {
            super(Intl.intl("Set Active"));
            this.putValue("ShortDescription", Intl.intl("Sets as the active view"));
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (selChanged || events.getEvents(ViewMgr.class, new Class[0]).containsChange(ViewMgr.EVT_ACTIVE_VIEW)) {
                this.setEnabled(this.getEnabled(domain));
            }
        }

        private boolean getEnabled(PyroMod domain) {
            IFilteredCollection<View> selViews = domain.getSelectionModel().getSelected(View.class);
            if (selViews.isExclusive() && selViews.size() == 1 && selViews.iterator().next() != domain.getViews().getActiveView()) {
                return true;
            }
            IFilteredCollection<CameraState> selCameras = domain.getSelectionModel().getSelected(CameraState.class);
            return selCameras.isExclusive() && selCameras.size() == 1 && ((CameraState)selCameras.iterator().next()).getParent() != domain.getViews().getActiveView();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod domain = PyroSim.getApp().getMediator();
            IPyroObject selView = null;
            IFilteredCollection<View> selViews = domain.getSelectionModel().getSelected(View.class);
            if (!selViews.isEmpty()) {
                selView = (IPyroObject)selViews.iterator().next();
            } else {
                IFilteredCollection<CameraState> selCameras = domain.getSelectionModel().getSelected(CameraState.class);
                if (!selCameras.isEmpty()) {
                    selView = ((CameraState)selCameras.iterator().next()).getParent();
                }
            }
            if (!(selView instanceof View)) {
                return;
            }
            View newView = (View)selView;
            Task task = this.setActiveView(domain, newView);
            int options = 16;
            domain.getTaskManager().exec(task, Intl.intl("Set Active View"), options);
        }

        public Task setActiveView(PyroMod domain, View newView) {
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(domain);
            task.addTask(new SetActiveViewTask(domain, newView));
            return task;
        }
    }

    public static class AddViewAction
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = 5701921527395540689L;
        private final boolean d_contextMenu;

        public AddViewAction(boolean contextMenu) {
            super(Intl.intl("New View"));
            this.putValue("ShortDescription", Intl.intl("Adds a new view to the model."));
            this.d_contextMenu = contextMenu;
            if (!this.d_contextMenu) {
                this.putValue("AcceleratorKey", Accelerators.NEW_VIEW);
            }
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (this.d_contextMenu && selChanged) {
                PyroSimSelectionModel sel = domain.getSelectionModel();
                IFilteredCollection<ViewList> views = sel.getSelected(ViewList.class);
                this.setEnabled(!views.isEmpty() && views.isExclusive());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod domain = PyroSim.getApp().getMediator();
            ViewList parent = !this.d_contextMenu ? domain.getViews() : (ViewList)domain.getSelectionModel().getSelected(ViewList.class).iterator().next();
            SectionBox sbox = domain.getViews().getActiveView().get(View.PROP_SECTION_BOX);
            Task task = ViewActions.taskNewView(PyroSim.getApp(), parent, sbox, true, true);
            domain.getTaskManager().exec(task, Intl.intl("New View"));
        }
    }

    private static class SetSectionBoxGeomTask
    extends AUndoableTask {
        private final List<SectionBox> d_boxes;
        private List<IGeom> d_geom;

        public SetSectionBoxGeomTask(List<SectionBox> boxes, List<IGeom> newGeom) {
            this.d_boxes = boxes;
            this.d_geom = newGeom;
        }

        @Override
        public void run() {
            this.setGeom();
        }

        @Override
        public void undo() {
            this.setGeom();
        }

        private void setGeom() {
            ((PyroMod)this.d_boxes.get(0).getDomain()).pauseUpdates();
            ArrayList<IGeom> oldGeom = new ArrayList<IGeom>(this.d_boxes.size());
            for (int m = 0; m < this.d_boxes.size(); ++m) {
                SectionBox box = this.d_boxes.get(m);
                oldGeom.add((IGeom)box.get());
                box.set(this.d_geom.get(m));
            }
            this.d_geom = oldGeom;
            ((PyroMod)this.d_boxes.get(0).getDomain()).resumeUpdates();
        }
    }

    public static class DuplicateView
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = 4400422772447713039L;

        public DuplicateView() {
            super("");
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (selChanged) {
                Pair<String, String> text = this.getEnabledText(domain);
                if (text != null) {
                    this.setName((String)text.v1);
                    this.putValue("ShortDescription", text.v2);
                }
                this.setEnabled(text != null);
            }
        }

        private Pair<String, String> getEnabledText(PyroMod domain) {
            Collection<View> selViews = domain.getSelectionModel().flatten(View.class);
            if (!selViews.isEmpty()) {
                if (selViews.size() == 1) {
                    return new Pair<String, String>(Intl.intl("Duplicate View"), Intl.intl("Duplicates the selected view."));
                }
                return new Pair<String, String>(Intl.intl("Duplicate Views"), Intl.intl("Duplicates the selected views."));
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mod = PyroSim.getApp().getMediator();
            LinkedIdentityHashSet<View> views = new LinkedIdentityHashSet<View>(mod.getSelectionModel().flatten(View.class));
            LinkedIdentityHashSet affectedParents = new LinkedIdentityHashSet();
            for (View view : views) {
                affectedParents.add((ViewList)view.getParent());
            }
            ArrayList<View> allNewViews = new ArrayList<View>(views.size());
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(mod);
            for (ViewList parent : affectedParents) {
                ArrayList<View> newViews = new ArrayList<View>();
                ArrayList<IPyroObject> newOrder = new ArrayList<IPyroObject>(parent.getChildren().size());
                for (IPyroObject child : parent.getMembers()) {
                    if (!views.contains(child)) {
                        newOrder.add(child);
                        continue;
                    }
                    if (!(child instanceof View)) continue;
                    View view = (View)child;
                    View newView = view.clone();
                    newViews.add(newView);
                    newOrder.add(child);
                    newOrder.add(newView);
                    allNewViews.add(newView);
                }
                task.addTask(new AddAutoRenameTask<View>((Composite<View>)parent, (Collection<View>)newViews));
                task.addTask(new ChangeOrderTask(parent, children -> newOrder));
            }
            task.addTask(new SelectTask(mod, allNewViews));
            mod.getTaskManager().exec(task, Intl.intl("Duplicate View"));
        }
    }

    public static class CreationSection
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = 64806327984810562L;
        private Object d_prevSel = null;

        public CreationSection() {
            super("");
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (selChanged || events.getEvents(View.class, new Class[0]).containsChange(View.PROP_SECTION_BOX) || events.getEvents(SectionBox.class, new Class[0]).hasAddedObjs() || events.getEvents(SectionBox.class, new Class[0]).hasRemovedObjs()) {
                Pair<String, String> enText = this.getEnabledText(domain);
                if (enText != null) {
                    this.setName((String)enText.v1);
                    this.putValue("ShortDescription", enText.v2);
                }
                this.setEnabled(enText != null);
            }
        }

        private Pair<String, String> getEnabledText(PyroMod domain) {
            if (!domain.getSelectionModel().flatten(IPyroGeomSrc.class).isEmpty()) {
                String name = domain.getViews().getActiveView().get(View.PROP_SECTION_BOX) != null ? Intl.intl("Create Section...") : Intl.intl("Create Section");
                String desc = Intl.intl("Creates a section box surrounding the selected objects.");
                return new Pair<String, String>(name, desc);
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            PyroMod domain = app.getMediator();
            int option = 0;
            View aview = domain.getViews().getActiveView();
            if (aview.get(View.PROP_SECTION_BOX) != null) {
                String msg = Intl.intl("The active view already has a section box. How would\nyou like to proceed?");
                String newView = Intl.intl("Create a new view with the section box.");
                String resetBox = Intl.intl("Modify the section box in the active view.");
                Object initSel = this.d_prevSel != null ? this.d_prevSel : resetBox;
                Object sel = JOptionPane.showInputDialog(app.getActiveFrame(), msg, Intl.intl("Section Box Exists"), 3, null, new Object[]{resetBox, newView}, initSel);
                if (sel == null) {
                    return;
                }
                this.d_prevSel = sel;
                option = newView.equals(sel) ? 1 : 2;
            }
            Collection<IPyroGeomSrc> selObjs = domain.getSelectionModel().flatten(IPyroGeomSrc.class);
            AABox bounds = ViewActions.getSectionBoxBounds(app, selObjs);
            AABoxGeom geom = new AABoxGeom(bounds);
            domain.getTaskManager().exec(switch (option) {
                case 0 -> ViewActions.taskAddSectionBox(app, domain, Arrays.asList(aview), Arrays.asList(new SectionBox(geom)), false);
                case 1 -> {
                    ViewList parent = (ViewList)domain.getViews().getActiveView().getParent();
                    yield ViewActions.taskNewView(app, parent, new SectionBox(geom), false, true);
                }
                default -> new SetSectionBoxGeomTask(Arrays.asList(aview.get(View.PROP_SECTION_BOX)), Arrays.asList(geom));
            }, Intl.intl("Create Section"));
        }
    }

    public static class ResetSectionBox
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = 4332802972926192290L;
        private final boolean d_context;

        public ResetSectionBox(boolean context) {
            super(Intl.intl("Reset Section Box"));
            this.d_context = context;
            if (!this.d_context) {
                this.putValue("AcceleratorKey", Accelerators.RESET_SECTION_BOX);
            }
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (selChanged || events.getEvents(View.class, new Class[0]).containsChange(View.PROP_SECTION_BOX) || events.getEvents(SectionBox.class, new Class[0]).hasAddedObjs() || events.getEvents(SectionBox.class, new Class[0]).hasRemovedObjs()) {
                String enText = this.getEnabledText(domain);
                this.putValue("ShortDescription", enText);
                this.setEnabled(enText != null);
            }
        }

        private String getEnabledText(PyroMod domain) {
            if (this.d_context) {
                if (!domain.getSelectionModel().flatten(SectionBox.class).isEmpty()) {
                    return Intl.intl("Resets the selected section box(es) to the visible objects.");
                }
            } else if (domain.getViews().getActiveView().get(View.PROP_SECTION_BOX) != null) {
                return Intl.intl("Reset the active view's section box to the visible objects.");
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            PyroMod domain = app.getMediator();
            List<SectionBox> boxes = this.d_context ? new ArrayList<SectionBox>(domain.getSelectionModel().flatten(SectionBox.class)) : Arrays.asList(domain.getViews().getActiveView().get(View.PROP_SECTION_BOX));
            this.run(app, domain, boxes);
        }

        private void run(PyroSim app, PyroMod domain, List<SectionBox> boxes) {
            AABox bounds = ViewActions.getSectionBoxBounds(app);
            AABoxGeom geom = new AABoxGeom(bounds);
            ArrayList<IGeom> newGeoms = new ArrayList<IGeom>(boxes.size());
            for (int m = 0; m < boxes.size(); ++m) {
                newGeoms.add(geom);
            }
            SetSectionBoxGeomTask task = new SetSectionBoxGeomTask(boxes, newGeoms);
            domain.getTaskManager().exec(task, Intl.intl("Reset Section Box"));
        }
    }

    public static class AddSectionBox
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = 735067923511468190L;
        private final boolean d_context;

        public AddSectionBox(boolean context) {
            super(Intl.intl("Add Section Box"));
            this.d_context = context;
            if (!this.d_context) {
                this.putValue("AcceleratorKey", Accelerators.NEW_SECTION_BOX);
            }
        }

        private static Predicate<View> getViewFilter() {
            return v -> v.get(View.PROP_SECTION_BOX) == null;
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (selChanged || events.getEvents(View.class, new Class[0]).containsChange(View.PROP_SECTION_BOX)) {
                String text = this.getEnabledText(domain);
                if (text != null) {
                    this.putValue("ShortDescription", text);
                }
                this.setEnabled(text != null);
            }
        }

        private String getEnabledText(PyroMod domain) {
            if (this.d_context) {
                Collection<View> views;
                if (domain.getSelectionModel().getSelected(IPyroObject.class, View.class, ViewList.class).isExclusive() && !(views = domain.getSelectionModel().flatten(View.class, AddSectionBox.getViewFilter())).isEmpty()) {
                    String msg = views.size() == 1 ? Intl.intl("Add a section box to the selected view.") : Intl.intl("Add a section box to the selected views.");
                    return msg;
                }
            } else if (AddSectionBox.getViewFilter().test(domain.getViews().getActiveView())) {
                return Intl.intl("Add a section box to the active view.");
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            PyroMod domain = app.getMediator();
            List<View> views = this.d_context ? new ArrayList<View>(domain.getSelectionModel().flatten(View.class, AddSectionBox.getViewFilter())) : Arrays.asList(domain.getViews().getActiveView());
            this.run(app, domain, views);
        }

        private void run(PyroSim app, PyroMod domain, List<View> selViews) {
            Task task = ViewActions.taskAddSectionBox(app, domain, selViews, true);
            int options = 0;
            if (selViews.size() == 1 && selViews.contains(domain.getViews().getActiveView())) {
                options |= 0x20;
            }
            domain.getTaskManager().exec(task, Intl.intl("Add Section Box"), options);
        }
    }

    public static class ShowViewpoint
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = -8747821806111685304L;
        private final boolean d_context;

        public ShowViewpoint(boolean context) {
            super(context ? Intl.intl("Reset to Selected Viewpoint") : Intl.intl("Reset to Viewpoint"));
            this.d_context = context;
            String tt = this.d_context ? Intl.intl("Resets the scene camera to the selected viewpoint.") : Intl.intl("Resets the scene camera to the viewpoint of the active view.");
            this.putValue("ShortDescription", tt);
            if (!this.d_context) {
                this.putValue("AcceleratorKey", Accelerators.SHOW_VIEWPOINT);
            }
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            this.setEnabled(this.getEnabled(domain));
        }

        private boolean getEnabled(PyroMod domain) {
            if (this.d_context) {
                IFilteredCollection<View> views = domain.getSelectionModel().getSelected(View.class);
                if (views.size() == 1 && views.isExclusive() && ((View)views.iterator().next()).get(View.PROP_CAMERA) != null) {
                    return true;
                }
                IFilteredCollection<CameraState> cams = domain.getSelectionModel().getSelected(CameraState.class);
                return cams.size() == 1 && cams.isExclusive();
            }
            return domain.getViews().getActiveView().get(View.PROP_CAMERA) != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            View view;
            PyroSim app = PyroSim.getApp();
            PyroMod domain = app.getMediator();
            if (this.d_context) {
                IFilteredCollection<View> views = domain.getSelectionModel().getSelected(View.class);
                if (!views.isEmpty()) {
                    view = (View)views.iterator().next();
                } else {
                    CameraState cstate = (CameraState)domain.getSelectionModel().getSelected(CameraState.class).iterator().next();
                    if (!(cstate.getParent() instanceof View)) {
                        return;
                    }
                    view = (View)cstate.getParent();
                }
            } else {
                view = domain.getViews().getActiveView();
            }
            this.run(app, view);
        }

        private void run(PyroSim app, View view) {
            CameraState cstate = view.get(View.PROP_CAMERA);
            View.NavTool ntool = view.get(View.PROP_NAV_TOOL);
            app.setView(cstate, ntool);
        }
    }

    public static class SaveViewpoint
    extends ComponentSensitiveAction {
        private static final long serialVersionUID = 2377655270982195770L;
        private final boolean d_context;

        public SaveViewpoint(boolean context) {
            super(Intl.intl("Save Viewpoint"));
            this.d_context = context;
            if (!this.d_context) {
                this.putValue("ShortDescription", Intl.intl("Saves the current viewpoint to the active view."));
                this.putValue("AcceleratorKey", Accelerators.SAVE_VIEWPOINT);
            }
        }

        public void updateEnabled(PyroMod domain, Events events, boolean selChanged) {
            if (this.d_context && selChanged) {
                Pair<String, String> enText = this.getEnabledText(domain);
                this.setEnabled(enText != null);
                if (enText != null) {
                    this.setName((String)enText.v1);
                    this.putValue("ShortDescription", enText.v2);
                }
            }
        }

        private Pair<String, String> getEnabledText(PyroMod domain) {
            PyroSimSelectionModel sel = domain.getSelectionModel();
            IFilteredCollection<View> selViews = sel.getSelected(View.class);
            if (selViews.isExclusive() && selViews.size() == 1) {
                return new Pair<String, String>(Intl.intl("Save Viewpoint"), Intl.intl("Saves the current viewpoint to the selected view."));
            }
            IFilteredCollection<CameraState> selCams = sel.getSelected(CameraState.class);
            if (!selCams.isEmpty()) {
                return new Pair<String, String>(Intl.intl("Save Viewpoint"), Intl.intl("Saves the current viewpoint to the selected viewpoint(s)."));
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<View> views;
            PyroMod domain = PyroSim.getApp().getMediator();
            if (this.d_context) {
                LinkedHashSet<View> viewSet = new LinkedHashSet<View>(domain.getSelectionModel().flatten(View.class));
                for (CameraState cstate : domain.getSelectionModel().flatten(CameraState.class)) {
                    viewSet.add((View)cstate.getParent());
                }
                views = new ArrayList<View>(viewSet);
            } else {
                views = Arrays.asList(domain.getViews().getActiveView());
            }
            this.run(domain, views);
        }

        private void run(PyroMod domain, List<View> views) {
            Task t = PyroSim.getApp().getModelView().taskSaveViewState(domain, views);
            domain.getTaskManager().exec(t, Intl.intl("Save Viewpoint"));
        }
    }
}

