/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.unitsystem.EnglishUS;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.BooleanAction;

public class UnitsAction
extends BooleanAction {
    private static final long serialVersionUID = 4087419751549900242L;
    private static final Icon ICON_EN = PyroGuiUtil.loadPyroSimIcon("en16.png");
    private static final Icon ICON_SI = PyroGuiUtil.loadPyroSimIcon("si16.png");
    public static final UnitsAction SI_ACTION = new UnitsAction(SIUS.getInstance(), ICON_SI, Intl.intl("Show values in SI units"));
    public static final UnitsAction NON_SI_UNITS_ACTION = new UnitsAction(EnglishUS.getInstance(), ICON_EN, Intl.intl("Show values in English units"));
    private final UnitSystem d_unitSys;

    private UnitsAction(UnitSystem unitSystem, Icon icon, String shortDescription) {
        super(unitSystem.getSystemName(), PyroSim.getApp().getUnitSystem() == unitSystem, icon);
        this.putValue("ShortDescription", shortDescription);
        this.d_unitSys = unitSystem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroSim pySim = PyroSim.getApp();
        pySim.setUnitSystem(this.d_unitSys);
        pySim.getMediator().getEvents().changed(pySim.getMediator(), PyroMod.EVT_UNITSYSTEM_CHANGED);
    }

    public UnitSystem getUnitSystem() {
        return this.d_unitSys;
    }
}

