/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.ARunFDSValidation;

public class SimpleChemReactionValidation
extends ARunFDSValidation {
    public SimpleChemReactionValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        HashSet<Reaction> rxn = new HashSet<Reaction>();
        for (Reaction reaction : this.d_pyroMod.getReactions().getActiveReactions()) {
            if (!reaction.isDefaultSimpleChem(reaction.getFuel())) continue;
            rxn.add(reaction);
        }
        return rxn.size() > 0 ? rxn : Collections.emptySet();
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("Invalid reaction detected. Air not is a valid fuel for simple chemistry reactions (&REAC).\n\nClick OK to select the active simple reactions.\n\nClick Ignore to disregard this warning and run FDS.");
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return "Simple Chemistry Reaction Validation";
    }
}

