/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tags.TagsUtil;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.PyroObjsList;
import pyrosim.gui.actions.ComponentSensitiveAction;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.gui.dialogs.ShowTaggedObjsDialog;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ShowTaggedObjectsAction
extends ComponentSensitiveAction {
    public static final long serialVersionUID = 1L;
    private ShowTaggedObjsDialog d_optionsDlg = null;

    public ShowTaggedObjectsAction() {
        super(Intl.intl("Show Tagged Objects..."));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroSim app = PyroSim.getApp();
        PyroMod domain = app.getMediator();
        if (this.d_optionsDlg == null) {
            this.d_optionsDlg = new ShowTaggedObjsDialog((Window)app.getActiveFrame());
        }
        IdentityHashSet<Tag> tags = new IdentityHashSet<Tag>(domain.getSelectionModel().flatten(Tag.class));
        this.d_optionsDlg.setTags(tags, NamedPyroObject::getName);
        if (this.d_optionsDlg.doModal() != 1) {
            return;
        }
        Set<IPyroObject> objs = this.d_optionsDlg.getTaggedObjs(ShowTaggedObjectsAction.getDialogCallback(domain), tags);
        switch (this.d_optionsDlg.getShowMode()) {
            case SELECT: {
                app.getMediator().getTaskManager().exec((Task)new SelectTask(domain, objs), Intl.intl("Select Tagged Objects"), 0);
                break;
            }
            case LIST: {
                String title = ShowTaggedObjectsAction.generateTitle(domain, this.d_optionsDlg.getTagsCombine().desc);
                ShowObjectsDialog<IPyroObject> dlg = new ShowObjectsDialog<IPyroObject>((Window)app.getActiveFrame(), title, new PyroObjsList(domain, Intl.intl("Select Tagged Objects"), true, objs));
                dlg.doModeless();
            }
        }
    }

    private static String generateTitle(PyroMod domain, String prefix) {
        Set<String> selectedTagsSet = domain.getSelectionModel().flatten(Tag.class).stream().map(tag -> tag.getName()).collect(Collectors.toSet());
        String selectedTagsStr = TagsUtil.renderTagsAsString(selectedTagsSet);
        return String.format(Intl.intl("Tagged Objects: %1$s %2$s"), prefix, selectedTagsStr);
    }

    private static ShowTaggedObjsDialog.ICallback<IPyroObject, Tag> getDialogCallback(final PyroMod domain) {
        return new ShowTaggedObjsDialog.ICallback<IPyroObject, Tag>(){

            @Override
            public Collection<? extends IPyroObject> getAllTaggable() {
                return theUtil.filter(Hierarchy.flatten(domain.getMembers(), ITaggable.class), IPyroObject.class);
            }

            @Override
            public Set<? extends Tag> getTags(IPyroObject obj) {
                IPyroObject iPyroObject = obj;
                Objects.requireNonNull(iPyroObject);
                IPyroObject iPyroObject2 = iPyroObject;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ITaggable.class}, (Object)iPyroObject2, n)) {
                    case 0 -> {
                        ITaggable t = (ITaggable)((Object)iPyroObject2);
                        yield t.getTags();
                    }
                    default -> Collections.emptySet();
                };
            }
        };
    }

    @Override
    public void updateEnabled() {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        this.setEnabled(!pyMod.getSelectionModel().isEmpty(Tag.class));
    }
}

