/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.gui.PyroObjsList;
import pyrosim.gui.actions.ComponentSensitiveAction;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.util.LinkedIdentityHashSet;

public class ShowReferencingObjectsAction
extends ComponentSensitiveAction {
    private static final long serialVersionUID = 1L;

    public ShowReferencingObjectsAction() {
        super(Intl.intl("Show Referencing Objects..."));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ShowReferencingObjectsAction.showReferencingObjectsImpl(PyroSim.getApp());
    }

    @Override
    public void updateEnabled() {
        PyroMod mod = PyroSim.getApp().getMediator();
        this.setEnabled(!mod.getSelectionModel().isEmpty(IPyroObject.class));
    }

    public static void showReferencingObjectsImpl(PyroSim app) {
        PyroMod pyMod = app.getMediator();
        DepSnapshot deps = pyMod.getDependencies(new IPyroObject[0]);
        Predicate<Object> isTreeObjFilter = testObj -> {
            if (!(testObj instanceof IPyroObject)) {
                return false;
            }
            TVEntryPoint<Object> ep = TVEntryPoints.ep(testObj);
            if (ep == null) {
                return false;
            }
            return ep.showInTree(pyMod, testObj);
        };
        LinkedIdentityHashSet total = new LinkedIdentityHashSet();
        for (IPyroObject obj : pyMod.getSelectionModel().getSelected(IPyroObject.class)) {
            deps.findAllDependents(isTreeObjFilter, obj, total);
        }
        ShowObjectsDialog<IPyroObject> dlg = new ShowObjectsDialog<IPyroObject>((Window)app.getActiveFrame(), Intl.intl("Show Referencing Objects"), new PyroObjsList(pyMod, Intl.intl("Select Referencing Objects"), true, total));
        dlg.doModeless();
    }
}

