/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.ImportType;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.DeletePreserveTask;
import pyrosim.domain.tasks.ReplacePreserveTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.GenerateModelFromBIMDlg;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeneralPoly;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SplitProgress;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class GenerateModelFromBIMAction
extends guiAction {
    private static final long serialVersionUID = 1L;
    private final boolean d_context;
    private static final GenFromBIMOpts d_opts = new GenFromBIMOpts();

    public GenerateModelFromBIMAction(boolean context) {
        super(context ? Intl.intl("Generate Model from BIM selection") + "..." : Intl.intl("Generate Model from BIM") + "...");
        this.d_context = context;
        String tt = context ? Intl.intl("Generates model elements from selected BIM objects.") : Intl.intl("Generates model elements from all imported BIM objects.");
        this.putValue("ShortDescription", tt);
    }

    public void updateEnabled(PyroMod mediator, Events events, boolean selChanged) {
        if (this.d_context) {
            if (selChanged) {
                this.setEnabled(!this.getAffectedObjs(mediator).isEmpty());
            }
        } else {
            this.setEnabled(!this.getAffectedObjs(mediator).isEmpty());
        }
    }

    private Collection<Obstruction> getAffectedObjs(PyroMod mediator) {
        Predicate<Obstruction> conversionAllowed = obst -> obst.getImportType() != null && obst.getImportType() != ImportType.IGNORE;
        if (this.d_context) {
            return mediator.getSelectionModel().flatten(Obstruction.class, conversionAllowed);
        }
        return theUtil.filter(mediator.getObstructions().getDeepMembers(), Obstruction.class, conversionAllowed);
    }

    private Collection<Obstruction> getSkippedObjs(PyroMod mediator) {
        Predicate<Obstruction> skipped = obst -> obst.getImportType() == ImportType.IGNORE;
        if (this.d_context) {
            return mediator.getSelectionModel().flatten(Obstruction.class, skipped);
        }
        return theUtil.filter(mediator.getObstructions().getDeepMembers(), Obstruction.class, skipped);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroMod mediator = PyroSim.getApp().getMediator();
        Collection<Obstruction> bimObjects = this.getAffectedObjs(mediator);
        GenerateModelFromBIMDlg dlg = new GenerateModelFromBIMDlg(Application.getApp().getMainFrame(), d_opts);
        if (dlg.doModal() == 1) {
            dlg.applyOpts(d_opts);
            WarningReport<GenFromBIMWarning> report = new WarningReport<GenFromBIMWarning>(GenFromBIMWarning.class, new int[]{2, 3, 0}, new String[]{Intl.intl("Object"), Intl.intl("BIM Conversion Type"), Intl.intl("Reason")}, 0);
            Collection<Obstruction> skippedObjs = this.getSkippedObjs(mediator);
            if (skippedObjs.size() == 1) {
                report.addWarning(new GenFromBIMWarning(skippedObjs.iterator().next().getName(), ImportType.IGNORE, guiUtil.escapeHTML(Intl.intl("BIM Conversion Type set to <ignored>."))));
            } else if (!skippedObjs.isEmpty()) {
                report.addWarning(new GenFromBIMWarning(String.format(Intl.intl("%d Objects"), skippedObjs.size()), ImportType.IGNORE, guiUtil.escapeHTML(Intl.intl("BIM Conversion Type set to <ignored>."))));
            }
            LinkedIdentityHashMap createdFromSource = new LinkedIdentityHashMap();
            ArrayList allCreated = new ArrayList();
            Consumer<ITaskProgress> generateGeom = prog -> {
                try (SplitProgress splitProg = prog.split(bimObjects.size());){
                    for (Obstruction obst : bimObjects) {
                        Collection<? extends IPyroObject> created;
                        splitProg.incrementParent();
                        if (!d_opts.isComponentEnabled(obst.getImportType()) || (created = this.createConvertedObjs(obst, d_opts, reason -> report.addWarning(new GenFromBIMWarning(obst.getName(), obst.getImportType(), (String)reason)))) == null) continue;
                        createdFromSource.computeIfAbsent(obst, k -> new ArrayList()).addAll(created);
                        allCreated.addAll(created);
                    }
                }
            };
            Consumer<ITaskProgress> addToTree = prog -> {
                try (SplitProgress splitProg = prog.split(bimObjects.size());){
                    SelectTask tsk = new SelectTask(mediator, allCreated);
                    if (!d_opts.getKeepOriginal()) {
                        ArrayList<IPyroObject> originals = new ArrayList<IPyroObject>(createdFromSource.size());
                        ArrayList<IPyroObject> replacements = new ArrayList<IPyroObject>(createdFromSource.size());
                        ArrayList<IPyroObject> deletes = new ArrayList<IPyroObject>();
                        for (Map.Entry entry : createdFromSource.entrySet()) {
                            splitProg.incrementParent();
                            if (((List)entry.getValue()).isEmpty()) {
                                deletes.add((IPyroObject)entry.getKey());
                                continue;
                            }
                            if (((List)entry.getValue()).size() == 1) {
                                originals.add((IPyroObject)entry.getKey());
                                replacements.add((IPyroObject)((List)entry.getValue()).getFirst());
                                continue;
                            }
                            ModelComposite group = new ModelComposite(((Obstruction)entry.getKey()).getName());
                            group.addAll((Collection)entry.getValue());
                            originals.add((IPyroObject)entry.getKey());
                            replacements.add(group);
                        }
                        tsk.addTask(new ReplacePreserveTask(originals, replacements));
                        tsk.addTask(new DeletePreserveTask(deletes));
                    } else {
                        ModelComposite root = mediator.getObstructions();
                        ArrayList<IPyroObject> topLevel = new ArrayList<IPyroObject>();
                        LinkedIdentityHashMap<IPyroObject, ModelComposite> groupFromParent = new LinkedIdentityHashMap<IPyroObject, ModelComposite>();
                        groupFromParent.put(root, root);
                        for (Map.Entry entry : createdFromSource.entrySet()) {
                            ModelComposite newParent;
                            splitProg.incrementParent();
                            if (((List)entry.getValue()).size() == 1) {
                                newParent = GenerateModelFromBIMAction.duplicateBranch(root, (IPyroObject)entry.getKey(), topLevel, groupFromParent);
                                if (newParent == root) {
                                    topLevel.addAll((Collection)entry.getValue());
                                    continue;
                                }
                                newParent.addAll((Collection)entry.getValue());
                                continue;
                            }
                            if (((List)entry.getValue()).size() <= 1) continue;
                            newParent = GenerateModelFromBIMAction.duplicateBranch(root, (IPyroObject)entry.getKey(), topLevel, groupFromParent);
                            ModelComposite group = new ModelComposite(((Obstruction)entry.getKey()).getName());
                            group.addAll((Collection)entry.getValue());
                            if (newParent == root) {
                                topLevel.add(group);
                                continue;
                            }
                            newParent.add(group);
                        }
                        tsk.addTask(new AddTask((IPyroObject)root, topLevel));
                    }
                    mediator.getTaskManager().exec(tsk, Intl.intl("Generate Model from BIM"));
                }
            };
            TaskProgress progress = new TaskProgress();
            guiProgressMonitor progressMonitor = new guiProgressMonitor(Application.getApp().getMainFrame(), Intl.intl("Generating Model"), true, progress);
            try {
                progressMonitor.exec(() -> progress.split(generateGeom, addToTree));
            }
            catch (CancellationException ce) {
                return;
            }
            catch (ExecutionException ee) {
                throw new RuntimeException(ee);
            }
            if (!report.isEmpty()) {
                WarningDlg<GenFromBIMWarning> warningDlg = new WarningDlg<GenFromBIMWarning>(Application.getApp().getMainFrame(), Intl.intl("Did not Convert Some Imported Objects"), Intl.intl("The following imported objects could not be converted to simplified model types. Their originals have not been modified."), report, 1, WarningDlg.Severity.WARNING);
                warningDlg.doModal();
            }
        }
    }

    private static ModelComposite duplicateBranch(ModelComposite root, IPyroObject original, List<IPyroObject> topLevel, Map<IPyroObject, ModelComposite> groupFromParent) {
        IPyroObject parent = original.getParent();
        if (parent == root || parent == null) {
            return root;
        }
        if (groupFromParent.containsKey(parent)) {
            return groupFromParent.get(parent);
        }
        ModelComposite grandparent = GenerateModelFromBIMAction.duplicateBranch(root, parent, topLevel, groupFromParent);
        ModelComposite createdGroup = new ModelComposite();
        if (parent instanceof INamed) {
            INamed named = (INamed)parent;
            createdGroup.setName(named.getName());
        }
        groupFromParent.put(parent, createdGroup);
        if (grandparent == root) {
            topLevel.add(createdGroup);
        } else {
            grandparent.add(createdGroup);
        }
        return createdGroup;
    }

    private Collection<? extends IPyroObject> createConvertedObjs(Obstruction source, GenFromBIMOpts opts, Consumer<String> addWarning) {
        assert (source.getImportType() != ImportType.IGNORE);
        try {
            return switch (source.getImportType()) {
                default -> throw new MatchException(null, null);
                case ImportType.IGNORE, ImportType.REMOVE -> List.of();
                case ImportType.SLAB -> {
                    Pair<Surface, Color> surfaceColor = GenerateModelFromBIMAction.getMainSurfaceAndColor(source);
                    Collection<IGeomNode> slabGeoms = GenerateModelFromBIMAction.createSlabGeoms(source, addWarning);
                    if (slabGeoms == null) {
                        yield null;
                    }
                    yield GenerateModelFromBIMAction.createConvertedObstructions(source, slabGeoms, surfaceColor, false);
                }
                case ImportType.WALL -> {
                    Pair<Surface, Color> surfaceColor = GenerateModelFromBIMAction.getMainSurfaceAndColor(source);
                    Collection<IGeomNode> wallGeoms = GenerateModelFromBIMAction.createWallGeoms(source, addWarning);
                    if (wallGeoms == null) {
                        yield null;
                    }
                    yield GenerateModelFromBIMAction.createConvertedObstructions(source, wallGeoms, surfaceColor, false);
                }
                case ImportType.DOOR -> {
                    Pair<Surface, Color> surfaceColor = GenerateModelFromBIMAction.getMainSurfaceAndColor(source);
                    Predicate<Integer> allowIx = GenerateModelFromBIMAction.getVerticesOnSurface(source, (Surface)surfaceColor.v1);
                    Collection<IGeomNode> obstGeoms = GenerateModelFromBIMAction.createAABoxGeoms(source, allowIx, 0.0, addWarning);
                    if (obstGeoms == null) {
                        yield null;
                    }
                    Collection<IGeomNode> holeGeoms = GenerateModelFromBIMAction.createAABoxGeoms(source, allowIx, opts.getThickenDoors().getValue(NonSI.PERCENT) / 100.0, addWarning);
                    if (holeGeoms == null) {
                        yield null;
                    }
                    yield Stream.concat(GenerateModelFromBIMAction.createConvertedObstructions(source, obstGeoms, surfaceColor, true).stream(), GenerateModelFromBIMAction.createConvertedHoles(source, holeGeoms, (Color)surfaceColor.v2).stream()).collect(Collectors.toList());
                }
                case ImportType.WINDOW -> {
                    Pair<Surface, Color> surfaceColor = GenerateModelFromBIMAction.getMainSurfaceAndColor(source);
                    Predicate<Integer> allowIx = GenerateModelFromBIMAction.getVerticesOnSurface(source, (Surface)surfaceColor.v1);
                    Collection<IGeomNode> obstGeoms = GenerateModelFromBIMAction.createAABoxGeoms(source, allowIx, 0.0, addWarning);
                    if (obstGeoms == null) {
                        yield null;
                    }
                    Collection<IGeomNode> holeGeoms = GenerateModelFromBIMAction.createAABoxGeoms(source, allowIx, opts.getThickenWindows().getValue(NonSI.PERCENT) / 100.0, addWarning);
                    if (holeGeoms == null) {
                        yield null;
                    }
                    yield Stream.concat(GenerateModelFromBIMAction.createConvertedObstructions(source, obstGeoms, surfaceColor, true).stream(), GenerateModelFromBIMAction.createConvertedHoles(source, holeGeoms, (Color)surfaceColor.v2).stream()).collect(Collectors.toList());
                }
            };
        }
        catch (Exception e) {
            addWarning.accept(Intl.intl("Unknown error converting object."));
            return null;
        }
    }

    private static Collection<Obstruction> createConvertedObstructions(Obstruction source, Collection<IGeomNode> geoms, Pair<Surface, Color> surfaceColor, boolean disableHoles) {
        return geoms.stream().map(geom -> {
            Obstruction obst = (Obstruction)source.clone();
            obst.setGeom((IGeomNode)geom);
            obst.setSurfaces(new Surface[]{(Surface)surfaceColor.v1});
            obst.setColors((Color)surfaceColor.v2);
            obst.setBIMType(BIMType.UNKNOWN);
            obst.setObjectType(null);
            obst.setImportType(ImportType.IGNORE);
            if (disableHoles) {
                obst.setOptions(4, false);
            }
            return obst;
        }).collect(Collectors.toList());
    }

    private static Collection<Hole> createConvertedHoles(Obstruction source, Collection<IGeomNode> geoms, Color color) {
        return geoms.stream().map(geom -> {
            Hole hole = new Hole(source.getName(), (IGeomNode)geom);
            hole.setDesc(source.getDesc());
            hole.setColors(color);
            return hole;
        }).collect(Collectors.toList());
    }

    private static Collection<IGeomNode> createAABoxGeoms(Obstruction obst, Predicate<Integer> allowIx, double thickenPercent, Consumer<String> addWarning) {
        Mesh mesh = GenerateModelFromBIMAction.getAsMesh(obst.getGeom());
        if (mesh == null) {
            addWarning.accept(Intl.intl("Geometry is not a mesh."));
            return null;
        }
        Pair<AABox, Matrix4d> bounds = GenerateModelFromBIMAction.orientedBounds(mesh, allowIx, thickenPercent, addWarning);
        if (bounds == null) {
            return null;
        }
        AABoxGeom geom = new AABoxGeom(((AABox)bounds.v1).getMin(), ((AABox)bounds.v1).getMax());
        TransformInfo xform = new TransformInfo((Matrix4d)bounds.v2);
        return List.of(GeomNodeUtil.newNode(geom).transform(xform));
    }

    private static Collection<IGeomNode> createSlabGeoms(Obstruction obst, Consumer<String> addWarning) {
        Serializable loop;
        int m;
        Mesh mesh = GenerateModelFromBIMAction.getAsMesh(obst.getGeom());
        if (mesh == null) {
            addWarning.accept(Intl.intl("Geometry is not a mesh."));
            return null;
        }
        int nvpp = mesh.getNumVertsPerPrim();
        HashSet<Integer> lowerVertices = new HashSet<Integer>(mesh.vertices.length);
        double extrusionDist = 0.0;
        for (int i = 0; i < mesh.indices.length; i += nvpp) {
            int previx = mesh.indices[i + nvpp - 1];
            for (m = 0; m < nvpp; ++m) {
                int currix = mesh.indices[i + m];
                Point3d prevp = mesh.vertices[previx];
                Point3d currp = mesh.vertices[currix];
                if (Util3D.to2d(currp).epsilonEquals(Util3D.to2d(prevp), 1.0E-9)) {
                    if (currp.z > prevp.z) {
                        lowerVertices.add(previx);
                        extrusionDist = Math.max(extrusionDist, currp.z - prevp.z);
                    } else {
                        lowerVertices.add(currix);
                        extrusionDist = Math.max(extrusionDist, prevp.z - currp.z);
                    }
                }
                previx = currix;
            }
        }
        HashMap<UnorderedPair<Integer, Integer>, Integer> edgeCounts = new HashMap<UnorderedPair<Integer, Integer>, Integer>();
        block2: for (int i = 0; i < mesh.indices.length; i += nvpp) {
            for (m = 0; m < nvpp; ++m) {
                int ix = mesh.indices[i + m];
                if (!lowerVertices.contains(ix)) continue block2;
            }
            int previx = mesh.indices[i + nvpp - 1];
            for (int m2 = 0; m2 < nvpp; ++m2) {
                int currix = mesh.indices[i + m2];
                edgeCounts.merge(new UnorderedPair<Integer, Integer>(previx, currix), 1, (edge, count) -> count + 1);
                previx = currix;
            }
        }
        HashMap<Integer, UnorderedPair> outerEdges = new HashMap<Integer, UnorderedPair>(edgeCounts.size());
        for (Map.Entry pair : edgeCounts.entrySet()) {
            if ((Integer)pair.getValue() != 1) continue;
            UnorderedPair edge2 = (UnorderedPair)pair.getKey();
            outerEdges.merge((Integer)edge2.v1, new UnorderedPair<Integer, Integer>((Integer)edge2.v2, (Integer)edge2.v2), (prev, curr) -> new UnorderedPair<Integer, Integer>((Integer)prev.v1, (Integer)curr.v1));
            outerEdges.merge((Integer)edge2.v2, new UnorderedPair<Integer, Integer>((Integer)edge2.v1, (Integer)edge2.v1), (prev, curr) -> new UnorderedPair<Integer, Integer>((Integer)prev.v1, (Integer)curr.v1));
        }
        ArrayList<Pair> loops = new ArrayList<Pair>();
        while (!lowerVertices.isEmpty()) {
            Integer ix = (Integer)lowerVertices.iterator().next();
            lowerVertices.remove(ix);
            double perimeter = 0.0;
            loop = new ArrayList();
            loop.add(mesh.vertices[ix]);
            do {
                UnorderedPair pair;
                if ((pair = (UnorderedPair)outerEdges.get(ix)) == null) {
                    addWarning.accept(Intl.intl("Repeated edge in geometry."));
                    return null;
                }
                if (lowerVertices.contains(pair.v1)) {
                    perimeter += mesh.vertices[ix].distance(mesh.vertices[(Integer)pair.v1]);
                    ix = (Integer)pair.v1;
                    loop.add(mesh.vertices[ix]);
                    lowerVertices.remove(ix);
                    continue;
                }
                if (lowerVertices.contains(pair.v2)) {
                    perimeter += mesh.vertices[ix].distance(mesh.vertices[(Integer)pair.v2]);
                    ix = (Integer)pair.v2;
                    loop.add(mesh.vertices[ix]);
                    lowerVertices.remove(ix);
                    continue;
                }
                perimeter += mesh.vertices[ix].distance((Point3d)loop.getFirst());
                ix = null;
            } while (ix != null);
            loops.add(new Pair<Serializable, Double>(loop, perimeter));
        }
        int maxLoopIx = 0;
        int totalPoints = 0;
        for (int i = 0; i < loops.size(); ++i) {
            loop = (Pair)loops.get(i);
            totalPoints += ((List)((Pair)loop).v1).size();
            if (!((Double)((Pair)loop).v2 > (Double)((Pair)loops.get((int)maxLoopIx)).v2)) continue;
            maxLoopIx = i;
        }
        Pair tempLoop = (Pair)loops.getFirst();
        loops.set(0, (Pair)loops.get(maxLoopIx));
        loops.set(maxLoopIx, tempLoop);
        int[] loopOffsets = new int[loops.size()];
        ArrayList<Point3d> polyPoints = new ArrayList<Point3d>(totalPoints);
        for (int i = 0; i < loops.size(); ++i) {
            loopOffsets[i] = polyPoints.size();
            polyPoints.addAll((Collection)((Pair)loops.get((int)i)).v1);
        }
        GeneralPoly polygon = new GeneralPoly(polyPoints, loopOffsets);
        ExtrudedPoly extrusion = new ExtrudedPoly(polygon, new Vector3d(0.0, 0.0, extrusionDist));
        return List.of(GeomNodeUtil.newNode(extrusion));
    }

    private static Collection<IGeomNode> createWallGeoms(Obstruction obst, Consumer<String> addWarning) {
        Mesh mesh = GenerateModelFromBIMAction.getAsMesh(obst.getGeom());
        if (mesh == null) {
            addWarning.accept(Intl.intl("Geometry is not a mesh."));
            return null;
        }
        Pair<AABox, Matrix4d> bounds = GenerateModelFromBIMAction.orientedBounds(mesh, Predicates.alwaysTrue(), 0.0, addWarning);
        if (bounds == null) {
            return null;
        }
        if (((AABox)bounds.v1).getWidth() > ((AABox)bounds.v1).getDepth()) {
            Point3d p1 = ((AABox)bounds.v1).mmm();
            ((Matrix4d)bounds.v2).transform(p1);
            Point3d p2 = ((AABox)bounds.v1).Mmm();
            ((Matrix4d)bounds.v2).transform(p2);
            LineSeg curve = new LineSeg(p1, p2);
            WallGeom wallGeom = new WallGeom(curve, WallGeom.Alignment.LEFT, ((AABox)bounds.v1).getDepth(), ((AABox)bounds.v1).getHeight(), 0);
            return List.of(GeomNodeUtil.newNode(wallGeom));
        }
        Point3d p1 = ((AABox)bounds.v1).mMm();
        ((Matrix4d)bounds.v2).transform(p1);
        Point3d p2 = ((AABox)bounds.v1).mmm();
        ((Matrix4d)bounds.v2).transform(p2);
        LineSeg curve = new LineSeg(p1, p2);
        WallGeom wallGeom = new WallGeom(curve, WallGeom.Alignment.LEFT, ((AABox)bounds.v1).getWidth(), ((AABox)bounds.v1).getHeight(), 0);
        return List.of(GeomNodeUtil.newNode(wallGeom));
    }

    private static Mesh getAsMesh(IGeomNode geomNode) {
        IGeom localGeom = geomNode.flatten().getLocalGeom();
        if (localGeom instanceof IProxyGeom) {
            IProxyGeom proxy = (IProxyGeom)localGeom;
            localGeom = proxy.collapse().getBase();
        }
        if (localGeom instanceof Mesh) {
            Mesh mesh = (Mesh)localGeom;
            return mesh;
        }
        return null;
    }

    private static Pair<AABox, Matrix4d> orientedBounds(Mesh mesh, Predicate<Integer> allowIx, double thickenPercent, Consumer<String> addWarning) {
        ArrayList<Point2d> flattened = new ArrayList<Point2d>(mesh.vertices.length);
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        int nvpp = mesh.getNumVertsPerPrim();
        for (int i = 0; i < mesh.indices.length; ++i) {
            if (!allowIx.test(mesh.indices[i])) continue;
            Point3d point2 = mesh.vertices[mesh.indices[i]];
            minZ = Math.min(minZ, point2.z);
            maxZ = Math.max(maxZ, point2.z);
            flattened.add(new Point2d(point2.x, point2.y));
        }
        Point2d[] flatOBB = Util2D.getMinimumBoundingBox(flattened);
        int outOfLineEdges = 0;
        TriFunction<Point3d, Point2d, Point2d, Boolean> isOnSide = (point, start, end) -> {
            double distSq = Inter2D.distSqToNearestPtOnLineSeg(start.x, start.y, end.x, end.y, point.x, point.y);
            return distSq <= 1.0E-4;
        };
        for (int i = 0; i < mesh.indices.length; i += nvpp) {
            int prevIx = mesh.indices[i + nvpp - 1];
            for (int m = 0; m < nvpp; ++m) {
                int currIx = mesh.indices[i + m];
                if (allowIx.test(currIx) && allowIx.test(prevIx)) {
                    Point3d prevPt = mesh.vertices[prevIx];
                    Point3d currPt = mesh.vertices[currIx];
                    if (!(!(currPt.z >= maxZ) || !(prevPt.z >= maxZ) || isOnSide.apply(currPt, flatOBB[0], flatOBB[1]).booleanValue() || isOnSide.apply(currPt, flatOBB[1], flatOBB[2]).booleanValue() || isOnSide.apply(currPt, flatOBB[2], flatOBB[3]).booleanValue() || isOnSide.apply(currPt, flatOBB[3], flatOBB[0]).booleanValue() || isOnSide.apply(prevPt, flatOBB[0], flatOBB[1]).booleanValue() || isOnSide.apply(prevPt, flatOBB[1], flatOBB[2]).booleanValue() || isOnSide.apply(prevPt, flatOBB[2], flatOBB[3]).booleanValue() || isOnSide.apply(prevPt, flatOBB[3], flatOBB[0]).booleanValue())) {
                        ++outOfLineEdges;
                    }
                }
                prevIx = currIx;
            }
        }
        if (outOfLineEdges > 10) {
            addWarning.accept(Intl.intl("Object geometry is curved."));
            return null;
        }
        Vector2d extent1 = new Vector2d();
        extent1.sub(flatOBB[0], flatOBB[1]);
        Vector2d extent2 = new Vector2d();
        extent2.sub(flatOBB[1], flatOBB[2]);
        double width = extent1.length();
        double depth = extent2.length();
        double height = maxZ - minZ;
        Vector3d thicknessAdded = width < depth && width < height ? new Vector3d(width * thickenPercent, 0.0, 0.0) : (depth < width && depth < height ? new Vector3d(0.0, depth * thickenPercent, 0.0) : new Vector3d(0.0, 0.0, height * thickenPercent));
        AABox box = new AABox(new Point3d(Util3D.negate(thicknessAdded)), Util3D.add(new Point3d(width, depth, height), (Tuple3d)thicknessAdded));
        extent1.normalize();
        extent2.normalize();
        Vector3d basisX = new Vector3d(extent1.x, extent1.y, 0.0);
        Vector3d basisY = new Vector3d(extent2.x, extent2.y, 0.0);
        Vector3d basisZ = new Vector3d(0.0, 0.0, 1.0);
        Matrix3d rotMatrix = new Matrix3d();
        rotMatrix.setColumn(0, basisX);
        rotMatrix.setColumn(1, basisY);
        rotMatrix.setColumn(2, basisZ);
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        xform.setRotation(rotMatrix);
        Vector3d offset = new Vector3d(flatOBB[0].x, flatOBB[0].y, 0.0);
        offset.add(Util3D.scale(basisX, -width));
        offset.add(Util3D.scale(basisY, -depth));
        offset.add(Util3D.scale(basisZ, minZ));
        xform.setTranslation(offset);
        return new Pair<AABox, Matrix4d>(box, xform);
    }

    private static Pair<Surface, Color> getMainSurfaceAndColor(Obstruction obst) {
        Surface[] surfaces = obst.getSurfaces();
        Color[] colors = obst.getColors();
        if (surfaces.length == 1 && colors.length == 1) {
            return new Pair<Surface, Color>(surfaces[0], colors[0]);
        }
        IdentityHashMap surfaceAreas = new IdentityHashMap();
        HashMap colorAreas = new HashMap();
        BiConsumer<Integer, Double> addArea = surfaces.length > 1 && colors.length > 1 ? (fix, area) -> {
            surfaceAreas.merge(surfaces[fix], area, Double::sum);
            colorAreas.merge(colors[fix], area, Double::sum);
        } : (surfaces.length > 1 ? (fix, area) -> surfaceAreas.merge(surfaces[fix], area, Double::sum) : (fix, area) -> colorAreas.merge(colors[fix], area, Double::sum));
        AtomicInteger faceIx = new AtomicInteger();
        obst.getGeom().getAll((obj, ctmt) -> {
            if (obj.getPrimType() == 1) {
                int fix = faceIx.getAndIncrement();
                if (obj instanceof IPolygon) {
                    IPolygon polygon = (IPolygon)obj;
                    addArea.accept(fix, polygon.getArea());
                }
            }
        });
        Surface maxSurface = surfaces[0];
        double maxSurfaceArea = 0.0;
        for (Map.Entry surfaceArea : surfaceAreas.entrySet()) {
            if (!((Double)surfaceArea.getValue() > maxSurfaceArea)) continue;
            maxSurfaceArea = (Double)surfaceArea.getValue();
            maxSurface = (Surface)surfaceArea.getKey();
        }
        Color maxColor = colors[0];
        double maxColorArea = 0.0;
        for (Map.Entry colorArea : colorAreas.entrySet()) {
            if (!((Double)colorArea.getValue() > maxColorArea)) continue;
            maxColorArea = (Double)colorArea.getValue();
            maxColor = (Color)colorArea.getKey();
        }
        return new Pair<Surface, Color>(maxSurface, maxColor);
    }

    private static Predicate<Integer> getVerticesOnSurface(Obstruction obst, Surface surface) {
        Mesh mesh = GenerateModelFromBIMAction.getAsMesh(obst.getGeom());
        if (mesh == null) {
            return Predicates.alwaysFalse();
        }
        Surface[] surfaces = obst.getSurfaces();
        if (surfaces.length == 1) {
            return Predicates.always(surfaces[0] == surface);
        }
        HashSet<Integer> vertices = new HashSet<Integer>();
        int nvpp = mesh.getNumVertsPerPrim();
        for (int i = 0; i < mesh.indices.length; i += nvpp) {
            if (surfaces[i / nvpp] != surface) continue;
            for (int m = 0; m < nvpp; ++m) {
                int ix = mesh.indices[i + m];
                vertices.add(ix);
            }
        }
        return vertices::contains;
    }

    public static class GenFromBIMOpts {
        private boolean d_keepOriginal = false;
        private final Set<ImportType> d_enabledComponents = new HashSet<ImportType>(Arrays.asList(ImportType.values()));
        private UnitDouble d_thickenDoors = new UnitDouble(500.0, NonSI.PERCENT);
        private UnitDouble d_thickenWindows = new UnitDouble(500.0, NonSI.PERCENT);

        public boolean getKeepOriginal() {
            return this.d_keepOriginal;
        }

        public void setKeepOriginal(boolean value) {
            this.d_keepOriginal = value;
        }

        public boolean isComponentEnabled(ImportType type) {
            return this.d_enabledComponents.contains((Object)type);
        }

        public void setComponentEnabled(ImportType type, boolean enabled) {
            if (enabled) {
                this.d_enabledComponents.add(type);
            } else {
                this.d_enabledComponents.remove((Object)type);
            }
        }

        public UnitDouble getThickenDoors() {
            return this.d_thickenDoors;
        }

        public void setThickenDoors(UnitDouble thickenDoors) {
            this.d_thickenDoors = thickenDoors;
        }

        public UnitDouble getThickenWindows() {
            return this.d_thickenWindows;
        }

        public void setThickenWindows(UnitDouble thickenWindows) {
            this.d_thickenWindows = thickenWindows;
        }
    }

    private static class GenFromBIMWarning
    extends Warning {
        public static final int WARNINGINFO_OBJECT = 2;
        public static final int WARNINGINFO_IMPORT_TYPE = 3;
        private final String d_object;
        private final ImportType d_importType;

        public GenFromBIMWarning(String object, ImportType importType, String reason) {
            super(reason, "");
            this.d_object = object;
            this.d_importType = importType;
        }

        @Override
        public Comparable getWarningInfo(int type) {
            return switch (type) {
                case 2 -> guiUtil.escapeHTML(this.d_object);
                case 3 -> guiUtil.escapeHTML(this.d_importType.name);
                default -> super.getWarningInfo(type);
            };
        }
    }
}

