/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.output.Slice;
import pyrosim.gui.actions.ARunFDSValidation;

public class FlameConditionValidation
extends ARunFDSValidation {
    public FlameConditionValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        if (!this.d_pyroMod.getReactions().getActiveReactions().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IPyroObject> flameConObjs = new HashSet<IPyroObject>();
        for (Surface surf : this.d_pyroMod.getSurfaceMgr().flatten()) {
            if (!(surf.getSurfDesc() instanceof BurnerSurfDesc) && !(surf.getSurfDesc() instanceof GeneralSurfDesc)) continue;
            flameConObjs.add(surf);
        }
        for (IDevice devc : this.d_pyroMod.getDevices().flatten()) {
            if (devc instanceof SmokeDetector || devc instanceof Aspirator || devc instanceof AspiratorSampler) {
                flameConObjs.add(devc);
                continue;
            }
            if (!(devc instanceof AMeasuringDevc) || !((AMeasuringDevc)devc).getQuantity().get().mixFracOnly) continue;
            flameConObjs.add(devc);
        }
        for (Slice slcf : this.d_pyroMod.getSlcfList().flatten()) {
            if (!slcf.getQuantity().get().mixFracOnly) continue;
            flameConObjs.add(slcf);
        }
        for (Slice slcf : this.d_pyroMod.getSlcf3dList().flatten()) {
            if (!slcf.getQuantity().get().mixFracOnly) continue;
            flameConObjs.add(slcf);
        }
        return flameConObjs;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("A reaction (&REAC) must be defined in order to simulate \nburning in FDS. This model currently includes objects that\nrequire a reaction, but no reaction has been specified.\n\nClick OK to select objects that require an active reaction.\n\nClick Ignore if you have defined a reaction in the Additional\nRecords section.");
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Flame Condition Validation");
    }
}

