/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.gui.actions.ARunFDSValidation;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class ExposedOverlapValidation
extends ARunFDSValidation {
    private final RefinementZoneUtil.RefinementResults d_refinementResults;

    public ExposedOverlapValidation(PyroSim app, PyroMod mod, RefinementZoneUtil.RefinementResults refinementResults) {
        super(app, mod);
        this.d_refinementResults = refinementResults;
    }

    public static Collection<IPyroObject> getExposedOverlapObst(PyroSim app, PyroMod pyMod, RefinementZoneUtil.RefinementResults refinementResults) {
        double tol = 1.0E-6;
        ArrayDeque<IObstruction> exposed = new ArrayDeque<IObstruction>();
        block2: for (IObstruction obst2 : pyMod.getObstructions().flatten(IObstruction.class, obst -> obst.isEnabled())) {
            for (Surface surf : obst2.getSurfaces()) {
                if (!(surf.getSurfDesc() instanceof LayeredSurfDesc)) continue;
                SurfComposition surfcomp = ((LayeredSurfDesc)surf.getSurfDesc()).d_surfComp;
                if (!(surfcomp.d_backing instanceof Backing.Exposed)) continue;
                exposed.add(obst2);
                continue block2;
            }
        }
        if (exposed.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Deque enabledMeshes = refinementResults.streamLeaves().collect(Collectors.toCollection(ArrayDeque::new));
        ArrayDeque<AABox> dangerZones = new ArrayDeque<AABox>();
        while (!enabledMeshes.isEmpty()) {
            Grid g1 = (Grid)enabledMeshes.removeFirst();
            for (Grid g2 : enabledMeshes) {
                AABox adjRegion = ExposedOverlapValidation.getAdjacentRegion(g1, g2);
                if (adjRegion == null) continue;
                dangerZones.add(adjRegion);
            }
        }
        if (dangerZones.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<IPyroObject> warnFor = new HashSet<IPyroObject>();
        for (IObstruction exposedObst : exposed) {
            AABox exposedObstBB = exposedObst.getBounds();
            for (AABox zone : dangerZones) {
                if (!exposedObstBB.intersects(zone, 1.0E-6)) continue;
                try {
                    exposedObst.getGeom().find(zone, (foundPrim, ctmt) -> {
                        if (zone.test((AABox)foundPrim.prim.getBoundingBox((AABox)new AABox())).positive) {
                            warnFor.add(exposedObst);
                            throw new CancellationException();
                        }
                    });
                }
                catch (CancellationException cancellationException) {}
            }
        }
        return warnFor;
    }

    private static AABox getAdjacentRegion(Grid g1, Grid g2) {
        AABox bExpanded;
        AABox aExpanded;
        double tol = 1.0E-6;
        if (g1.getBounds().test(g2.getBounds(), 1.0E-6) == Containment.OUTSIDE) {
            return null;
        }
        Pair<Point3d, Point3d> overlap = ExposedOverlapValidation.getOverlap(g1, g2);
        Integer X = 0;
        Integer Y = 1;
        Integer Z = 2;
        ArrayList<Pair<Integer, Double>> overlaps = new ArrayList<Pair<Integer, Double>>();
        overlaps.add(new Pair<Integer, Double>(X, ((Point3d)overlap.v2).x - ((Point3d)overlap.v1).x));
        overlaps.add(new Pair<Integer, Double>(Y, ((Point3d)overlap.v2).y - ((Point3d)overlap.v1).y));
        overlaps.add(new Pair<Integer, Double>(Z, ((Point3d)overlap.v2).z - ((Point3d)overlap.v1).z));
        overlaps.sort(new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> o1, Pair<Integer, Double> o2) {
                return Double.compare((Double)o1.v2, (Double)o2.v2);
            }
        });
        int adjacency = (Integer)((Pair)overlaps.get((int)0)).v1;
        if (adjacency == X) {
            if (((Point3d)overlap.v2).y - ((Point3d)overlap.v1).y < 1.0E-6 || ((Point3d)overlap.v2).z - ((Point3d)overlap.v1).z < 1.0E-6) {
                return null;
            }
            a = g1.getBounds().getCenter().x < g2.getBounds().getCenter().x ? g1 : g2;
            Grid b = g1.getBounds().getCenter().x < g2.getBounds().getCenter().x ? g2 : g1;
            List<Double> linesM1 = ExposedOverlapValidation.getLinesInRange(a.getYLinePositions(), ((Point3d)overlap.v1).y, ((Point3d)overlap.v2).y, 1.0E-6);
            List<Double> linesM2 = ExposedOverlapValidation.getLinesInRange(b.getYLinePositions(), ((Point3d)overlap.v1).y, ((Point3d)overlap.v2).y, 1.0E-6);
            List<Double> linesN1 = ExposedOverlapValidation.getLinesInRange(a.getZLinePositions(), ((Point3d)overlap.v1).z, ((Point3d)overlap.v2).z, 1.0E-6);
            List<Double> linesN2 = ExposedOverlapValidation.getLinesInRange(b.getZLinePositions(), ((Point3d)overlap.v1).z, ((Point3d)overlap.v2).z, 1.0E-6);
            if (ExposedOverlapValidation.getLinesMatch(linesM1, linesM2, 1.0E-6) && ExposedOverlapValidation.getLinesMatch(linesN1, linesN2, 1.0E-6)) {
                return null;
            }
            aExpanded = new AABox(a.getBounds().getMin(), new Point3d(a.getBounds().getMaxX() + b.getXDivisions()[0].get(SI.METER), a.getBounds().getMaxY(), a.getBounds().getMaxZ()));
            bExpanded = new AABox(new Point3d(b.getBounds().getMinX() - a.getXDivisions()[a.getXDivisions().length - 1].get(SI.METER), b.getBounds().getMinY(), b.getBounds().getMinZ()), b.getBounds().getMax());
        } else if (adjacency == Y) {
            if (((Point3d)overlap.v2).x - ((Point3d)overlap.v1).x < 1.0E-6 || ((Point3d)overlap.v2).z - ((Point3d)overlap.v1).z < 1.0E-6) {
                return null;
            }
            a = g1.getBounds().getCenter().y < g2.getBounds().getCenter().y ? g1 : g2;
            Grid b = g1.getBounds().getCenter().y < g2.getBounds().getCenter().y ? g2 : g1;
            List<Double> linesM1 = ExposedOverlapValidation.getLinesInRange(a.getXLinePositions(), ((Point3d)overlap.v1).x, ((Point3d)overlap.v2).x, 1.0E-6);
            List<Double> linesM2 = ExposedOverlapValidation.getLinesInRange(b.getXLinePositions(), ((Point3d)overlap.v1).x, ((Point3d)overlap.v2).x, 1.0E-6);
            List<Double> linesN1 = ExposedOverlapValidation.getLinesInRange(a.getZLinePositions(), ((Point3d)overlap.v1).z, ((Point3d)overlap.v2).z, 1.0E-6);
            List<Double> linesN2 = ExposedOverlapValidation.getLinesInRange(b.getZLinePositions(), ((Point3d)overlap.v1).z, ((Point3d)overlap.v2).z, 1.0E-6);
            if (ExposedOverlapValidation.getLinesMatch(linesM1, linesM2, 1.0E-6) && ExposedOverlapValidation.getLinesMatch(linesN1, linesN2, 1.0E-6)) {
                return null;
            }
            aExpanded = new AABox(a.getBounds().getMin(), new Point3d(a.getBounds().getMaxX(), a.getBounds().getMaxY() + b.getYDivisions()[0].get(SI.METER), a.getBounds().getMaxZ()));
            bExpanded = new AABox(new Point3d(b.getBounds().getMinX(), b.getBounds().getMinY() - a.getYDivisions()[a.getYDivisions().length - 1].get(SI.METER), b.getBounds().getMinZ()), b.getBounds().getMax());
        } else if (adjacency == Z) {
            if (((Point3d)overlap.v2).x - ((Point3d)overlap.v1).x < 1.0E-6 || ((Point3d)overlap.v2).y - ((Point3d)overlap.v1).y < 1.0E-6) {
                return null;
            }
            a = g1.getBounds().getCenter().z < g2.getBounds().getCenter().z ? g1 : g2;
            Grid b = g1.getBounds().getCenter().z < g2.getBounds().getCenter().z ? g2 : g1;
            List<Double> linesM1 = ExposedOverlapValidation.getLinesInRange(a.getXLinePositions(), ((Point3d)overlap.v1).x, ((Point3d)overlap.v2).x, 1.0E-6);
            List<Double> linesM2 = ExposedOverlapValidation.getLinesInRange(b.getXLinePositions(), ((Point3d)overlap.v1).x, ((Point3d)overlap.v2).x, 1.0E-6);
            List<Double> linesN1 = ExposedOverlapValidation.getLinesInRange(a.getYLinePositions(), ((Point3d)overlap.v1).y, ((Point3d)overlap.v2).y, 1.0E-6);
            List<Double> linesN2 = ExposedOverlapValidation.getLinesInRange(b.getYLinePositions(), ((Point3d)overlap.v1).y, ((Point3d)overlap.v2).y, 1.0E-6);
            if (ExposedOverlapValidation.getLinesMatch(linesM1, linesM2, 1.0E-6) && ExposedOverlapValidation.getLinesMatch(linesN1, linesN2, 1.0E-6)) {
                return null;
            }
            aExpanded = new AABox(a.getBounds().getMin(), new Point3d(a.getBounds().getMaxX(), a.getBounds().getMaxY(), a.getBounds().getMaxZ() + b.getZDivisions()[0].get(SI.METER)));
            bExpanded = new AABox(new Point3d(b.getBounds().getMinX(), b.getBounds().getMinY(), b.getBounds().getMinZ() - a.getZDivisions()[a.getZDivisions().length - 1].get(SI.METER)), b.getBounds().getMax());
        } else {
            throw new IllegalArgumentException("Error calculating mesh adjacency.");
        }
        AABox intersection = new AABox(Math.max(aExpanded.getMinX(), bExpanded.getMinX()), Math.max(aExpanded.getMinY(), bExpanded.getMinY()), Math.max(aExpanded.getMinZ(), bExpanded.getMinZ()), Math.min(aExpanded.getMaxX(), bExpanded.getMaxX()), Math.min(aExpanded.getMaxY(), bExpanded.getMaxY()), Math.min(aExpanded.getMaxZ(), bExpanded.getMaxZ()));
        return intersection.isValid() ? intersection : null;
    }

    private static List<Double> getLinesInRange(UnitDouble[] lines, double min, double max, double tol) {
        ArrayList<Double> linesInRange = new ArrayList<Double>();
        for (UnitDouble line : lines) {
            Double value = line.get(SI.METER);
            if (!(min - tol <= value) || !(value <= max + tol)) continue;
            linesInRange.add(value);
        }
        return linesInRange;
    }

    private static boolean getLinesMatch(List<Double> aLines, List<Double> bLines, double tol) {
        if (aLines.size() != bLines.size()) {
            return false;
        }
        int n = aLines.size();
        for (int i = 0; i < n; ++i) {
            if (!(tol < Math.abs(aLines.get(i) - bLines.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static Pair<Point3d, Point3d> getOverlap(Grid g1, Grid g2) {
        Point3d maxOfMins = new Point3d(Math.max(g1.getMinPoint().x(SI.METER), g2.getMinPoint().x(SI.METER)), Math.max(g1.getMinPoint().y(SI.METER), g2.getMinPoint().y(SI.METER)), Math.max(g1.getMinPoint().z(SI.METER), g2.getMinPoint().z(SI.METER)));
        Point3d minOfMaxs = new Point3d(Math.min(g1.getMaxPoint().x(SI.METER), g2.getMaxPoint().x(SI.METER)), Math.min(g1.getMaxPoint().y(SI.METER), g2.getMaxPoint().y(SI.METER)), Math.min(g1.getMaxPoint().z(SI.METER), g2.getMaxPoint().z(SI.METER)));
        return new Pair<Point3d, Point3d>(maxOfMins, minOfMaxs);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        return ExposedOverlapValidation.getExposedOverlapObst(this.d_app, this.d_pyroMod, this.d_refinementResults);
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = String.format(Intl.intl("Obstructions that use a layered surface with the backing type EXPOSED\ncan only occupy the boundary cells of a mesh when all adjacent mesh\ncells are one-to-one. This model contains %d obstructions that violate\nthis requirement.\n\nPress OK to select affected obstructions."), issueSize);
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Exposed Overlap Validation");
    }
}

