/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import pyrosim.Intl;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.gui.actions.ExportMetaAction;
import pyrosim.io.IOUtil;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;

public class ExportPyroViewsAction
extends ExportMetaAction {
    private static final long serialVersionUID = 1L;
    public static final String EXT = "views";

    public ExportPyroViewsAction() {
        super(Intl.intl("PyroSim Viewpoints..."), Intl.intl("Exports View Data for 3D Results"), Intl.intl("Results View Files"), EXT, (app, file) -> {
            try {
                ExportPyroViewsAction.writeViewsFile(file, app.getMediator().getViews());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void writeViewsFile(File viewsFile, ViewList views) throws IOException {
        try (PrintWriter fWrite = IOUtil.newPrintWriterUTF8(viewsFile);){
            JSONArray objects = ExportPyroViewsAction.toJSONArray(views);
            fWrite.println(objects.toJSONString());
        }
    }

    private static JSONArray toJSONArray(ViewList views) {
        JSONArray objects = new JSONArray();
        for (View view : views.flatten()) {
            ExportPyroViewsAction.toJSON(view).ifPresent(jsonView -> objects.add(jsonView));
        }
        return objects;
    }

    private static Optional<JSONObject> toJSON(View view) {
        SectionBox sb;
        JSONObject obj = new JSONObject();
        obj.put("type", "camera_view");
        obj.put("name", view.getName());
        CameraState cs = view.get(View.PROP_CAMERA);
        if (cs != null) {
            JSONObject state = ExportPyroViewsAction.toJSON(cs.getCameraRecord());
            obj.put("state", state);
        }
        if ((sb = view.get(View.PROP_SECTION_BOX)) != null) {
            JSONArray sectionBox = ExportPyroViewsAction.toJSON(view.get(View.PROP_SECTION_BOX));
            obj.put("sectionBox", sectionBox);
        }
        if (cs == null && sb == null) {
            return Optional.empty();
        }
        return Optional.of(obj);
    }

    private static JSONArray toJSON(SectionBox section) {
        JSONArray sbArray = new JSONArray();
        IGeom geom = section.getGeom().flatten().getLocalGeom();
        List<IPlanarFace> faces = GeomUtil.explode(geom, IPlanarFace.class);
        for (IPlanarFace face : faces) {
            sbArray.add(ExportPyroViewsAction.toJSON(face));
        }
        return sbArray;
    }

    private static JSONObject toJSON(IPlanarFace face) {
        JSONObject jsnode = new JSONObject();
        Plane3d p3d = face.getPlane(true);
        jsnode.put("x", p3d.x);
        jsnode.put("y", p3d.y);
        jsnode.put("z", p3d.z);
        jsnode.put("w", p3d.w);
        return jsnode;
    }

    private static JSONObject toJSON(CameraRecord cr) {
        JSONObject jsnode = new JSONObject();
        jsnode.put("loc", ExportPyroViewsAction.toArray(cr.loc));
        jsnode.put("ref", ExportPyroViewsAction.toArray(cr.ref));
        jsnode.put("up", ExportPyroViewsAction.toArray(cr.up));
        jsnode.put("zoom", cr.zoom);
        jsnode.put("zoomloc", ExportPyroViewsAction.toArray(cr.zoomLoc));
        jsnode.put("near", cr.near);
        jsnode.put("far", cr.far);
        if (cr.frustum instanceof PerspectiveCamera.FrustumRecord) {
            PerspectiveCamera.FrustumRecord pfr = (PerspectiveCamera.FrustumRecord)cr.frustum;
            jsnode.put("fov", pfr.fov);
        } else {
            jsnode.put("fov", Math.toRadians(45.0));
        }
        return jsnode;
    }
}

