/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.function.BiConsumer;
import javafx.stage.FileChooser;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import org.json.simple.JSONArray;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiUtil;

public class ExportMetaAction
extends guiAction {
    private static final long serialVersionUID = 1L;
    private final String EXT;
    private final String d_type;
    private final BiConsumer<PyroSim, File> d_writeFile;

    public ExportMetaAction(String name, String desc, String type, String ext, BiConsumer<PyroSim, File> writeFile) {
        super(name);
        this.putValue("ShortDescription", desc);
        this.EXT = ext;
        this.d_type = type;
        this.d_writeFile = writeFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroSim app = PyroSim.getApp();
        File suggestFile = this.getSuggestFile(app.getMediator(), app.getFilename());
        guiJFXFileChooser chooser = new guiJFXFileChooser(suggestFile.getName(), PyroPrefs.get(PyroPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(this.d_type, "*." + this.EXT));
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        PyroPrefs.set(PyroPrefs.OPEN_DIR_PREF, f.getParent());
        this.writeFile(app, f);
    }

    private File getSuggestFile(PyroMod pyMod, String psmSaveName) {
        if (psmSaveName == null) {
            return new File(Intl.intl("untitled." + this.EXT));
        }
        File pyrofile = new File(psmSaveName);
        String defScenario = FDSRenderer.getDefaultScenarioNameForChid(pyMod.getScenarios());
        String chidUtf8 = FDSRenderer.getChidUtf8(pyrofile.getName(), defScenario);
        File resultsDir = new File(pyrofile.getParentFile(), chidUtf8);
        String viewFN = String.format("%s.%s", chidUtf8, this.EXT);
        if (resultsDir.exists()) {
            return new File(resultsDir, viewFN);
        }
        return new File(pyrofile.getParentFile(), viewFN);
    }

    private boolean writeFile(PyroSim app, File file) {
        try {
            this.d_writeFile.accept(app, file);
            return true;
        }
        catch (Throwable e) {
            guiUtil.showError(app, Intl.intl("File Error"), String.format(Intl.intl("Could not write file: %s"), file.getAbsolutePath()), e);
            return false;
        }
    }

    protected static JSONArray toArray(Tuple3d t) {
        JSONArray arr = new JSONArray();
        arr.add(t.x);
        arr.add(t.y);
        arr.add(t.z);
        return arr;
    }

    protected static JSONArray toArray(Tuple2d t) {
        JSONArray arr = new JSONArray();
        arr.add(t.x);
        arr.add(t.y);
        return arr;
    }

    protected static JSONArray toArray(Color t) {
        JSONArray arr = new JSONArray();
        float[] comps = new float[4];
        t.getComponents(comps);
        arr.add(Float.valueOf(comps[0]));
        arr.add(Float.valueOf(comps[1]));
        arr.add(Float.valueOf(comps[2]));
        arr.add(Float.valueOf(comps[3]));
        return arr;
    }

    protected static JSONArray toArray(Matrix4d mat) {
        JSONArray arr = new JSONArray();
        double[] row = new double[4];
        for (int m = 0; m < 4; ++m) {
            mat.getRow(m, row);
            arr.add(row[0]);
            arr.add(row[1]);
            arr.add(row[2]);
            arr.add(row[3]);
        }
        return arr;
    }
}

