/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.gui.actions.ARunFDSValidation;

public class DomainSealedValidation
extends ARunFDSValidation {
    private static Predicate<IPyroObject> ENABLED = obj -> obj.isEnabled();

    public DomainSealedValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        for (Vent vent : this.d_pyroMod.getObstructions().flatten(Vent.class, ENABLED)) {
            Surface surf = vent.getSurface();
            if (!DomainSealedValidation.isOpenSurfDesc(surf.getSurfDesc())) continue;
            return Collections.emptyList();
        }
        for (HvacNode hvacNode : this.d_pyroMod.getObstructions().flatten(HvacNode.class, ENABLED)) {
            if (!hvacNode.isEnabled() || hvacNode.getNodeType() != HvacNode.NodeType.AMBIENT) continue;
            return Collections.emptyList();
        }
        return Arrays.asList(this.d_pyroMod);
    }

    private static boolean isOpenSurfDesc(ISurfDesc surfDesc) {
        PredefSurf type;
        return surfDesc instanceof SurfDescStatic && (PredefSurf.OPEN == (type = ((SurfDescStatic)surfDesc).getPredefType()) || PredefSurf.PERIODIC == type || PredefSurf.PERIODIC_FLOW_ONLY == type);
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("This model is not connected to an ambient pressure boundary condition. \nThe default mesh boundary is a solid wall and, without access to an \nexterior opening, simulations may fail due to numerical instability. \n\nAdd OPEN vents or ambient HVAC nodes to resolve this issue.\n\nClick OK to abort simulation and return to PyroSim.");
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Domain Sealed Validation");
    }
}

