/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IImprintable;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.devices.DevcEditorFactory;
import pyrosim.gui.devices.DeviceDlg;
import pyrosim.gui.devices.HvacDevcEditor;
import pyrosim.gui.devices.IDevcEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashMap;

public class DeviceActions {
    private static <T extends IDevice> DeviceDlg<T> newDevcDlg(Class<T> type, Function<PyroMod, ? extends IDevcEditor<T>> edFactory) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        IDevcEditor<T> editor = edFactory.apply(pyMod);
        if (editor == null) {
            System.err.println("No device editor for " + String.valueOf(type));
            return null;
        }
        return new DeviceDlg<T>(pySim.getActiveFrame(), pyMod, type, editor);
    }

    public static <T extends IDevice> void editDevice(Collection<T> objs, int hvacType) {
        PyroSim pySim = PyroSim.getApp();
        ArrayList<IDevice> frozenView = new ArrayList<IDevice>(objs);
        Class<? extends IDevice> clazz = DevcEditorFactory.getEditorType(frozenView);
        if (clazz == null) {
            JOptionPane.showMessageDialog(pySim.getActiveFrame(), Intl.intl("No common editor for device selection."), Intl.intl("Multiple Devices"), 1);
            return;
        }
        if (clazz == StatisticsDevc.class && objs.size() > 1) {
            JOptionPane.showMessageDialog(pySim.getActiveFrame(), Intl.intl("Multiple device edit is not available for statistics devices."), Intl.intl("Multiple Device Edit Unavailable"), 1);
            return;
        }
        DeviceDlg<? extends IDevice> dlg = DeviceActions.newDevcDlg(clazz, mod -> {
            IDevcEditor editor = DevcEditorFactory.create(mod, clazz, IDevcEditor.Mode.EDIT, hvacType);
            return editor;
        });
        if (dlg == null) {
            return;
        }
        PyroMod pyMod = pySim.getMediator();
        dlg.load(frozenView);
        if (dlg.doModal() == 1) {
            CompositeTask<PyroMod> editTask = new CompositeTask<PyroMod>(pyMod);
            LinkedIdentityHashMap imprintableObjs = new LinkedIdentityHashMap();
            frozenView.forEach(device -> imprintableObjs.put(device, (IDevice)device.getRestoreObject()));
            dlg.save(imprintableObjs.values());
            editTask.addTasks(IImprintable.generateTasks(imprintableObjs));
            editTask.addTask(dlg.getBundledUpdates(pyMod, frozenView));
            editTask.addTask(new SelectTask(pyMod, frozenView));
            pyMod.getTaskManager().exec(editTask, Intl.intl("Edit Device"));
        }
    }

    public static class NewHvacDeviceAction
    extends NewDeviceAction<HvacDevice> {
        private static final long serialVersionUID = -7933430547169486290L;
        private final int d_hvacType;

        public NewHvacDeviceAction(String title, Icon icon, int hvacType) {
            super(title, HvacDevice.class, icon, mod -> DevcEditorFactory.create(mod, HvacDevice.class, IDevcEditor.Mode.CREATE, hvacType));
            this.d_hvacType = hvacType;
            this.setEnabledUpdator(() -> {
                QuantityType qt;
                Predicate<Quantity> filter;
                Optional<PyroSim> appOpt = PyroSim.getAppOpt();
                if (!appOpt.isPresent()) {
                    return false;
                }
                PyroMod pyMod = appOpt.get().getMediator();
                List<IQuantity> availQuants = QuantityUtil.generateAllQuantities(pyMod, filter = HvacDevcEditor.getQuantityFilter(qt = HvacDevcEditor.getTypeAsQuantityType(this.d_hvacType)), false);
                return !availQuants.isEmpty();
            });
        }
    }

    public static class NewDeviceAction<T extends IDevice>
    extends guiAction {
        private static final long serialVersionUID = -2753847817063318197L;
        private final Class<T> d_class;
        private final Function<PyroMod, ? extends IDevcEditor<T>> d_editor;

        public NewDeviceAction(String title, Class<T> type) {
            this(title, type, null);
        }

        public NewDeviceAction(String title, Class<T> type, Icon icon) {
            this(title, type, icon, mod -> {
                IDevcEditor editor = DevcEditorFactory.create(mod, type, IDevcEditor.Mode.CREATE, -1);
                return editor;
            });
        }

        public NewDeviceAction(String title, Class<T> type, Icon icon, Function<PyroMod, ? extends IDevcEditor<T>> editor) {
            super(title, icon);
            this.d_class = type;
            this.d_editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = PyroSim.getApp();
            PyroMod pyMod = pySim.getMediator();
            DeviceDlg<T> dlg = DeviceActions.newDevcDlg(this.d_class, this.d_editor);
            if (dlg == null) {
                return;
            }
            if (dlg.doModal() == 1) {
                Collection<T> obj = dlg.save(null);
                SelectTask wrapper = new SelectTask(pyMod, obj);
                wrapper.addTask(new AddTask<T>((IPyroObject)pyMod.getDevices(), obj));
                wrapper.addTask(dlg.getBundledUpdates(pyMod, obj));
                pyMod.getTaskManager().exec(wrapper, Intl.intl("New Device"));
            }
        }
    }
}

