/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.gui.CloudFDSDlg;

public class CloudFDSUtil {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(20L)).build();
    private static final Logger LOGGER = Logger.getLogger(CloudFDSUtil.class.getName());
    @Deprecated
    public static final String API_VERSION_v1 = "v1";
    public static final String API_VERSION_v2 = "v2";

    public static FDS_FEA_STATUS getStatusFromCode(long code) {
        for (FDS_FEA_STATUS status : FDS_FEA_STATUS.values()) {
            if ((long)status.code != code) continue;
            return status;
        }
        assert (false);
        return null;
    }

    public static String getFolderName(File outfile) {
        return outfile.getName() + "_" + System.currentTimeMillis();
    }

    public static String getUploadLocation(File outfile, String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws HttpException, ExecutionException, InterruptedException, ParseException {
        JSONObject payload = new JSONObject();
        payload.put("dirname", CFDFEAFolder);
        payload.put("filename", outfile.getName());
        payload.put("contentType", "application/octet-stream");
        String jsonString = payload.toString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, "storage/upload-url").POST(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return ((JSONObject)CloudFDSUtil.parseResponse(response)).get("url").toString();
    }

    public static void uploadFile(String gfcFolder, File outFile) throws IOException, ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(gfcFolder)).PUT(HttpRequest.BodyPublishers.ofFile(outFile.toPath())).timeout(Duration.ofMinutes(2L)).header("Content-Type", "application/octet-stream").build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
    }

    public static String getDownloadMetadata(long id) throws IOException, ParseException, ExecutionException, InterruptedException {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, String.format("storage/download/%d", id)).GET().build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 302);
        return response.headers().firstValue("location").orElse(null);
    }

    public static JSONObject getSimulationResults(String folderName) throws IOException, ParseException, ExecutionException, InterruptedException {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        JSONObject payload = new JSONObject();
        payload.put("path", folderName + "/FDS.tar.gz");
        String jsonString = payload.toJSONString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "storage/view-by-path").POST(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return (JSONObject)CloudFDSUtil.parseResponse(response);
    }

    private static CompletableFuture<HttpResponse<String>> getCPUOptions() {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "simulation/view-cpu").GET().build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    private static CompletableFuture<HttpResponse<String>> getMemOptions() {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "simulation/view-ram").GET().build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public static SimOptions getSimOptions() {
        CompletableFuture<HttpResponse<String>> cpu = CloudFDSUtil.getCPUOptions();
        CompletableFuture<HttpResponse<String>> mem = CloudFDSUtil.getMemOptions();
        CompletableFuture.allOf(cpu, mem).join();
        ArrayList<Integer> cpuArray = new ArrayList<Integer>();
        ArrayList<String> memArray = new ArrayList<String>();
        Function<CompletableFuture, JSONArray> func = future -> {
            try {
                HttpResponse response = (HttpResponse)future.get();
                CloudFDSUtil.validateStatus(response, 200);
                return (JSONArray)CloudFDSUtil.parseResponse(response);
            }
            catch (InterruptedException | ExecutionException | ParseException | HttpException exception) {
                return new JSONArray();
            }
        };
        func.apply(cpu).forEach(obj -> cpuArray.add(((Number)obj).intValue()));
        func.apply(mem).forEach(obj -> memArray.add((String)obj));
        return new SimOptions(cpuArray, memArray);
    }

    public static long startSim(String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws ExecutionException, InterruptedException, HttpException, ParseException {
        JSONObject payload = new JSONObject();
        payload.put("cpu", String.valueOf(params.numCores));
        payload.put("ram", params.ramOpt);
        payload.put("nopre", 1);
        payload.put("folder", CFDFEAFolder);
        payload.put("script", params.version.value);
        payload.put("source", "pyrosim_" + "2026.1.211".replace(".", "-"));
        String jsonString = payload.toJSONString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, "simulation/add").POST(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200, new StartSimException(Integer.toString(response.statusCode()), response.body(), jsonString));
        return (Long)CloudFDSUtil.parseResponse(response);
    }

    public static void stopSim(CloudFDSDlg.CFD_FEA_Params params, long id, boolean force) throws ExecutionException, InterruptedException, HttpException {
        JSONObject payload = new JSONObject();
        payload.put("signal", force ? "SIGINT" : "SIGTSTP");
        String jsonString = payload.toJSONString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, String.format("simulation/stop/%d", id)).PUT(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
    }

    public static JSONArray getSimsList(String apiKey) throws ExecutionException, InterruptedException, HttpException, ParseException {
        assert (!apiKey.isEmpty());
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "simulation/index-short/id/desc/1").GET().build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return (JSONArray)CloudFDSUtil.parseResponse(response);
    }

    private static HttpRequest.Builder getRequestBuilder(String apiKey, String route) {
        return HttpRequest.newBuilder().uri(URI.create(String.format("%s/api/%s/%s", CLOUD_PROVIDERS.CFD_FEA.URI, API_VERSION_v2, route))).timeout(Duration.ofMinutes(2L)).header("Content-Type", "application/json").headers("Accept", "application/json").header("X-API-key", apiKey);
    }

    private static void validateStatus(HttpResponse<String> response, int expectedStatus) throws HttpException {
        if (response.statusCode() != expectedStatus) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject object = (JSONObject)parser.parse(response.body());
                JSONArray errors = (JSONArray)object.get("errors");
                if (errors != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Object error : errors) {
                        sb.append(String.format("\n %s", error.toString()));
                    }
                    throw new HttpException(String.format("HTTP %s: %s", response.statusCode(), sb));
                }
            }
            catch (ParseException e) {
                CloudFDSUtil.validateStatus(response, expectedStatus, new HttpException(String.format(Intl.intl("Request failed: %d"), expectedStatus)));
            }
        }
    }

    private static void validateStatus(HttpResponse<String> response, int expectedStatus, HttpException exception) throws HttpException {
        if (response.statusCode() != expectedStatus) {
            throw exception;
        }
    }

    private static Object parseResponse(HttpResponse<String> response) throws ParseException {
        JSONParser parser = new JSONParser();
        return ((JSONObject)parser.parse(response.body())).get("response");
    }

    public static enum FDS_FEA_STATUS {
        COMPLETED(10),
        ERROR(60),
        PENDING(20),
        RUNNING(30),
        STOPPING(40),
        STOPPED(50);

        public final int code;

        private FDS_FEA_STATUS(int code) {
            this.code = code;
        }
    }

    public static class SimOptions {
        public Collection<Integer> cpuOptions;
        public Collection<String> memoryOptions;

        public SimOptions(Collection<Integer> cpuOptions, Collection<String> memoryOptions) {
            this.cpuOptions = cpuOptions;
            this.memoryOptions = memoryOptions;
        }
    }

    public static class StartSimException
    extends HttpException {
        private static final long serialVersionUID = 1L;
        public final String responseEntityStr;
        public final String requestEntityStr;

        public StartSimException(String statusLineStr, String responseEntityStr, String requestEntityStr) {
            super(statusLineStr);
            this.responseEntityStr = responseEntityStr;
            this.requestEntityStr = requestEntityStr;
        }
    }

    public static class HttpException
    extends IOException {
        public HttpException() {
        }

        public HttpException(String message) {
            super(message);
        }
    }

    public static enum CLOUD_PROVIDERS {
        CFD_FEA("CFD FEA", "https://cloud.cfdfeaservice.it");

        public final String name;
        public final String URI;

        private CLOUD_PROVIDERS(String serviceName, String URI2) {
            this.name = serviceName;
            this.URI = URI2;
        }

        public String toString() {
            return this.name;
        }
    }
}

