/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tags.TagsUtil;
import pyrosim.gui.actions.ComponentSensitiveAction;
import pyrosim.gui.actions.EditTagsAction;
import thunderheadeng.util.CompositeTask;

public class AddTagsAction
extends ComponentSensitiveAction {
    private static final long serialVersionUID = 1L;

    public AddTagsAction() {
        super(Intl.intl("Add Tags..."));
        this.putValue("ShortDescription", Intl.intl("Add Tags"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroSim app = PyroSim.getApp();
        PyroMod pyMod = app.getMediator();
        EditTagsAction.ReceiveTextInputDialog dlg = EditTagsAction.newAddTagsDialog(app.getActiveFrame());
        if (dlg.doModal() == 1) {
            Set<String> tagStrings = TagsUtil.splitStrings(dlg.getUserInput());
            Collection<ITaggable> taggables = pyMod.getSelectionModel().flatten(ITaggable.class);
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(pyMod);
            Set<Tag> addTags = TagsUtil.getTagsForStrings(task, pyMod.getTags(), tagStrings);
            TagsUtil.queueAddRemoveTags(task, taggables, addTags, Collections.emptySet());
            pyMod.getTaskManager().exec(task, Intl.intl("Add Tags"));
        }
    }

    @Override
    public void updateEnabled() {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        this.setEnabled(!pyMod.getSelectionModel().flatten(ITaggable.class).isEmpty());
    }
}

